/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

class GridSpinner
extends JLabel
implements MouseListener {
    private String label;
    private int value;
    private int minimum;
    private int maximum;
    private boolean isLabel;
    private boolean adjust;

    public GridSpinner(int n, int n2, String string, int n3, int n4, int n5, boolean bl) {
        this.label = string;
        this.value = n3;
        this.minimum = n4;
        this.maximum = n5;
        this.isLabel = bl;
        this.adjust = this.adjust;
        this.addMouseListener(this);
        this.setPreferredSize(new Dimension(n, n2));
        this.setFont(new Font("Monospaced", 0, 14));
        this.setHorizontalAlignment(0);
        if (bl) {
            this.setText(string);
        } else {
            this.adjustText(n3);
            this.setBorder(BorderFactory.createEtchedBorder());
        }
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.value = n;
        this.adjustText(n);
    }

    private void adjustText(int n) {
        String string = this.label;
        if (string != "") {
            string = string + " ";
            if (n >= 0) {
                string = string + " ";
            }
            if (Math.abs(n) < 10) {
                string = string + " ";
            }
        }
        this.setText(string + n);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.isLabel) {
            return;
        }
        if (mouseEvent.isShiftDown()) {
            if (this.value == this.minimum) {
                this.adjustText(this.maximum);
                this.value = this.maximum;
            } else {
                this.adjustText(--this.value);
            }
        } else if (this.value == this.maximum) {
            this.adjustText(this.minimum);
            this.value = this.minimum;
        } else {
            this.adjustText(++this.value);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

