/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

class InteractingStatesDialog
extends JDialog
implements ActionListener {
    private static int rows = 9;
    private static int columns = 9;
    private InteractingStatesGrid birthControl;
    private InteractingStatesGrid surviveControl;
    private JButton okButton;
    private JButton cancelButton;
    private boolean changed = false;

    public InteractingStatesDialog(JFrame jFrame, int n, int n2) {
        super(jFrame, "Interacting States", true);
        rows = n;
        columns = n2;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        this.birthControl = new InteractingStatesGrid(n, n2, "Birth Control");
        jPanel2.add(this.birthControl);
        this.surviveControl = new InteractingStatesGrid(n, n2, "Survival Control");
        jPanel2.add(this.surviveControl);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        this.okButton = new JButton("Ok");
        this.okButton.addActionListener(this);
        jPanel3.add(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        jPanel3.add(this.cancelButton);
        jPanel.add((Component)jPanel3, "South");
        this.getContentPane().add(jPanel);
        this.pack();
        this.setResizable(false);
        this.birthControl.requestFocus();
    }

    public void getData(InteractingStatesRule interactingStatesRule) {
        for (int i = 1; i < rows; ++i) {
            for (int j = 1; j < columns; ++j) {
                interactingStatesRule.setBirth(i - 1, j - 1, this.birthControl.getValue(i, j));
                interactingStatesRule.setSurvive(i - 1, j - 1, this.surviveControl.getValue(i, j));
            }
        }
        interactingStatesRule.setBirthRandomLimit(this.birthControl.getRandomLimit());
        interactingStatesRule.setSurviveRandomLimit(this.surviveControl.getRandomLimit());
        interactingStatesRule.setBirthOperatorSelector(this.birthControl.getOperatorSelector());
        interactingStatesRule.setSurviveOperatorSelector(this.surviveControl.getOperatorSelector());
    }

    public void setData(InteractingStatesRule interactingStatesRule) {
        for (int i = 1; i < rows; ++i) {
            for (int j = 1; j < columns; ++j) {
                this.birthControl.setValue(i, j, interactingStatesRule.getBirth(i - 1, j - 1));
                this.surviveControl.setValue(i, j, interactingStatesRule.getSurvive(i - 1, j - 1));
            }
        }
        this.birthControl.setRandomLimit(interactingStatesRule.getBirthRandomLimit());
        this.surviveControl.setRandomLimit(interactingStatesRule.getSurviveRandomLimit());
        this.birthControl.setOperatorSelector(interactingStatesRule.getBirthOperatorSelector());
        this.surviveControl.setOperatorSelector(interactingStatesRule.getSurviveOperatorSelector());
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.setVisible(false);
            this.changed = true;
        } else if (object == this.cancelButton) {
            this.setVisible(false);
            this.changed = false;
        }
    }
}

