/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

class InteractingStatesGrid
extends JPanel
implements ActionListener {
    private static final String[] operatorSelectorStrings = new String[]{"OR >=", "OR =", "AND >=", "AND ="};
    private int rows;
    private int columns;
    private GridSpinner[][] grid;
    private TextSpinner operatorSelectorSpinner;
    private JButton resetButton;
    private JButton randomButton;
    private GridSpinner randomLimit;
    private String operatorSelector;

    public InteractingStatesGrid(int n, int n2, String string) {
        this.rows = n;
        this.columns = n2;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(n, n2));
        this.grid = new GridSpinner[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                boolean bl = true;
                String string2 = "";
                if (i != 0 && j != 0) {
                    bl = false;
                } else if (i == 0 && j != 0) {
                    string2 = "" + j;
                } else if (i != 0 && j == 0) {
                    string2 = "" + i;
                }
                this.grid[i][j] = new GridSpinner(20, 20, string2, 0, 0, 8, bl);
                jPanel2.add(this.grid[i][j]);
            }
        }
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jPanel2);
        jPanel.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel();
        this.operatorSelectorSpinner = new TextSpinner(60, 20, operatorSelectorStrings);
        jPanel4.add(this.operatorSelectorSpinner);
        this.resetButton = new JButton("Reset");
        this.resetButton.addActionListener(this);
        jPanel4.add(this.resetButton);
        this.randomButton = new JButton("Random");
        this.randomButton.addActionListener(this);
        jPanel4.add(this.randomButton);
        this.randomLimit = new GridSpinner(20, 20, "", 0, 0, 8, false);
        jPanel4.add(this.randomLimit);
        jPanel.add((Component)jPanel4, "South");
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), string));
        this.add(jPanel);
    }

    public int getValue(int n, int n2) {
        return this.grid[n][n2].getValue();
    }

    public void setValue(int n, int n2, int n3) {
        this.grid[n][n2].setValue(n3);
    }

    public int getRandomLimit() {
        return this.randomLimit.getValue();
    }

    public void setRandomLimit(int n) {
        this.randomLimit.setValue(n);
    }

    public String getOperatorSelector() {
        return this.operatorSelectorSpinner.getText();
    }

    public void setOperatorSelector(String string) {
        for (int i = 0; i < operatorSelectorStrings.length; ++i) {
            if (!operatorSelectorStrings[i].equals(string)) continue;
            this.operatorSelectorSpinner.setText(string);
            this.operatorSelectorSpinner.setSelectedIndex(i);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.resetButton) {
            for (int i = 1; i < this.rows; ++i) {
                for (int j = 1; j < this.columns; ++j) {
                    this.grid[i][j].setValue(0);
                }
            }
        } else if (object == this.randomButton) {
            for (int i = 1; i < this.rows; ++i) {
                this.grid[i][(int)(Math.random() * (double)(this.columns - 1)) + 1].setValue((int)(Math.random() * (double)(this.randomLimit.getValue() + 1)));
                this.grid[i][(int)(Math.random() * (double)(this.columns - 1)) + 1].setValue((int)(Math.random() * (double)(this.randomLimit.getValue() + 1)));
            }
        }
        this.operatorSelectorSpinner.requestFocus();
    }
}

