// The rule has the following states:
//  0 background
//  1 stream moving northwest
//  2 stream moving northeast
//  3 stream moving southeast
//  4 stream moving southwest
//  5 .. 6 gate posts
//  7 .. 22 gate selectors

import java.lang.*; 
import java.util.*; 
import java.io.*; 

public class DiagonalParticleStreamsRule extends abstractcellautorulefamily
{ 
	private int NW;
	private int N;
	private int NE;
	private int W;
	private int C;
	private int E;
	private int SW;
	private int S;
	private int SE;
	
	private int r;

  DiagonalParticleStreamsRule(String name)
	{ 
   super(name); 
  }
	
  int getbordersize()
	{ 
    return 1; 
  }

	public boolean Gate()
	{
    if ((SW == 5) && (S >= 7) && (S <= 22))
    {
      r = lookup(NW, W, S - 7) * 3;
      return true;
    }
    else if ((NW == 6) && (N >= 7) && (N <= 22))
		{
      r = lookup(W, SW, N - 7) * 2;
      return true;
    }
    else if ((NW == 5) && (W >= 7) && (W <= 22))
		{
      r = lookup(NE, N, W - 7) * 4;
      return true;
    }
    else if ((NE == 6) && (E >= 7) && (E <= 22))
		{
      r = lookup(N, NW, E - 7) * 3;
      return true;
    }
    else if ((NE == 5) && (N >= 7) && (N <= 22))
		{
      r = lookup(SE, E, N - 7);
      return true;
    }
    else if ((SE == 6) && (S >= 7) && (S <= 22))
		{
      r = lookup(E, NE, S - 7) * 4;
      return true;
    }
    else if ((SE == 5) && (E >= 7) && (E <= 22))
		{
      r = lookup(SW, S, E - 7) * 2;
      return true;
    }
    else if ((SW == 6) && (W >= 7) && (W <= 22))
		{	
      r = lookup(S, SE, W - 7);
      return true;
    }
    return false;
	}

	public int lookup(int a, int b, int i)
	{
    int[][] t = {{0, 0, 0, 0},
                 {0, 0, 0, 1},
                 {0, 0, 1, 0},
                 {0, 0, 1, 1},
                 {0, 1, 0, 0},
                 {0, 1, 0, 1},
                 {0, 1, 1, 0},
                 {0, 1, 1, 1},
                 {1, 0, 0, 0},
                 {1, 0, 0, 1},
                 {1, 0, 1, 0},
                 {1, 0, 1, 1},
                 {1, 1, 0, 0},
                 {1, 1, 0, 1},
                 {1, 1, 1, 0},
              	 {1, 1, 1, 1}};
    int j;
    if (a == 0)
			j = 0;
    else
      j = 2;
    if (b != 0)
      j++;
    return t[i][j];
	}
	
  int calcsq(cellautorulec c, boardc b, int x, int y, int t)
	{ 
    NW = b.getsq(x - 1, y - 1);
    N  = b.getsq(x    , y - 1);
    NE = b.getsq(x + 1, y - 1);
    W  = b.getsq(x - 1, y    );
    C  = b.getsq(x    , y    );
    E  = b.getsq(x + 1, y    );
    SW = b.getsq(x - 1, y + 1);
    S  = b.getsq(x    , y + 1);
    SE = b.getsq(x + 1, y + 1);
    if ((C >= 5) && (C <= 22))
      return C;
    if (Gate())
			return r;
    if (C == 0)
      if ((SE == 1) && (NE != 4))
        return 1;
      else if (SW == 2)
        return 2;
      else if (NW == 3)
        return 3;
      else if (NE == 4)
        return 4;
    if ((C == 1) && (SE == 1))
      return 1;
    if ((C == 2) && (SW == 2))
      return 2;
    if ((C == 3) && (NW == 3))
      return 3;
    if ((C == 4) && (NE == 4))
      return 4;
    return 0;
  } 
} 
