import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

class InteractingStatesRule extends abstractcellautorulefamily
{
  private static final int rows = 8;
  private static final int columns = 8;

  private InteractingStatesDialog interactingStatesDialog;
	private int birth[][];
	private int survive[][];
	private int birthRandomLimit;
	private int surviveRandomLimit;
	private String birthOperatorSelector;
	private String surviveOperatorSelector;

	public InteractingStatesRule(String name)
	{
		super(name);
		birth = new int[rows][columns];
		survive = new int[rows][columns];
		birthRandomLimit = 3;
		surviveRandomLimit = 1;
		birthOperatorSelector = "OR >=";
		surviveOperatorSelector = "OR =";
	}

        int getbordersize() {
          return 1;
        }

	public int getBirth(int row, int column)
	{
		return birth[row][column];
	}

	public int getSurvive(int row, int column)
	{
		return survive[row][column];
	}

	public int getBirthRandomLimit()
	{
		return birthRandomLimit;
	}

	public int getSurviveRandomLimit()
	{
		return surviveRandomLimit;
	}

  public String getBirthOperatorSelector()
	{
		return birthOperatorSelector;
	}

  public String getSurviveOperatorSelector()
	{
		return surviveOperatorSelector;
	}

	public void setBirth(int row, int column, int value)
	{
		birth[row][column] = value;
	}

	public void setSurvive(int row, int column, int value)
	{
		survive[row][column] = value;
	}

	public void setBirthRandomLimit(int value)
	{
		birthRandomLimit = value;
	}

	public void setSurviveRandomLimit(int value)
	{
		surviveRandomLimit = value;
	}

  public void setBirthOperatorSelector(String value)
	{
		birthOperatorSelector = value;
	}

  public void setSurviveOperatorSelector(String value)
	{
		surviveOperatorSelector = value;
	}

	private void centerDialog(JDialog dialog)
	{
		Toolkit k = Toolkit.getDefaultToolkit();
		Dimension s = k.getScreenSize();
		int x = (int)(s.getWidth() - dialog.getWidth()) / 2;
		int y = (int)(s.getHeight() - dialog.getHeight()) / 2;
		dialog.setLocation(x, y);
	}

  public int calcsq(cellautorulec a,boardc b,int x, int y, int t)
	{
		int neighbors[] =
		{
      b.getsq(x - 1, y - 1),
      b.getsq(x    , y - 1),
      b.getsq(x + 1, y - 1),
      b.getsq(x - 1, y    ),
      b.getsq(x + 1, y    ),
      b.getsq(x - 1, y + 1),
      b.getsq(x    , y + 1),
      b.getsq(x + 1, y + 1)
		};
    int cell = b.getsq(x, y);
		int counts[] = new int[columns];
		for (int i = 0; i < columns; i++)
			if (neighbors[i] > 0)
			  counts[neighbors[i] - 1]++;
    if (cell == 0)
		{
      if (birthOperatorSelector.equals("OR >="))
			{
        for (int r = 0; r < rows; r++)
					for (int c = 0; c < columns; c++)
            if ((birth[r][c] > 0) && (counts[c] >= birth[r][c]))
							return r + 1;
			}
      else if (birthOperatorSelector.equals("OR ="))
			{
        for (int r = 0; r < rows; r++)
					for (int c = 0; c < columns; c++)
            if ((birth[r][c] > 0) && (counts[c] == birth[r][c]))
							return r + 1;
			}
      else if (birthOperatorSelector.equals("AND >="))
			{
        for (int r = 0; r < rows; r++)
				{
					int n = 0;
					for (int c = 0; c < columns; c++)
            if (birth[r][c] > 0)
					  {
							n = r + 1;
							break;
						}
					if (n == 0)
						break;
					for (int c = 0; c < columns; c++)
            if ((birth[r][c] > 0) && (counts[c] < birth[r][c]))
					  {
              n = 0;
							break;
						}
					if (n > 0)
					  return n;
				}
			}
      else if (birthOperatorSelector.equals("AND ="))
			{
        for (int r = 0; r < rows; r++)
				{
					int n = 0;
					for (int c = 0; c < columns; c++)
            if (birth[r][c] > 0)
					  {
							n = r + 1;
							break;
						}
					if (n == 0)
						break;
					for (int c = 0; c < columns; c++)
            if ((birth[r][c] > 0) && (counts[c] != birth[r][c]))
					  {
							n = 0;
							break;
						}
					if (n > 0)
					  return n;
				}
			}
			return 0;
		}
		else
		{
			int r = cell - 1;
      if (surviveOperatorSelector.equals("OR >="))
			{
				for (int c = 0; c < columns; c++)
					if ((survive[r][c] > 0) && (counts[c] >= survive[r][c]))
						return cell;
			}
      else if (surviveOperatorSelector.equals("OR ="))
			{
				for (int c = 0; c < columns; c++)
					if ((survive[r][c] > 0) && (counts[c] == survive[r][c]))
						return cell;
		  }
      else if (surviveOperatorSelector.equals("AND >="))
			{
				int n = 0;
				for (int c = 0; c < columns; c++)
					if (survive[r][c] > 0)
					{
						n = cell;
						break;
					}
				if (n == 0)
					return 0;
				for (int c = 0; c < columns; c++)
          if ((survive[r][c] > 0) && (counts[c] < survive[r][c]))
						return 0;
				return n;
			}
      else if (surviveOperatorSelector.equals("AND ="))
			{
				int n = 0;
				for (int c = 0; c < columns; c++)
					if (survive[r][c] > 0)
				  {
						n = cell;
						break;
					}
				if (n == 0)
					return 0;
				for (int c = 0; c < columns; c++)
          if ((survive[r][c] > 0) && (counts[c] != survive[r][c]))
						return 0;
				return n;
			}
		  return 0;
		}
	}

	public void showoptions()
	{
	  interactingStatesDialog = new InteractingStatesDialog(null,rows+1,columns+1);
	  interactingStatesDialog.setData(this);
	  centerDialog(interactingStatesDialog);
	  interactingStatesDialog.setVisible(true);
     if (interactingStatesDialog.hasChanged())
		  interactingStatesDialog.getData(this);
	}
       int get_min_colors() {
         return rows+1;
       }
       void update_new_color(cellautorulec c,int i) {
         c.setcellvaluecolor(i,new Color(255,128,0));
         c.setcellvalue(i,0);
       }
       boolean is_background_tile_optimization_on() {
         return true;
       }



	private String makeDataString(int[][] optionGrid, int randomLimit, String operatorSelector)
	{
		String s = "";
		for (int r = 0; r < rows; r++)
		{
			for (int c = 0; c <columns; c++)
		    s += optionGrid[r][c];
			s += ",";
		}
		s += randomLimit + "," + operatorSelector;
		return s;
	}

	private void setRule(String[] s, int offset, int[][] rule)
	{
		for (int r = 0; r < rows; r++)
			for (int c = 0; c < columns; c++)
				rule[r][c] = (int)(s[r + offset].charAt(c) - '0');
	}

	public void writelines(Vector outputVector)
	{
		String birthData = makeDataString(birth, birthRandomLimit, birthOperatorSelector);
		String surviveData = makeDataString(survive, surviveRandomLimit, surviveOperatorSelector);
		outputVector.add(birthData + "," + surviveData);
  }

	public void readline(String inputString)
	{
		String s[] = inputString.split(",");
		setRule(s, 0, birth);
		birthRandomLimit = (int)(s[8].charAt(0) - '0');
		birthOperatorSelector = s[9];
		setRule(s, 10, survive);
		surviveRandomLimit = (int)(s[18].charAt(0) - '0');
		surviveOperatorSelector = s[19];
  }
}

class InteractingStatesDialog extends JDialog implements ActionListener
{
	private static int rows = 9;
	private static int columns = 9;
	private InteractingStatesGrid birthControl;
	private InteractingStatesGrid surviveControl;
	private JButton okButton;
	private JButton cancelButton;
	private boolean changed = false;

	public InteractingStatesDialog(JFrame owner,int rows,int columns)
	{
		super(owner, "Interacting States", true);
                this.rows = rows;
                this.columns = columns;
		JPanel basePanel = new JPanel();
		basePanel.setLayout(new BorderLayout());
		JPanel gridPanel = new JPanel();
		birthControl = new InteractingStatesGrid(rows, columns, "Birth Control");
		gridPanel.add(birthControl);
		surviveControl = new InteractingStatesGrid(rows, columns, "Survival Control");
		gridPanel.add(surviveControl);
		basePanel.add(gridPanel, BorderLayout.CENTER);
		JPanel buttonPanel = new JPanel();
		buttonPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
		okButton = new JButton("Ok");
		okButton.addActionListener(this);
		buttonPanel.add(okButton);
		cancelButton = new JButton("Cancel");
		cancelButton.addActionListener(this);
		buttonPanel.add(cancelButton);
		basePanel.add(buttonPanel, BorderLayout.SOUTH);
		getContentPane().add(basePanel);
		pack();
		setResizable(false);
		birthControl.requestFocus();
	}

	public void getData(InteractingStatesRule rule)
	{
		for (int r = 1; r < rows; r++)
			for (int c = 1; c < columns; c++)
		  {
				rule.setBirth(r - 1, c - 1, birthControl.getValue(r, c));
				rule.setSurvive(r - 1, c - 1, surviveControl.getValue(r, c));
			}
		rule.setBirthRandomLimit(birthControl.getRandomLimit());
		rule.setSurviveRandomLimit(surviveControl.getRandomLimit());
		rule.setBirthOperatorSelector(birthControl.getOperatorSelector());
		rule.setSurviveOperatorSelector(surviveControl.getOperatorSelector());
	}

	public void setData(InteractingStatesRule rule)
	{
		for (int r = 1; r < rows; r++)
			for (int c = 1; c < columns; c++)
		  {
				birthControl.setValue(r, c, rule.getBirth(r - 1, c - 1));
				surviveControl.setValue(r, c, rule.getSurvive(r - 1, c - 1));
			}
		birthControl.setRandomLimit(rule.getBirthRandomLimit());
		surviveControl.setRandomLimit(rule.getSurviveRandomLimit());
		birthControl.setOperatorSelector(rule.getBirthOperatorSelector());
		surviveControl.setOperatorSelector(rule.getSurviveOperatorSelector());
	}

	public boolean hasChanged()
	{
		return changed;
	}

	public void actionPerformed(ActionEvent e)
	{
		Object source = e.getSource();
		if (source == okButton)
		{
			setVisible(false);
			changed = true;
		}
		else if (source == cancelButton)
		{
			setVisible(false);
			changed = false;
		}
	}
}

class InteractingStatesGrid extends JPanel implements ActionListener
{
	private static final String[] operatorSelectorStrings = {"OR >=", "OR =", "AND >=", "AND ="};
	
	private int rows;
	private int columns;
  private GridSpinner grid[][];
	private TextSpinner operatorSelectorSpinner;
	private JButton resetButton;
	private JButton randomButton;
  private GridSpinner randomLimit;
	private String operatorSelector;

  public InteractingStatesGrid(int rows, int columns, String title)
	{
		this.rows = rows;
		this.columns = columns;
		JPanel basePanel = new JPanel();
		basePanel.setLayout(new BorderLayout());
		JPanel gridPanel = new JPanel();
		gridPanel.setLayout(new GridLayout(rows, columns));
    grid = new GridSpinner[rows][columns];
		for (int r = 0; r < rows; r++)
			for (int c = 0; c < columns; c++)
		  {
				boolean isLabel = true;
				String label = "";
				if ((r != 0) && (c != 0))
					isLabel = false;
				else if ((r == 0) && (c != 0))
					label = "" + c;
				else if ((r != 0) && (c == 0))
					label = "" + r;
        grid[r][c] = new GridSpinner(20, 20, label, 0, 0, 8, isLabel);
				gridPanel.add(grid[r][c]);
			}
		JPanel centerPanel = new JPanel();
		centerPanel.add(gridPanel);
		basePanel.add(centerPanel, BorderLayout.CENTER);
		JPanel buttonPanel = new JPanel();
		operatorSelectorSpinner = new TextSpinner(60, 20, operatorSelectorStrings);
		buttonPanel.add(operatorSelectorSpinner);
		resetButton = new JButton("Reset");
		resetButton.addActionListener(this);
		buttonPanel.add(resetButton);
		randomButton = new JButton("Random");
		randomButton.addActionListener(this);
		buttonPanel.add(randomButton);
		randomLimit = new GridSpinner(20, 20, "", 0, 0, 8, false);
		buttonPanel.add(randomLimit);
		basePanel.add(buttonPanel, BorderLayout.SOUTH);
		setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title));
		add(basePanel);
  }

	public int getValue(int r, int c)
	{
		return grid[r][c].getValue();
	}

	public void setValue(int r, int c, int value)
	{
		grid[r][c].setValue(value);
	}

	public int getRandomLimit()
	{
		return randomLimit.getValue();
	}

	public void setRandomLimit(int value)
	{
		randomLimit.setValue(value);
	}

	public String getOperatorSelector()
	{
		return operatorSelectorSpinner.getText();
	}

	public void setOperatorSelector(String value)
	{
		for (int i = 0; i < operatorSelectorStrings.length; i++)
		{
			if (operatorSelectorStrings[i].equals(value))
			{
		    operatorSelectorSpinner.setText(value);
				operatorSelectorSpinner.setSelectedIndex(i);
			}
		}
	}

	public void actionPerformed(ActionEvent e)
	{
		Object source = e.getSource();
		if (source == resetButton)
		{
      for (int r = 1; r < rows; r++)
			  for (int c = 1; c < columns; c++)
					grid[r][c].setValue(0);
		}
		else if (source == randomButton)
		{
      for (int r = 1; r < rows; r++)
			{
				grid[r][(int)(Math.random() * (columns - 1)) + 1].setValue((int)(Math.random() * (randomLimit.getValue() + 1)));
				grid[r][(int)(Math.random() * (columns - 1)) + 1].setValue((int)(Math.random() * (randomLimit.getValue() + 1)));
			}
		}
		operatorSelectorSpinner.requestFocus();
	}
}

class GridSpinner extends JLabel implements MouseListener
{
	private String label;
	private int value;
	private int minimum;
	private int maximum;
	private boolean isLabel;
	private boolean adjust;

	public GridSpinner(int height, int width, String label, int value, int minimum, int maximum, boolean isLabel)
	{
		this.label = label;
		this.value = value;
		this.minimum = minimum;
		this.maximum = maximum;
		this.isLabel = isLabel;
		this.adjust = adjust;
		addMouseListener(this);
    setPreferredSize(new Dimension(height, width));
		setFont(new Font("Monospaced", Font.PLAIN, 14));
		setHorizontalAlignment(CENTER);
		if (isLabel)
		  setText(label);
		else
		{
			adjustText(value);
		  setBorder(BorderFactory.createEtchedBorder());
		}
	}

	public int getValue()
	{
		return value;
	}

	public void setValue(int i)
	{
		value = i;
		adjustText(i);
	}
	
	private void adjustText(int value)
	{
		String l = label;
		if (l != "")
		{
			l += " ";
			if (value >= 0)
				l += " ";
		  if (Math.abs(value) < 10)
				l += " ";
		}
	  setText(l + value);
	}

	public void mousePressed(MouseEvent e)
  {
		if (isLabel)
			return;
		if (e.isShiftDown())
		{
			if (value == minimum)
			{
				adjustText(maximum);
				value = maximum;
			}
			else
		    adjustText(--value);
		}
		else
		{
			if (value == maximum)
			{
				adjustText(minimum);
				value = minimum;
			}
			else
		    adjustText(++value);
		}
	}

	public void mouseExited(MouseEvent e) {}
	public void mouseClicked(MouseEvent e) {}
	public void mouseEntered(MouseEvent e) {}
	public void mouseReleased(MouseEvent e) {}
}

class TextSpinner extends JLabel implements MouseListener
{
	private String[] textArray;
	private int selectedIndex;

  public TextSpinner(int height, int width, String[] textArray)
  {
		super("", CENTER);
		this.textArray = textArray;
		addMouseListener(this);
    setPreferredSize(new Dimension(height, width));
		setBorder(BorderFactory.createEtchedBorder());
		selectedIndex = 0;
  }

	public void setSelectedIndex(int value)
	{
		selectedIndex = value;
	}

	public void mousePressed(MouseEvent e)
  {
		selectedIndex = (selectedIndex + 1) % textArray.length;
		setText(textArray[selectedIndex]);
	}

	public void mouseExited(MouseEvent e) {}
	public void mouseClicked(MouseEvent e) {}
	public void mouseEntered(MouseEvent e) {}
	public void mouseReleased(MouseEvent e) {}
}
