import java.lang.*;
import java.util.*;
import java.io.*;

import javax.swing.*;                                           
 

import java.awt.*;
import java.awt.event.*;                                                  

class Library_plugin implements ActionListener {
  static Library_plugin plugin = null;
  static Library_dialog dialog = null;
  
  static void init() {
    new Library_plugin();
  }
  Library_plugin() {
    dialog = null;
    JMenuBar mb = cellautoapp.mainmenu;
    JMenuItem mi = new JMenuItem("Pattern Library");
    cellautoapp.viewmenu.add(mi);
    mi.setActionCommand("Pattern_Library_show");
    mi.addActionListener(this);    
    plugin = this;
    
  }
  public void actionPerformed(ActionEvent e) {  
    String action = e.getActionCommand();
    if (action.equals("Pattern_Library_show")) {
      if (dialog == null) {
        dialog = new Library_dialog("Pattern Library");
        dialog.setBounds(0,0,400,150);        
      }
      dialog.setVisible(true);
    }
  }
}
class Library_pattern {
  int width;
  int height;
  byte pattern_data[][];
  String name;
  String description;
  Library_pattern(int w,int h) {
    width = w;
    height = h;
    pattern_data = new byte[w][h];
  }
  void write(int x,int y,int a) {
    byte b = 0;
    if (a >= 128) {b = (byte) (a-256);}
    else {b = (byte) a;}
    pattern_data[x][y] = b;
  }
  int read(int x,int y) {
    int a = (int) pattern_data[x][y];
    if (a < 0) {a = a + 256;}
    return a;
  }
  static Library_pattern new_pattern_from_selection() {
    if ((cellautoapp.selw > 0) & (cellautoapp.selh > 0)){    
    Library_pattern p = new Library_pattern(cellautoapp.selw,cellautoapp.selh);
    for (int x = 0;x < cellautoapp.selw;x++) {
      for (int y = 0;y < cellautoapp.selh;y++) {
        int a = cellautoapp.seldata[x][y];
        p.write(x,y,a);
      }
    }
    return p;
    } else {
      return null;
    }
  }
  void paste_pattern_to_selection() {
    //cellautoapp.selw = width;
    //cellautoapp.selh = height;
    cellautoapp.selx1 = cellautoapp.offsetx;
    cellautoapp.sely1 = cellautoapp.offsety;
    cellautoapp.selx2 = cellautoapp.offsetx + width;
    cellautoapp.sely2 = cellautoapp.offsety + height;
    cellautoapp.setupsel();
    cellautoapp.seldata = new int[width][height];    
    for (int x = 0;x < cellautoapp.selw;x++) {
      for (int y = 0;y < cellautoapp.selh;y++) {
        cellautoapp.seldata[x][y] = read(x,y);
      }
    }
  }
}

class Library_dialog extends JFrame implements ActionListener, MouseListener, KeyListener {
  JList listbox;
  JButton button1;
  JButton button2;
  JButton button3;
  JButton button4;
  JScrollPane listboxscroller;
  DefaultListModel list;
  Vector patlist;
  String filename;
  long last_time;
  add_pattern_dialogc add_pattern_dialog;
  lib_description_winc lib_description_win;
Library_dialog(String name) {
  super(name);
  System.out.println("library dialog init"); 
 patlist = new Vector();
  list = new DefaultListModel();  
  listbox = new JList(list);
  listboxscroller = new JScrollPane(listbox);
  listbox.addMouseListener(this);
  listbox.addKeyListener(this);
  button1 = new JButton("new/load library");
  button1.setActionCommand("load_library");
  button1.addActionListener(this);
  button4 = new JButton("show description");
  button4.setActionCommand("description");
  button4.addActionListener(this);
  
  button2 = new JButton("load pattern");
  button2.setActionCommand("load_pattern");
  button2.addActionListener(this);
  button3 = new JButton("add pattern");
  button3.setActionCommand("add_pattern");
  button3.addActionListener(this);

  button2.setEnabled(false);
  button3.setEnabled(false);
  button4.setEnabled(false);
  
  SpringLayout spl = new SpringLayout();
  this.getContentPane().setLayout(spl);
  spl.putConstraint(SpringLayout.EAST,listboxscroller,-2,SpringLayout.EAST,this.getContentPane());
  spl.putConstraint(SpringLayout.WEST,listboxscroller,2,SpringLayout.WEST,this.getContentPane());
  
  //spl.putConstraint(SpringLayout.NORTH,button2,0,SpringLayout.SOUTH,listboxscroller);
  //spl.putConstraint(SpringLayout.NORTH,button3,0,SpringLayout.SOUTH,listboxscroller);
  //spl.putConstraint(SpringLayout.NORTH,button1,0,SpringLayout.SOUTH,listboxscroller);
  //spl.putConstraint(SpringLayout.NORTH,button4,0,SpringLayout.SOUTH,listboxscroller);    
  
  //spl.putConstraint(SpringLayout.NORTH,button1,0,SpringLayout.SOUTH,button2);
  //spl.putConstraint(SpringLayout.NORTH,button4,0,SpringLayout.SOUTH,button2);
  
  
  //spl.putConstraint(SpringLayout.SOUTH,button2,0,SpringLayout.NORTH,button1);
  //spl.putConstraint(SpringLayout.SOUTH,button3,0,SpringLayout.NORTH,button1);
  spl.putConstraint(SpringLayout.SOUTH,button2,0,SpringLayout.SOUTH,this.getContentPane());
  spl.putConstraint(SpringLayout.SOUTH,button3,0,SpringLayout.SOUTH,this.getContentPane());  
  spl.putConstraint(SpringLayout.SOUTH,button1,0,SpringLayout.SOUTH,this.getContentPane());
  spl.putConstraint(SpringLayout.SOUTH,button4,0,SpringLayout.SOUTH,this.getContentPane());

  spl.putConstraint(SpringLayout.WEST,button1,0,SpringLayout.WEST,this.getContentPane());
  spl.putConstraint(SpringLayout.WEST,button2,0,SpringLayout.EAST,button1);
  spl.putConstraint(SpringLayout.WEST,button3,0,SpringLayout.EAST,button2);
  spl.putConstraint(SpringLayout.WEST,button4,0,SpringLayout.EAST,button3);
    
  //spl.putConstraint(SpringLayout.WEST,button1,0,SpringLayout.WEST,this.getContentPane());
  //spl.putConstraint(SpringLayout.WEST,button2,0,SpringLayout.WEST,this.getContentPane());
  //spl.putConstraint(SpringLayout.WEST,button3,0,SpringLayout.EAST,button2);
  //spl.putConstraint(SpringLayout.WEST,button4,0,SpringLayout.EAST,button1);
  spl.putConstraint(SpringLayout.SOUTH,listboxscroller,-2,SpringLayout.NORTH,button2);
  spl.putConstraint(SpringLayout.NORTH,listboxscroller,2,SpringLayout.NORTH,this.getContentPane());
    
  this.getContentPane().add(listboxscroller);
  this.getContentPane().add(button1);
  this.getContentPane().add(button2);
  this.getContentPane().add(button3);
  this.getContentPane().add(button4);
  this.pack();

}
  void load_selected_pattern(int i) {
    if (i >= 0) {
      Library_pattern p = (Library_pattern) patlist.get(i);
      p.paste_pattern_to_selection();
      cellautoapp.cellautomainwindow.repaint();
    }  
  }
  void read_patterns() {
    try {
      int pat_x = 0;
      int pat_y = 0;
      int pat_width = 0;
      int pat_height = 0;
      String pat_name = null;
      String pat_desc = "";
      BufferedReader r = new BufferedReader(new FileReader(filename));
      String line = r.readLine();
      Library_pattern lp = null;
      while (line != null){
        String ss[] = line.split(",");
        String st = ss[0];
        if (st.equals("name")) {
	  pat_name = ss[1];
	}
	if (st.equals("clipboardsize")){
          pat_x = 0;
	  pat_y = 0;
	  pat_width = Integer.valueOf(ss[3]).intValue();
          pat_height = Integer.valueOf(ss[4]).intValue();
          lp = new Library_pattern(pat_width,pat_height);          
	  lp.name = pat_name;
   	  lp.description = pat_desc;
	  list.addElement(lp.name);
          patlist.add(lp);
	  pat_desc = "";
	}
        if (st.equals("clipboarddata")){
          pat_x = 0;
          String data = ss[1];
          int l = data.length();
          for (int i = 0;i < (l / 2);i++){
            char ch = data.charAt((i*2)+0);
            char ch2 = data.charAt((i*2)+1);
            int a = ((int )(ch - 97));
            int a2 = ((int )(ch2 - 97));
            if (pat_x < pat_width){
              if (pat_y < pat_height){
                if (((ch == ' ') & (ch2 == ' ')) | 
                    ((ch == '.') & (ch2 == '.'))){
                  lp.write(pat_x,pat_y,0);
                }else{
                  int i2 = (a*16)+a2;
                  if ((i2 >= 0) & (i2 < 256)){
                    lp.write(pat_x,pat_y,i2);
                  }
                }
              }
            }
            pat_x++;
          }
          pat_y++;
        }
	if (line.length() > 0) {
	  if (line.charAt(0) == '#') {
	    pat_desc = pat_desc + line + "\n";
	    System.out.println("description: " + line);
	  }
	}
	line = r.readLine();
        
      }
    
    } catch (Exception e2) {
        e2.printStackTrace();      
    }
    
  }
  void log_pattern(Library_pattern lp) {
    try {
      System.out.println("log pattern");
      BufferedWriter w = new BufferedWriter(new FileWriter(filename,true));
      PrintWriter p = new PrintWriter(w);
        
      p.println("name," + lp.name); 
      String descline[] = lp.description.split("\n");
      for (int i = 0;i < descline.length;i++){
        p.println("#" + descline[i]);
      }
      
      p.println("javacellautoruleclipboard,1");
      p.println("clipboardsize,0,0," + lp.width + "," + lp.height);
      System.out.println("log pattern 2");
      for (int y = 0;y < lp.height;y++){
        p.print("clipboarddata,");
        StringBuffer str = new StringBuffer();
        for (int x = 0;x < lp.width;x++){
          int a0 = lp.read(x,y);
          char ch1 = (char) ((a0 >> 4) + 97);
          char ch2 = (char) ((a0 & 15) + 97);
          if (a0 == 0){
            ch1 = '.';
            ch2 = '.';
          }
          str.append(ch1);
          str.append(ch2);
        }
        p.println(str.toString());
      }
      p.println();  
      p.println();  
      p.println();  
      p.close();
    } catch (Exception e2) {
        e2.printStackTrace();      
    }
  }
  public void actionPerformed(ActionEvent e) {  
    String action = e.getActionCommand();
    System.out.println("library action: " + action);
    if (action.equals("load_library")) {
      FileDialog f = new FileDialog(this,"new/open library",FileDialog.LOAD);
      f.show();
      if (f.getFile() != null) {
        filename = f.getDirectory() + f.getFile();
        button2.setEnabled(true);
        button3.setEnabled(true);
        button4.setEnabled(true);
        File f2 = new File(filename);
        if (f2.exists() == true){read_patterns();}
      }
    }
    if (action.equals("load_pattern")) {
      int i = listbox.getSelectedIndex();
      load_selected_pattern(i);
    }
    if (action.equals("add_pattern")) {
      Library_pattern p = Library_pattern.new_pattern_from_selection();
      if (add_pattern_dialog == null) {
        add_pattern_dialog = new add_pattern_dialogc(this,"add pattern");
      }
      add_pattern_dialog.pat = p;
      add_pattern_dialog.ld = this;
      add_pattern_dialog.setBounds(0,0,400,400);
      add_pattern_dialog.setVisible(true);    
    
    }
    if (action.equals("description")) {
      int i = listbox.getSelectedIndex();
      if (lib_description_win == null) {
        lib_description_win = new lib_description_winc("description");      
        lib_description_win.setBounds(0,0,300,300);
      }
      lib_description_win.setVisible(true);      
      if (i != -1) {
        Library_pattern p = (Library_pattern) patlist.get(i);
        if ((p != null) & (lib_description_win != null))  {        
	  lib_description_win.text.setText(p.description);
        }
      }  
    }
  
  }
  public void keyPressed(KeyEvent e){
  } 
  public void keyReleased(KeyEvent e){
    int i = listbox.getSelectedIndex();
    if (i != -1) {
      Library_pattern p = (Library_pattern) patlist.get(i);
      if ((p != null) & (lib_description_win != null))  {        
	lib_description_win.text.setText(p.description);
      }
    }
  }
  public void keyTyped(KeyEvent e){
  }
  public void mouseClicked(MouseEvent e){
    System.out.println("clicked");
    long time = System.currentTimeMillis();
    int i = listbox.getSelectedIndex();
    if ((time-last_time) <= 500) {
      load_selected_pattern(i);
    }
    last_time = time;
    if (i != -1) {
      Library_pattern p = (Library_pattern) patlist.get(i);
      if ((p != null) & (lib_description_win != null))  {        
	lib_description_win.text.setText(p.description);
      }
    }
  }
  public void mouseEntered(MouseEvent e){
    //System.out.println("entered");
  }
  public void mouseExited(MouseEvent e){
    //System.out.println("exited");
  }
  public void mousePressed(MouseEvent e){
  
  }
  public void mouseReleased(MouseEvent e){
  
  }
}
class lib_description_winc extends JFrame {
  public JScrollPane text2; 
  public JTextArea text; 
  lib_description_winc(String Title) {
    super(Title);
    text = new JTextArea();
    text2 = new JScrollPane(text);
    this.getContentPane().add(text2);
    this.pack();          
    
  }
}
class add_pattern_dialogc extends JDialog implements ActionListener {
  public JLabel name_label;
  public JTextField name_field;  
  public JLabel desc_label;
  public JScrollPane text2; 
  public JTextArea text; 
  public JButton okbutton;
  public JButton cancelbutton;
  public Library_pattern pat;
  public Library_dialog ld;
  add_pattern_dialogc(Library_dialog owner,String Title){
    super(owner,Title,true);
    ld = owner;
    SpringLayout spl = new SpringLayout();
    this.getContentPane().setLayout(spl);
    name_label = new JLabel("name: ");
    name_field = new JTextField();
    desc_label = new JLabel("description: ");
    text = new JTextArea();
    text2 = new JScrollPane(text);
    okbutton = new JButton();
    okbutton.setText("ok");
    cancelbutton = new JButton();
    cancelbutton.setText("cancel");
    //spl.putConstraint(SpringLayout.SOUTH,text2,-5,SpringLayout.NORTH,okbutton);
    spl.putConstraint(SpringLayout.SOUTH,okbutton,-5,SpringLayout.SOUTH,this.getContentPane());
    spl.putConstraint(SpringLayout.SOUTH,cancelbutton,-5,SpringLayout.SOUTH,this.getContentPane());
    spl.putConstraint(SpringLayout.SOUTH,text2,-5,SpringLayout.NORTH,okbutton);
    spl.putConstraint(SpringLayout.WEST,cancelbutton,5,SpringLayout.EAST,okbutton);
    spl.putConstraint(SpringLayout.WEST,okbutton,5,SpringLayout.WEST,this.getContentPane());
    spl.putConstraint(SpringLayout.NORTH,name_label,5,SpringLayout.NORTH,this.getContentPane());
    spl.putConstraint(SpringLayout.WEST,name_label,5,SpringLayout.WEST,this.getContentPane());
    spl.putConstraint(SpringLayout.NORTH,name_field,5,SpringLayout.NORTH,this.getContentPane());
    spl.putConstraint(SpringLayout.EAST,name_field,-5,SpringLayout.EAST,this.getContentPane());
    spl.putConstraint(SpringLayout.WEST,name_field,5,SpringLayout.EAST,name_label);
    spl.putConstraint(SpringLayout.NORTH,desc_label,5,SpringLayout.SOUTH,name_label);
    spl.putConstraint(SpringLayout.WEST,desc_label,5,SpringLayout.WEST,this.getContentPane());
    spl.putConstraint(SpringLayout.NORTH,text2,5,SpringLayout.SOUTH,desc_label);
    spl.putConstraint(SpringLayout.EAST,text2,-5,SpringLayout.EAST,this.getContentPane());
    spl.putConstraint(SpringLayout.WEST,text2,5,SpringLayout.WEST,this.getContentPane());

    okbutton.setActionCommand("okbuttonclick");
    okbutton.addActionListener(this);
    cancelbutton.setActionCommand("cancelbuttonclick");
    cancelbutton.addActionListener(this);
    //text.setText(cellautoapp.cellauto131.description);
    this.getContentPane().add(name_label);
    this.getContentPane().add(name_field);
    this.getContentPane().add(desc_label);
    this.getContentPane().add(text2);
    this.getContentPane().add(okbutton);
    this.getContentPane().add(cancelbutton);
    this.pack();     
  }
  public void actionPerformed(ActionEvent e) {  
    String action = e.getActionCommand();
    System.out.println("action: " + action);   
    if (action.equals("okbuttonclick")) {
      if (pat != null) {
        pat.name = name_field.getText();
        pat.description = text.getText();
	ld.list.addElement(pat.name);
        ld.patlist.add(pat);
        ld.log_pattern(pat);
      }
      this.setVisible(false);
    
    }
    if (action.equals("cancelbuttonclick")) {
      this.setVisible(false);
    }
  }
}



//19 2






