// The rule has the following states:
//  0 background
//  1 stream moving north
//  2 stream moving east
//  3 stream moving south
//  4 stream moving west
//  5 stream terminator
//  6 to 11 gates

import java.lang.*;
import java.util.*;
import java.io.*;

public class ParticleStreamsRule extends abstractcellautorulefamily
{
  final int G_AND = 1;
  final int G_OR = 7;
  final int G_XOR = 6;
  final int G_NAND = 14;
  final int G_NOR = 8;
  final int G_XNOR = 9;

	private int NW;
	private int N;
	private int NE;
	private int W;
	private int C;
	private int E;
	private int SW;
	private int S;
	private int SE;

	private int r;

  public ParticleStreamsRule(String name)
	{ 
    super(name);
  }

  public int getbordersize()
	{ 
    return 1;
  }

	public boolean Gate(int state, int i)
	{
    if ((S == state) &&
       ((SW == 2) || (SW == 0)) && ((SE == 4) || (SE == 0)))
    {
      r = lookup(i, SW, SE);
      return true;
    }
    else if ((W == state) &&
            ((NW == 3) || (NW == 0)) && ((SW == 1) || (SW == 0)))
    {
      r = lookup(i, NW, SW) * 2;
      return true;
    }
    else if ((N == state) &&
            ((NE == 4) || (NE == 0)) && ((NW == 2) || (NW == 0)))
    {
      r = lookup(i, NE, NW) * 3;
      return true;
    }
    else if ((E == state) &&
            ((SE == 1) || (SE == 0)) && ((NE == 3) || (NE == 0)))
    {
      r = lookup(i, SE, NE) * 4;
      return true;
    };
		return false;
	}

	public int lookup(int i, int a, int b)
	{
    int[][] t = {{0, 0, 0, 0},
                 {0, 0, 0, 1},
                 {0, 0, 1, 0},
                 {0, 0, 1, 1},
                 {0, 1, 0, 0},
                 {0, 1, 0, 1},
                 {0, 1, 1, 0},
                 {0, 1, 1, 1},
                 {1, 0, 0, 0},
                 {1, 0, 0, 1},
                 {1, 0, 1, 0},
                 {1, 0, 1, 1},
                 {1, 1, 0, 0},
                 {1, 1, 0, 1},
                 {1, 1, 1, 0},
              	 {1, 1, 1, 1}};
    int j;
    if (a == 0)
			j = 0;
    else
      j = 2;
    if (b != 0)
      j++;
    return t[i][j];
	}

  public int calcsq(cellautorulec c,boardc b,int x, int y, int t)
	{
    NW = b.getsq(x - 1, y - 1);
    N  = b.getsq(x    , y - 1);
    NE = b.getsq(x + 1, y - 1);
    W  = b.getsq(x - 1, y    );
    C  = b.getsq(x    , y    );
    E  = b.getsq(x + 1, y    );
    SW = b.getsq(x - 1, y + 1);
    S  = b.getsq(x    , y + 1);
    SE = b.getsq(x + 1, y + 1);
    if (C >= 5)
      return C;
    if (((C == 0) || (C == 1)) && (S == 1) && (E != 4))
      return 1;
    else if (((C == 0) || (C == 2)) && (W == 2))
      return 2;
    else if (((C == 0) || (C == 3)) && (N == 3))
      return 3;
    else if (((C == 0) || (C == 4)) && (E == 4))
      return 4;
    else if (Gate(6, G_XOR))
      return r;
    else if (Gate(7, G_OR))
      return r;
    else if (Gate(8, G_AND))
      return r;
    else if (Gate(9, G_NAND))
      return r;
    else if (Gate(10, G_NOR))
      return r;
    else if (Gate(11, G_XNOR))
      return r;
    if (((C == 1) && (S == 0)) || ((C == 2) && (W == 0)) ||
        ((C == 3) && (N == 0)) || ((C == 4) && (E == 0)))
      return 0;
    return 0;
  }
}

