import java.lang.*;
import java.util.*;
import java.io.*;

import javax.swing.*;                                           
//import javax.imageIO.*;                                           

import java.awt.*;
import java.awt.event.*;                                                  

import java.awt.image.*;
class SaveImage_plugin implements ActionListener {
  static SaveImage_plugin plugin = null;
  static SaveImage_dialog dialog = null;
  static void init() {
  new SaveImage_plugin();
    //dialog = null;
  }
  SaveImage_plugin() {
    dialog = null;
    JMenuBar mb = cellautoapp.mainmenu;
    JMenuItem mi = new JMenuItem("Get Image");
    cellautoapp.editmenu.add(mi);
    mi.setActionCommand("Save_Image_show");
    mi.addActionListener(this);    
    plugin = this;
  }
  public void actionPerformed(ActionEvent e) {  
    String action = e.getActionCommand();
    if (action.equals("Save_Image_show")) {
      if (dialog == null) {
        dialog = new SaveImage_dialog("Get Image");
        dialog.setBounds(0,0,400,150);
      }
      dialog.setVisible(true);
    }
  }
};

class SaveImage_dialog extends JFrame implements ActionListener {
  JLabel cap_label;
  JComboBox cap_combobox;
  JLabel filename_label;
  JTextField filename_edit;
  JButton save_button;
  JButton close_button;
  static int THE_SELECTION = 0;
  static int THE_WINDOW = 1;
  static int THE_UNIVERSE = 2;
  static int THE_RULE_TABLE = 3;
  
  String[] combobox_strings = {"the selection","the window","the universe",
  "the rule table"};
  SaveImage_dialog(String Title) {
    super(Title);
    GridBagLayout gl = new GridBagLayout();
    this.getContentPane().setLayout(gl);
    GridBagConstraints c = new GridBagConstraints();
    
    c.fill = GridBagConstraints.BOTH;
    c.weightx = 1.0;
    c.weighty = 1.0;

    c.gridwidth = 1;
    cap_label = new JLabel("capture");
    gl.setConstraints(cap_label, c);
    this.getContentPane().add(cap_label);
    
    c.gridwidth = GridBagConstraints.REMAINDER;
    cap_combobox = new JComboBox(combobox_strings);
    gl.setConstraints(cap_combobox, c);
    this.getContentPane().add(cap_combobox);

    c.gridwidth = 1;
    filename_label = new JLabel("file name");
    gl.setConstraints(filename_label, c);
    this.getContentPane().add(filename_label);
    
    c.gridwidth = GridBagConstraints.REMAINDER;
    filename_edit = new JTextField("img1.png");
    gl.setConstraints(filename_edit, c);
    this.getContentPane().add(filename_edit);

    c.gridwidth = 1;
    save_button = new JButton("save");
    gl.setConstraints(save_button, c);
    save_button.setActionCommand("savebuttonclick");
    save_button.addActionListener(this);
    this.getContentPane().add(save_button);
    
    c.gridwidth = GridBagConstraints.REMAINDER;
    close_button = new JButton("close");
    gl.setConstraints(close_button, c);
    close_button.setActionCommand("closebuttonclick");
    close_button.addActionListener(this);
    this.getContentPane().add(close_button);

    this.pack();
    
  }
  public void actionPerformed(ActionEvent e) {  
    String action = e.getActionCommand();
    if (action.equals("savebuttonclick")) {
      String filename = filename_edit.getText();
      int i = cap_combobox.getSelectedIndex();
      int img[] = null;
      int w = 0;
      int h = 0;
      if (i == THE_SELECTION) {
        if ((cellautoapp.selw == 0) | (cellautoapp.selh == 0)){
          Showerror("error: there is no selection");
          return;
        }
        int sqsize = cellautomainwindowc.sqsize;
        w = cellautoapp.selw*sqsize;
        h = cellautoapp.selh*sqsize;
        
        img = new int[cellautoapp.selw*sqsize * cellautoapp.selh*sqsize];
        for (int x = 0;x < cellautoapp.selw;x++) {
          for (int y = 0;y < cellautoapp.selh;y++) {
            int c = cellautoapp.cellauto131.cellvaluecolor[cellautoapp.seldata[x][y]].getRGB();
            for (int x2 = 0;x2 < sqsize;x2++) {
              for (int y2 = 0;y2 < sqsize;y2++) {
                img[((x*sqsize)+x2) + (((y*sqsize)+y2) * w)] = c;
              }
            }
          }
        }
      }
      if (i == THE_WINDOW) {
        int sqsize = cellautomainwindowc.sqsize;
        int w2 = (cellautoapp.cellautomainwindow.getWidth() / sqsize)+1;
        int h2 = (cellautoapp.cellautomainwindow.getHeight() / sqsize)+1;
        w = w2*sqsize;
        h = h2*sqsize;
        img = new int[w2*sqsize * h2*sqsize];
        for (int x = 0;x < w2;x++) {
          for (int y = 0;y < h2;y++) {
            int x2 = x + cellautoapp.offsetx;
            int y2 = y + cellautoapp.offsety;
            boolean inselectionboolean = false;
            if (((x2 >= cellautoapp.selx) & (x2 < (cellautoapp.selx+cellautoapp.selw))) &
               ((y2 >= cellautoapp.sely) & (y2 < (cellautoapp.sely+cellautoapp.selh)))){
                 inselectionboolean = true;
            }
            int sq = cellautoapp.board.getsq(x2,y2);
            if (inselectionboolean){
              int sq2 = cellautoapp.seldata[(x2-cellautoapp.selx)][(y2-cellautoapp.sely)];
              if (cellautoapp.transparentselection == true){
                if (sq2 != cellautoapp.board.dfcolor){
                  sq = sq2;
                }
              }
            }
            
            int c = cellautoapp.cellauto131.cellvaluecolor[sq].getRGB();
            for (int x3 = 0;x3 < sqsize;x3++) {
              for (int y3 = 0;y3 < sqsize;y3++) {
                img[((x*sqsize)+x3) + (((y*sqsize)+y3)*w)] = c;
              }
            }
           
          }
        }
        int x1 = (cellautoapp.selx - cellautoapp.offsetx) * sqsize;
        int y1 = (cellautoapp.sely - cellautoapp.offsety) * sqsize;
        int x2 = (cellautoapp.selx + cellautoapp.selw - cellautoapp.offsetx) * sqsize;
        int y2 = (cellautoapp.sely + cellautoapp.selh - cellautoapp.offsety) * sqsize;
        int c = Color.red.getRGB();
        for (int x = x1;x < x2;x++){
          img[x + (y1*w)] = c;
          img[x + (y2*w)] = c;
        }
        for (int y = y1;y < y2;y++){
          img[x1 + (y*w)] = c;
          img[x2 + (y*w)] = c;
        }
      }
      if (i == THE_UNIVERSE){
        int w2 = cellautoapp.board.width;
        int h2 = cellautoapp.board.height;
        w = w2;
        h = h2;
        img = new int[w2 * h2];
        for (int x = 0;x < w2;x++) {
          for (int y = 0;y < h2;y++) {
            int sq = cellautoapp.board.getsq(x,y);
            boolean inselectionboolean = false;
            if (((x >= cellautoapp.selx) & (x < (cellautoapp.selx+cellautoapp.selw))) &
               ((y >= cellautoapp.sely) & (y < (cellautoapp.sely+cellautoapp.selh)))){
                 inselectionboolean = true;
            }
            if (inselectionboolean){
              int sq2 = cellautoapp.seldata[(x-cellautoapp.selx)][(y-cellautoapp.sely)];
              if (cellautoapp.transparentselection == true){
                if (sq2 != cellautoapp.board.dfcolor){
                  sq = sq2;
                }
              }
            }            
            int c = cellautoapp.cellauto131.cellvaluecolor[sq].getRGB();
            img[x + (y * w)] = c;
          }
        }
      }
      
      if (i == THE_RULE_TABLE) {
        int w2 = cellautoapp.cellauto131.tablewidth;
        int h2 = cellautoapp.cellauto131.tableheight;
        int sqsize = edittablepanelc.sqsize;
        w = (w2+1) * sqsize;
        h = (h2+1) * sqsize;
        img = new int[w * h];
        for (int x2 = 0;x2 < w2;x2++) {
          for (int y2 = 0;y2 < h2;y2++) {
            int sq = cellautoapp.cellauto131.getlookuptable(x2,y2);
            int c = cellautoapp.cellauto131.cellvaluecolor[sq].getRGB();
            for (int x3 = 0;x3 < sqsize;x3++) {
              for (int y3 = 0;y3 < sqsize;y3++) {
                int x = (x2*sqsize) + x3;
                int y = (y2*sqsize) + y3;
                img[x + (y * w)] = c;
              }
            }
          }
        }
      }
      Image img2 = createImage(new MemoryImageSource(w, h, img, 0, w));
      BufferedImage img3 = (BufferedImage) createImage(w,h);
      Graphics2D gp = img3.createGraphics();
      gp.drawImage(img2,null,null);
      if (i == THE_RULE_TABLE) {
        int sqsize = edittablepanelc.sqsize;
        edittablepanelc.draw_rule_table(gp,0,0,(w / sqsize) + 1,(h / sqsize) + 1);
      }
      //filename = "CA_Images" + File.separator + filename;
      File f = new File(filename);
      //File d = f.getParentFile();
      //if (d.exists() == true) {
        if (f.exists() == false) {
          if (isfileinsidecurrentdirectory(filename) == true) {
            if (filename.length() > 0) {
              if (filename.endsWith(".png") == true) {
                try {
                  javax.imageio.ImageIO.write(img3,"png",f);
                } catch (FileNotFoundException e2) {
                  e2.printStackTrace();
                } catch (IOException e2) {
                  e2.printStackTrace();
                }
              } else {
                Showerror("error: filename does not end with .png");
              }
            } else {
              Showerror("error: no file name");
            }
          } else {
            Showerror("error: can not write a file outside the current directory");
          }
        } else {
          Showerror("file already exists");
        }
      //} else {
      //  Showerror("error: the path " + f.getParent() + " does not exist ");
      //}
    }
    if (action.equals("closebuttonclick")) {
      this.setVisible(false);
    }

  }
  static void Showerror(String str) {
    System.out.println(str);
    JOptionPane.showMessageDialog(SaveImage_plugin.dialog,new JLabel(str),"error",JOptionPane.ERROR_MESSAGE);  
  }
  static boolean isfileinsidecurrentdirectory(String filename) {
      int i2 = 0;
      for (int i = 0;i < filename.length();i++) {
        char ch = filename.charAt(i);
        if (ch == '.') {i2++;}
        else {i2 = 0;}
        if (i2 == 2) {return false;}
      }
      return true;
    }  

};

