import java.lang.*;
import java.util.*;
import java.io.*;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.Toolkit.*;
import java.awt.datatransfer.*;
import java.util.zip.*;


class cellautorulec {
  abstractcellautorulefamily rulefamily = null;
  public int seed = 0;
  public String filename = null;
  public String description = null;
  public byte lookuptable[][];
  boolean lookuptableallused = true;
  public byte lookuptableused[][];
  public int cellvalue[];
  public Color cellvaluecolor[];
  public int numalloccolors = 0;
  public int numcolors = 4;
  public int numcellvalues = 256;
  public int bordersize = 1;
  public int bordervalue[][];
  public int bordersum = 0;
  public int borderflip[][];
  public int tablewidth;
  public int tableheight;
  public int tableoffset;       
  public int buffer[][];
  public int buffer2[][];
  public int bufferoffsetx = 0;
  public int bufferoffsety = 0;
  public int rulechange = 2;
  public boolean debug2534 = false;
  Color white; 
  public long numcellscalculate = 0;
  public boolean neighborhoodchanged = true;
  public int neighboroffsetx[] = null;
  public int neighboroffsety[] = null;
  public int numneighbors = 0;

  cellautorulec(cellautorulec c){
    neighborhoodchanged = true;
    rulefamily = c.rulefamily;
    seed = c.seed;
    buffer = new int[16+bordersize+bordersize][16+bordersize+bordersize];
    buffer2 = new int[16][16];
    white = c.white;
    numcellvalues = 256;

    //create the rule table and copy it from the other rule
    tablewidth = c.tablewidth;
    tableheight = c.tableheight;
    tableoffset = c.tableoffset;
    lookuptable = new byte[tablewidth][tableheight];
    for (int x = 0;x < tablewidth;x++){
      for (int y = 0;y < tableheight;y++){
        lookuptable[x][y] = c.lookuptable[x][y];
      }
    }

    lookuptableallused = c.lookuptableallused;
    if (lookuptableallused == false){
      lookuptableused = new byte[tablewidth][tableheight];
      for (int x = 0;x < tablewidth;x++){
        for (int y = 0;y < tableheight;y++){
          lookuptableused[x][y] = c.lookuptableused[x][y];
        }
      }
    }
    
    numcolors = c.numcolors;
    writenumalloccolors(numcolors);
    for (int i = 0;i < numcolors;i++){
      cellvalue[i] = c.cellvalue[i];
      cellvaluecolor[i] = c.cellvaluecolor[i];
    }

    bordersum = c.bordersum;
    bordersize = c.bordersize;
    int bs = (bordersize*2) + 1;
    bordervalue = new int[bs][bs];
    for (int x = 0;x < bs;x++){
      for (int y = 0;y < bs;y++){
        bordervalue[x][y] = c.bordervalue[x][y];
      }
    }  

    borderflip = new int[2][2];
    for (int x = 0;x < 2;x++){
      for (int y = 0;y < 2;y++){
        borderflip[x][y] = c.borderflip[x][y];
      }
    }
  }
  cellautorulec(){
    neighborhoodchanged = true;
    seed = 0;
    buffer = new int[16+bordersize+bordersize][16+bordersize+bordersize];
    buffer2 = new int[16][16];
    lookuptableallused = true;
    borderflip = new int[2][2];
    borderflip[0][0] = 0;
    borderflip[0][1] = 0;
    borderflip[1][0] = 0;
    borderflip[1][1] = 0;
    
    //create the rule table
    tablewidth = 25;
    tableheight = 8;
    lookuptable = new byte[tablewidth][tableheight];
    for (int x = 0;x < tablewidth;x++){
      for (int y = 0;y < tableheight;y++){
        lookuptable[x][y] = 0;
      }
    }
    lookuptable[6][0] = 1;
    lookuptable[6][1] = 1;
    lookuptable[4][1] = 1;

    bordersum = 0;
    bordersize = 1;
    bordervalue = new int[(bordersize*2)+1][(bordersize*2)+1];
    for (int x = 0;x < 3;x++){
      for (int y = 0;y < 3;y++){
        bordervalue[x][y] = 1;
        bordersum = bordersum + 1;
      }
    }
    bordervalue[1][1] = 0;
    bordersum = bordersum - 1;
    
    white = new Color(255,255,255);
    writenumalloccolors(numcellvalues);
    numcolors = 8;
    for (int i = 0;i < numcellvalues;i++){
      cellvalue[i] = 0;
      cellvaluecolor[i] = null;
    }
    cellvaluecolor[0] = new Color(0,0,0);
    cellvaluecolor[1] = new Color(255,255,0);
    cellvaluecolor[2] = new Color(255,0,0);
    cellvaluecolor[3] = new Color(0,0,255);
    cellvaluecolor[4] = new Color(255,0,255);
    cellvaluecolor[5] = new Color(0,255,255);
    cellvaluecolor[6] = new Color(0,255,0);
    cellvaluecolor[7] = new Color(255,255,255);

    cellvalue[1] = 2;
    cellvalue[4] = 1;
    cellvalue[5] = 2;
    cellvalue[6] = 1;
    cellvalue[7] = 3;
    
  }

  //addnewstate adds a new color to the color box
  //and resizes the rule table
  //it returns the index of the new color
  int addnewstate(){
    int n = getnumcolors();
    if (n >= 256) {return -1;}
    if (tableheight < getnumcolors()) {
      resizetable(tablewidth,getnumcolors());
    }
    setnumcolors(n+1);
    writenumalloccolors(n+1);
    cellvaluecolor[n] = cellvaluecolor[cellautoapp.colorlistindex];
    cellvalue[n] = cellvalue[cellautoapp.colorlistindex];
    byte a[][];
    a = lookuptable;
    cleartable(tablewidth,tableheight+1);
    for (int y = 0;y < (tableheight-1);y++){
      for (int x = 0;x < tablewidth;x++){
        lookuptable[x][y] = a[x][y];
      }
    }
    if (lookuptableallused == false){
      a = new byte[tablewidth][tableheight];
      for (int y = 0;y < (tableheight-1);y++){
        for (int x = 0;x < tablewidth;x++){
          a[x][y] = lookuptableused[x][y];
        }
      }
      for (int x = 0;x < tablewidth;x++){
        a[x][tableheight-1] = 1;
      }
      lookuptableused = a;
    }
    return n;
  }
  int get_max_cell_value() {
    int best_cell_value = 0;
    for (int i = 0;i < numcolors;i++) {
      if (cellvalue[i] > best_cell_value) { 
        best_cell_value = cellvalue[i];
      }
    }
    return best_cell_value;
  }
  void makeruletablewider() {
    int max_cell_value = get_max_cell_value();
    //System.out.println("bordersum " + bordersum);
    int new_table_width = (bordersum * max_cell_value) + 1 + tableoffset;
    if (new_table_width > tablewidth) {
      resizetable(new_table_width,tableheight);
    }
  }
  int readnumalloccolors(){
    return numalloccolors;
  }
  void writenumalloccolors(int size){
    if (size <= numalloccolors){return;}
    int tmpcellvalue[] = cellvalue;
    Color tmpcellvaluecolor[] = cellvaluecolor;
    cellvalue = new int[size];
    cellvaluecolor = new Color[size];
    for (int i = 0;i < numalloccolors;i++){
      cellvalue[i] = tmpcellvalue[i];
      cellvaluecolor[i] = tmpcellvaluecolor[i];
    }
    numalloccolors = size;
  }
  int readtableoffset(){
    return tableoffset;
  }
  void writetableoffset(int a){
    tableoffset = a;
  }
  int readborderflip(int x,int y){
    return borderflip[x & 1][y & 1];
  }
  void writeborderflip(int x,int y,int a){
    borderflip[x & 1][y & 1] = a; 
  }
  void setupneighboroffsets() {
    int n = 0;
    for (int dx = -bordersize;dx <= bordersize;dx++){ 
      for (int dy = -bordersize;dy <= bordersize;dy++){
        int a2 = bordervalue[dx+bordersize][dy+bordersize];
        if (a2 != 0) {n++;}
      }
    }
    neighboroffsetx = new int[n];
    neighboroffsety = new int[n];
    numneighbors = 0;
    for (int dx = -bordersize;dx <= bordersize;dx++){ 
      for (int dy = -bordersize;dy <= bordersize;dy++){
        int a2 = bordervalue[dx+bordersize][dy+bordersize];
        if (a2 != 0) {
          neighboroffsetx[numneighbors] = dx;
          neighboroffsety[numneighbors] = dy;
          numneighbors++;
        }
      }
    }
    neighborhoodchanged = false;
  }
  void printneighboroffsets() {
    System.out.println("");
    for (int i = 0;i < numneighbors;i++){
      int dx = neighboroffsetx[i];
      int dy = neighboroffsety[i];
      System.out.println("neighbor offset " + dx + "," + dy);
    }
  }
  // this function counts the value of the cell's neighbors
  //Parameters:
  //  b: the board the cell is on
  //  x: the cell's x position
  //  y: the cell's y position
  //Returns:
  //  the sum of the cell's neighbors
  int getneighborvalue(boardc b,int x,int y) {
    int a0 = tableoffset;
    int a1 = 0;
    int a3 = borderflip[x & 1][y & 1];
    if (neighborhoodchanged == true){
      //System.out.println("neighborhoodchanged");
      setupneighboroffsets();
    }
    for (int i = 0;i < numneighbors;i++){
      int dx = neighboroffsetx[i];
      int dy = neighboroffsety[i];
      int a2 = bordervalue[dx+bordersize][dy+bordersize];
      //if (a2 == 0){return;}
      //if (a3 != 0) {
      int dx2 = dx;
      int dy2 = dy;
      if ((a3 & 1) == 1){dx2 = -dx2;}
      if ((a3 & 2) == 2){dy2 = -dy2;}      
      a1 = b.getsq(x+dx2,y+dy2);
      //} else {
      //  a1 = b.getsq(x+dx,y+dy); 
      //} 
      a0 = a0 + (cellvalue[a1] * a2);      
    }
    return a0;
  }

  boardc calc436(boardc b,boardc b2) {
    //b2.clearusedbitboard();
    if (rulechange > 0){
      b.usenonemptyblocks();
      rulechange--;
    }   
    b2 = calcbgcolor(b,b2);
    if ((b2.background_tile_sub_board.equals(b2.background_tile_sub_board2) == false)) {
      b2.fillusedbitboard();
    }
    for (int x = 0;x < b.width;x = x + 32){
      for (int y = 0;y < b.height;y = y + 32){
          calcblock436(b,b2,x,y);
      }
    }
    return b2;
    
  }

  byte block_tmp_used_map[][] = new byte[16][16];
  void calcblock436(boardc b,boardc b2,int x,int y){
    blockc bl = b.block[x >> 5][y >> 5];
    blockc bl2 = b2.block[x >> 5][y >> 5];
    if ((b.usedblock[x >> 5][y >> 5] != 0) | 
        (b2.usedblock[x >> 5][y >> 5] != 0)) {
      for (int x2 = 0;x2 < 32;x2 = x2 + 2){
        for (int y2 = 0;y2 < 32;y2 = y2 + 2){
          if (b2.readused436(x+x2,y+y2) == 1) {
            block_tmp_used_map[x2 >> 1][y2 >> 1] = 1;
          }
        }
      }
      b2.usedblock[x >> 5][y >> 5] = 0;
      if (bl2 != null) {
        bl2.clearusedbitboard();
      }
        for (int x2 = 0;x2 < 32;x2 = x2 + 2){
          for (int y2 = 0;y2 < 32;y2 = y2 + 2){
            if ((b.readused436(x+x2,y+y2) == 1)|
                (block_tmp_used_map[x2 >> 1][y2 >> 1] == 1)) {
              calcblock22(b,b2,x,y,x2,y2);
            }
          }
        }
    }

  }


  void calcblock22(boardc b,boardc b2,int x,int y,int x2,int y2) {
    int a0 = tableoffset;
             for (int x3 = 0;x3 < 2;x3++){
              for (int y3 = 0;y3 < 2;y3++){
                int x4 = x + x2 + x3;
                int y4 = y + y2 + y3;
                int a2 = 0;
                if (x4 >= b.width){break;}
                if (y4 >= b.height){break;}
                int a3 = 0;
                if (rulefamily != null){
                  a3 = rulefamily.calcsq(this,b,x4,y4,cellautoapp.generation);
                } else {
                  a0 = getneighborvalue(b,x4,y4);
                  a2 = b.getsq(x4,y4);
                  a3 = getlookuptable(a0,a2);
                  if (lookuptableallused == false){
                    setlookuptableused(a0,a2,1);
                  }
                }     
                b2.setsq(x4,y4,a3);
                
              }
            }
            numcellscalculate = numcellscalculate + 4;

  }
  boardc calc_one_row_func(boardc b){
    int p = cellautoapp.generation % b.height;
    for (int x = 0;x < b.width;x++) {
      int sq = rulefamily.calcsq(this,b,x,p+1,cellautoapp.generation);
      if ((p+1) == b.height) {
        b.setsq(x,0,sq);
      } else {
        b.setsq(x,p+1,sq);
      }
    }
    return b;
  }
  void setnumcolors(int i){
    numcolors = i;
  }
  void setnumcolors2(int i){
    int a = 0;
    if (i < numcolors){
      for (int i2 = i;i2 < numcolors;i2++){
        if (cellvalue[i2] > 0){
          a = 1;
        }
      }
      if (a == 0){
        numcolors = i;
      }
    }else{
      numcolors = i;
    }
  }
  
  int getnumcolors() {
    return numcolors;
  }

  //setcellvaluecolor sets the state's color
  //Parameters:
  //  i: the state's index
  //  c: the state's new color
  void setcellvaluecolor(int i,Color c) {
    if (i < 0){System.out.println("note: cellvalue index is out of range");}
    if (i >= numcellvalues){System.out.println("note: cellvalue index is out of range");}
    if (i >= numcolors){setnumcolors(i+1);}    
    writenumalloccolors(i+1);
    cellvaluecolor[i] = c;
  }

  //getcellvaluecolor gets the state's color
  //Parameters:
  //  i: the state's index
  //Returns:
  // the state's color
  Color getcellvaluecolor(int i) {
    if (i < 0){System.out.println("note: cellvalue index is out of range");}
    if (i >= numcellvalues){System.out.println("note: cellvalue index is out of range");}
    if (cellvaluecolor[i] == null){
      return white;
    }else{
      return cellvaluecolor[i];
    }
  }
  
  //resizetable resizes the rule table
  //Parameters:
  //  w: the table's new width
  //  h: the table's new height
  void resizetable(int w,int h) {
    byte tmp[][] = lookuptable;
    byte tmp2[][] = lookuptableused;
    int tmpwidth = tablewidth;
    int tmpheight = tableheight;
    cleartable(w,h);
    for (int y = 0;y < tmpheight;y++){
      for (int x = 0;x < tmpwidth;x++){
        if (x < w){
          if (y < h){
            lookuptable[x][y] = tmp[x][y];
            if (lookuptableallused == false) {
              lookuptableused[x][y] = tmp2[x][y];
            }
          }
        }
      }
    }
  }
  //cleartable clears the rule table and resizes it
  //Parameters:
  //  w: the table's new width
  //  h: the table's new height
  void cleartable(int w,int h) {
    tablewidth = w;
    tableheight = h;
    lookuptable = new byte[tablewidth][tableheight];
    if (lookuptableallused == false) {
      //System.out.println("lookuptableused = new byte[tablewidth][tableheight];");
      lookuptableused = new byte[tablewidth][tableheight];
    }
  }

  //clearborder resets all the neighbor weights to zero
  //it can also resize the neighborhood
  void clearborder(int a) {
    int a2 = bordersize;
    bordersize = a;
    bordersum = 0;
    bordervalue = new int[(bordersize*2)+1][(bordersize*2)+1];
    neighborhoodchanged = true;
  }
  
  void resizeborder(int a) {
    int tmp[][] = bordervalue;
    int a2 = bordersize;
    clearborder(a);
    int a3 = a2;
    if (a2 > a){a3 = a;}
    for (int y = -a3;y <= a3;y++){
      for (int x = -a3;x <= a3;x++){
        bordervalue[x+a][y+a] = tmp[x+a2][y+a2];
      }
    }
    neighborhoodchanged = true;
  }
  // getbordersize returns the neighborhood size
  // the number 1 is a 3x3 neighborhood
  // the number 2 is a 5x5 neighborhood
  // the number 3 is a 7x7 neighborhood
  // the number 4 is a 9x9 neighborhood
  // etc
  int getbordersize() {
    return bordersize;
  }

  //getbordervalue gets the neighbor's weight
  //Parameters:
  //  x: the neighbor's x offset
  //  y: the neighbor's y offset
  //Returns:
  //  the neighbor's weight
  public int getbordervalue(int x,int y) {
    if (((x+bordersize) < 0) | ((y+bordersize) < 0) | 
       ((x+bordersize) >= ((bordersize*2)+1)) |
       ((y+bordersize) >= ((bordersize*2)+1))) {
      System.out.println("note: bordervalue index is out of range");
      return 0;
    }
    
    return bordervalue[x+bordersize][y+bordersize]; 
  }
  
  //setbordervalue sets the neighbor's weight
  //Parameters:
  //  x: the neighbor's x offset
  //  y: the neighbor's y offset
  //  a: the neighbor's new weight
  public void setbordervalue(int x,int y,int a) {
    if (((x+bordersize) < 0) | ((y+bordersize) < 0) | 
       ((x+bordersize) >= ((bordersize*2)+1)) |
       ((y+bordersize) >= ((bordersize*2)+1))) {
      System.out.println("note: bordervalue index is out of range");
      return;
    }
    bordersum = (bordersum - bordervalue[x+bordersize][y+bordersize]) + a;
    bordervalue[x+bordersize][y+bordersize] = a;
    neighborhoodchanged = true;
  }
  
  //getcellvalue gets the state's value
  //Parameters:
  //  i: the state's index
  //Returns:
  //  the state's value
  public int getcellvalue(int i) {
    if ((i < 0) | (i >= numcellvalues)) {
      System.out.println("note: cellvalue index is out of range");
      return 0;
    }
    
    return cellvalue[i];
  }

  //setcellvalue sets the state's value
  //Parameters:
  //  i: the state's index
  //  a: the state's new value
  public void setcellvalue(int i,int a) {
    if ((i < 0) | (i >= numcellvalues)) {
      System.out.println("note: cellvalue index is out of range");
      return;
    }
    if (i >= numcolors){numcolors = i+1;}    
    writenumalloccolors(i+1);
    cellvalue[i] = a;
    
  }
  
  int calc_bg_color_colunm(int s) {
    int a0 = tableoffset;
    for (int dx = -bordersize;dx <= bordersize;dx++){ 
      for (int dy = -bordersize;dy <= bordersize;dy++){
        a0 = a0 + (cellvalue[s] * bordervalue[dx+bordersize][dy+bordersize]);              
      }
    }
    return a0;
  }
  boardc calcbgcolor(boardc b,boardc b2) { 
    int a0 = tableoffset;
    int a2 = 0;
    b2.dfcolor2 = b2.dfcolor;
    if ((rulefamily == null) & (b.background_tile_sub_board == null)){
      a0 = calc_bg_color_colunm(b.dfcolor);
    }
    if ((rulefamily == null)){
      if (b.background_tile_sub_board != null){
        b2.background_tile_sub_board2.copy(b2.background_tile_sub_board);
        for (int x = 0;x < b2.background_tile_sub_board.get_width();x++){
          for (int y = 0;y < b2.background_tile_sub_board.get_height();y++){
            int sq = b.background_tile_sub_board.getsq(x,y);
            int n = this.getneighborvalue(b.background_tile_sub_board,x,y);
            if (lookuptableallused == false){
              setlookuptableused(n,sq,1);
            }
            sq = getlookuptable(n,sq);
            b2.background_tile_sub_board.setsq(x,y,sq);
          }
        }
      } else {
        b2.dfcolor2 = b2.dfcolor;
        if (lookuptableallused == false){
          setlookuptableused(a0,b.dfcolor,1);
        }
        b2.dfcolor = getlookuptable(a0,b.dfcolor);
      }
    } else {
      if (b.background_tile_sub_board != null){
        //System.out.println("a53");
        b2.background_tile_sub_board2.copy(b2.background_tile_sub_board);
        for (int x = 0;x < b2.background_tile_sub_board.get_width();x++){
          for (int y = 0;y < b2.background_tile_sub_board.get_height();y++){
            int sq = 0;
            sq = rulefamily.calcsq(this,b.background_tile_sub_board,x,y,cellautoapp.generation);
            b2.background_tile_sub_board.setsq(x,y,sq);
          }
        }
        b2.dfcolor = b2.background_tile_sub_board.getsq(0,0);
      }
    }
    return b2;
  }

  public void filllookuptableused() {
    lookuptableallused = true;
    for (int x = 0;x < tablewidth;x++){
      for (int y = 0;y < tableheight;y++){
        setlookuptableused(x,y,1);
      }
    }
  }
  public void clearlookuptableused() {
    for (int x = 0;x < tablewidth;x++){
      for (int y = 0;y < tableheight;y++){
        setlookuptableused(x,y,0);
      }
    }
  }
  public void setlookuptableused(int x,int y,int a) {
    if ((x < 0) | (y < 0) | (x >= tablewidth) | (y >= tableheight)) {
      System.out.println("note: table index is out of range ");
      return;
    }
    if (a == 0){
      if (rulefamily != null){
        return;
      }
      if (lookuptableallused == true){
        lookuptableused = new byte[tablewidth][tableheight];
        for (int x2 = 0;x2 < tablewidth;x2++){
          for (int y2 = 0;y2 < tableheight;y2++){
            lookuptableused[x2][y2] = 1;
          }
        }
        lookuptableallused = false;
      }
    }
    if (lookuptableallused == false){
      lookuptableused[x][y] = ((byte) a);
    }
  }
  public int getlookuptableused(int x,int y) {
    if ((x < 0) | (y < 0) | (x >= tablewidth) | (y >= tableheight)) {
    //  System.out.println("note: table index is out of range");
      return 1;
    }
    if (lookuptableallused == false){
      return lookuptableused[x][y];
    }else{
      return 1;
    }
  }

  //this function writes to the rule table
  //Parameters:
  //  x: the entry's x offset or the neighborhood count
  //  y: the entry's y offset or the cell's state
  //  a: the entry's new value
  public void setlookuptable(int x,int y,int a) {
    if ((x < 0) | (y < 0) | (x >= tablewidth) | (y >= tableheight)) {
      System.out.println("note: table index is out of range" + x + " " + y);
      return;
    }
    if (a >= 128){ 
      a = a - 256;
    }
    lookuptable[x][y] = ((byte) a);
    rulechange = 2;
  }
  
  //this function reads from the rule table
  //Parameters:
  //  x: the entry's x offset or the neighborhood count
  //  y: the entry's y offset or the cell's state
  //Returns:
  //  the entry's value
  public int getlookuptable(int x,int y) {
    
    if ((x < 0) | (y < 0) | (x >= tablewidth) | (y >= tableheight)) {
    //  System.out.println("note: table index is out of range");
      return 0;
    }
    //if ((y < 0) | (y >= tableheight)) {return 0;}
    //while (x < 0) {x = x + tablewidth;}
    //while (x >= tablewidth) {x = x - tablewidth;}
    int a = lookuptable[x][y];
    if (a < 0) {a = a + 256;}
    return ((int) a);
  }
  
};



//this is class that is a 32x32 block of cells
class blockc{
  int usedbitboard[];
  byte board[][];
  int popcount;
  void printblock(){
    for (int x = 0;x < 32;x++){
      for (int y = 0;y < 32;y++){
        System.out.print(board[x][y]);
      }
      System.out.println();
    }
  }
  boolean equals(blockc b){
    for (int x = 0;x < 32;x++){
      for (int y = 0;y < 32;y++){
        if (this.board[x][y] != b.board[x][y]){
          return false;
        }
      }
    }
    return true;
  }
  void clearusedbitboard(){
    for (int i = 0;i < 8;i++){
      usedbitboard[i] = 0;
    }
  }
  void fillusedbitboard(){
    for (int i = 0;i < 8;i++){
      usedbitboard[i] = -1;
    }
  }
  void clearused(int x,int y){
    int a1 = ((y << 3) + x) & 31;
    int a2 = (y >> 2);
    usedbitboard[a2] = usedbitboard[a2] & ~(1 << a1);
  }
  void clearused2(int x,int y){
    int a1 = ((y << 3) + x) & 31;
    int a2 = (y >> 2);
    usedbitboard[a2] = usedbitboard[a2] & ~(1 << a1);
  
  }
  
  void writeused(int x,int y){
    int a1 = ((y << 3) + x) & 31;
    int a2 = (y >> 2);
    usedbitboard[a2] = usedbitboard[a2] | (1 << a1);
  }
  void writeused2(int x,int y){
    int a1 = ((y << 3) + x) & 31;
    int a2 = ((y >> 2) + 2);
    usedbitboard[a2] = usedbitboard[a2] | (1 << a1);
  }
  int readused(int x,int y){
    int a1 = ((y << 3) + x) & 31;
    int a2 = (y >> 2);
    return (usedbitboard[a2] >> a1)&1;
  }
  int readused2(int x,int y){
    int a1 = ((y << 3) + x) & 31;
    int a2 = ((y >> 2) + 2);
    return (usedbitboard[a2] >> a1)&1;
  }

  void clearused436(int x,int y){
    int a1 = ((y << 4) + x) & 31;
    int a2 = (y >> 1);
    usedbitboard[a2] = usedbitboard[a2] & ~(1 << a1);  
  }
  void writeused436(int x,int y){
    int a1 = ((y << 4) + x) & 31;
    int a2 = (y >> 1);
    usedbitboard[a2] = usedbitboard[a2] | (1 << a1);
  }
  int readused436(int x,int y){
    int a1 = ((y << 4) + x) & 31;
    int a2 = (y >> 1);
    return (usedbitboard[a2] >> a1)&1;
  }


  blockc(int a){
    usedbitboard = new int[8];
    board = new byte[32][32];
    for (int x = 0;x < 32;x++){
      for (int y = 0;y < 32;y++){
        board[x][y] = (byte) a;
      }
    }
  }

  blockc(blockc b){
    usedbitboard = new int[8];
    board = new byte[32][32];
    for (int i = 0;i < 8;i++){
      usedbitboard[i] = b.usedbitboard[i];
    }
    for (int x = 0;x < 32;x++){
      for (int y = 0;y < 32;y++){
        board[x][y] = b.board[x][y];
      }  
    }
    popcount = b.popcount;
  }

  void copy(blockc b){
    //usedbitboard = new int[4];
    for (int i = 0;i < 4;i++){
      usedbitboard[i] = b.usedbitboard[i];
    }
    for (int x = 0;x < 32;x++){
      for (int y = 0;y < 32;y++){
        board[x][y] = b.board[x][y];
      }  
    }
  }
}  


class simpleboardc extends boardc {
  int sq[][];
  int width = 1;
  int height = 1;
  //boardc() {}
  int get_width(){
    return this.width;
  }
  int get_height(){
    return this.height;
  }

  simpleboardc(int w,int h) {
    this.width = w;
    this.height = h;
    sq = new int[this.width][this.height];
  }
  simpleboardc(boardc b) {
    this.width = b.get_width();
    this.height = b.get_height();
    sq = new int[this.width][this.height];
    this.copy(b);
  }
  void copy(boardc b){
    if (this.width != b.get_width()) {return;}
    if (this.height != b.get_height()) {return;}
    for (int x = 0;x < this.width;x++) {
      for (int y = 0;y < this.height;y++) {
        setsq(x,y,(byte) b.getsq(x,y));
      }
    }
  }
  int getsq(int x,int y){
    int x2 = 0;
    int y2 = 0;
    if ((this.width > 1) | (this.height > 1)){
      if ((this.width & (this.width-1)) == 0) {
        x2 = x & (this.width-1);
      } else {
        x2 = x % this.width;
        if (x2 < 0){x2 = x2 + this.width;}
      }
      if ((this.height & (this.height-1)) == 0) {
        y2 = y & (this.height-1);
      } else {
        y2 = y % this.height;
        if (y2 < 0){y2 = y2 + this.height;}
      }
    }
    return sq[x2][y2];
  }
  void setsq(int x,int y,int a){
    int x2 = 0;
    int y2 = 0;
    if ((this.width > 1) | (this.height > 1)){
      x2 = x % this.width;
      y2 = y % this.height;
      if (x2 < 0){x2 = x2 + this.width;}
      if (y2 < 0){y2 = y2 + this.height;}
    }
    sq[x2][y2] = a;
  }
  int get_background_color(){
    return 0;
  }
  int get_background_color2(int x,int y,int t){
    return 0;
  }
  
  public boolean equals(boardc b){
    //System.out.println("this.width " + this.width);
    //System.out.println("this.height " + this.height);

    if (this.get_width() != b.get_width()) {return false;}
    if (this.get_height() != b.get_height()) {return false;}
    for (int x = 0;x < this.get_width();x++) {
      for (int y = 0;y < this.get_height();y++) {
        if (this.getsq(x,y) != b.getsq(x,y)) {return false;}
      }
    }
    return true;
  }
}



//this class is board made of cells
class boardc {
  blockc block[][];
  byte usedblock[][];
  int width;
  int height;
  //blockc background_block32;
  //blockc background_block32a2;
  simpleboardc background_tile_sub_board = null;
  simpleboardc background_tile_sub_board2 = null;
  int dfcolor = 0;
  int dfcolor2 = 0;
  int popcount = 0;
  boolean wrapx = true;
  boolean wrapy = true;
  boardc(){
  }
  //make a new board
  boardc(int w,int h){
    width = w;
    height = h;
    wrapx = true;
    wrapy = true;
    int w2 = ((width+31) >> 5);
    int h2 = ((height+31) >> 5);
    //background_block32 = new blockc();
    //background_block32a2 = new blockc();
    background_tile_sub_board = new simpleboardc(1,1);
    background_tile_sub_board2 = new simpleboardc(1,1);
    block = new blockc[w2][h2];
    usedblock = new byte[w2][h2];
    for (int x = 0;x < w2;x++){
      for (int y = 0;y < h2;y++){
        block[x][y] = null;
      }
    }
  }
  
  //copy board
  boardc(boardc b){
    width = b.width;
    height = b.height;
    int w2 = ((width+31) >> 5);
    int h2 = ((height+31) >> 5);
    
    block = new blockc[w2][h2];
    usedblock = new byte[w2][h2];
    copy(b);
  }
  void copy(boardc b){
    int w2 = ((width+31) >> 5);
    int h2 = ((height+31) >> 5);
    wrapx = b.wrapx;
    wrapy = b.wrapy;
    background_tile_sub_board = new simpleboardc(b.background_tile_sub_board);
    background_tile_sub_board2 = new simpleboardc(b.background_tile_sub_board2);
    dfcolor = b.dfcolor;
    dfcolor2 = b.dfcolor2;
    popcount = b.popcount;    


    for (int x = 0;x < w2;x++){
      for (int y = 0;y < h2;y++){
        if (b.block[x][y] == null){
          //block[x][y] = null;
        }else{
          if (block[x][y] == null){
            block[x][y] = new blockc(b.block[x][y]);
          }else{
            block[x][y].copy(b.block[x][y]);
          }
        }
        usedblock[x][y] = b.usedblock[x][y];
      }
    }

  }
  
  void copy_from_selection(int sel[][]) {
    for (int x = 0;x < width;x++) {
      for (int y = 0;y < height;y++) {
        setsq(x,y,sel[x][y]);
      }
    }
  }
  void paste_to_selection(int sel[][]) {
    for (int x = 0;x < width;x++) {
      for (int y = 0;y < height;y++) {
        sel[x][y] = getsq(x,y);
      }
    }
    
  }
  int get_width(){
    return this.width;
  }
  int get_height(){
    return this.height;
  }
  
  //this function checks if a row is empty
  boolean emptyline(int r){
    boolean b = true;
    for (int i = 0;i < width;i++){
      int sq = getsq(i,r);
      if (sq != get_background_color(i,r)){
        b = false;
      }
    }
    return b;
  }  
  
  void readsqcrle(String str){
    //System.out.println(" str " + str);
    int l = str.length();
    int x = 0;
    int y = 0;
    int n = 0;
    int i = 0;
    char ch = 0;
    while (i < l) {
      n = 0;
      ch = str.charAt(i);
      i++;
      while ((ch >= '0') && (ch <= '9')) {
        n = (n * 10) + (ch - 48);
        ch = str.charAt(i);
        i++;
      }
      if (n == 0) {n = 1;}
      if (ch == '$') {
        y = y + n;
        x = 0;
      } else {
        if (ch == '.') {
          x = x + n;
        } else {
          for (int i2 = 0;i2 < n;i2++){
            setsq(x,y,ch-64);
            //System.out.println(" x  " + x + " y  " + y + " ch  " + ch);
            x++;
          }
        }
      }
      //i++;
    }
  }
  String writesqcrle() {
    String str = "";
    int w = 0;
    char lastState = '0';
    boolean blankLine = false;
    char state;
    int n = 0;
    //int x = 0;
    //int y = 0;
    for (int y = 0;y < height;y++) {
      blankLine = true;
      for (int x = 0;x < width;x++) {
        if (getsq(x,y) > 0) {
          blankLine = false;
          break;
        }
      }
      if (blankLine) {
	if (lastState == '$') {n++;}
	else{
	  lastState = '$';
	  n = 1;
	}
        continue;           
      } else {
        for (int x = width - 1;x >= 0;x--){
          if (getsq(x,y) > 0) {
            w = x;
            break;
          }
        }
        for (int x = 0;x <= w;x++) {
          state = (char)(getsq(x,y) + 64);
          if (state == '@') {state = '.';}
          if (n == 0) {
            lastState = state;
	    n = 1;
	  } else if (state == lastState) {
            n++;
          } else {
            if (n > 1) {
              str = str + n;
	    }  
            str = str + lastState;             
	    if (str.length() >= 80) {
              str = str + "\n #L ";
	    }

            lastState = state;
            n = 1;
          }
        }
        if (lastState == '$'){n++; }
        else {
          if (n > 1) {
            str = str + n;
          }  
          str = str + lastState;             
          if (str.length() >= 67) {
            str = str + "\n #L ";
	  }          
          lastState = '$';
          n = 1;
        }
      }
    }
    return str;
  }
  //this function reads a run length encoded string into a row
  void readrle(int r,String str){
    int l = str.length();
    int a0 = 0;
    int a1 = 0;
    int a2 = 0;
    int a3 = 0;
    
    if (r < 0){return;}
    if (r >= height){return;}
    for (int i = 0;i < l;i++){
      char ch = str.charAt(i);
      if ((ch >= 'a')& (ch <= 'z')){
        if (a0 == 0){
          for (int i2 = 0;i2 < a2;i2++){
            if (a3 < width){
              setsq(a3,r,a1);
              //if (a1 == 1){
              //  int db = getsq(a3,r);
              //}
              a3++;
            }
          }
          a1 = ch - 97;
          
          a0 = 1;
          a2 = 0;
        }else{
          a0 = 0;
          a1 = (a1 << 4) + (ch - 97);
          a2 = 0;
        }
      }
      if ((ch >= '0') & (ch <= '9')){
        a2 = (a2*10) + (ch - 48);
      }
    }
    for (int i2 = 0;i2 < a2;i2++){
      if (a3 < width){
        setsq(a3,r,a1);
        a3++;
      }
    }
    
  }
  
  //this function writes a row to a new run length encoded string
  String writerle(int r){
    StringBuffer str = new StringBuffer();
    int a0 = getsq(0,r);
    int a1 = getsq(0,r);
    int a2 = 0;
    for (int i = 0;i < width;i++){
      a1 = getsq(i,r);
      if (a0 != a1){
        char ch1 = (char) ((a0 >> 4) + 97);
        char ch2 = (char) ((a0 & 15) + 97);
        str.append(ch1);
        str.append(ch2);
        str.append(a2);
        a2 = 1;
      }else{
        a2++;
      }
      a0 = a1;
    }

    char ch1 = (char) ((a0 >> 4) + 97);
    char ch2 = (char) ((a0 & 15) + 97);
    str.append(ch1);
    str.append(ch2);
    str.append(a2);
    return str.toString();
  }


  //getsq reads a cell from the board
  //Parameters:
  //  x: the cell's x offset
  //  y: the cell's y offset
  //Returns:
  //  the cell's state
  int getsq(int x,int y){
    int a0 = 0;
    while (x < 0){
      if (wrapx == false) {return get_background_color(x,y);}
      x = x + width;
      a0 = a0 ^ 1;
    }
    while (y < 0){
      if (wrapy == false) {return get_background_color(x,y);}
      y = y + height;
      a0 = a0 ^ 2;
    }
    while (x >= width){
      if (wrapx == false) {return get_background_color(x,y);}
      x = x - width;
      a0 = a0 ^ 1;
    }
    while (y >= height){
      if (wrapy == false) {return get_background_color(x,y);}
      y = y - height;
      a0 = a0 ^ 2;
    }
    if ((a0 & 1) == 1){
      if ((cellautoapp.symmetrybits & cellautoapp.HORIZONTAL_SYMMETRY) == cellautoapp.HORIZONTAL_SYMMETRY){
        if ((cellautoapp.symmetrybits & cellautoapp.INCLUDE_VERTICAL_LINE) == cellautoapp.INCLUDE_VERTICAL_LINE){
          x = width - x;
        }else{
          x = (width - x) - 1;
        }
      }
    }
    if ((a0 & 2) == 2){
      if ((cellautoapp.symmetrybits & cellautoapp.VERTICAL_SYMMETRY) == cellautoapp.VERTICAL_SYMMETRY){
        if ((cellautoapp.symmetrybits & cellautoapp.INCLUDE_HORIZONTAL_LINE) == cellautoapp.INCLUDE_HORIZONTAL_LINE){
          y = height - y;
        }else{
          y = (height - y) - 1;
        }
      }
    }
    //while (x < 0){x = x + width;}
    //while (y < 0){y = y + height;}
    //while (x >= width){x = x - width;}
    //while (y >= height){y = y - height;}
    blockc b = block[x >> 5][y >> 5];
    if (b == null){
      return get_background_color(x,y);
    }else{
      int sq = b.board[x & 31][y & 31];
      if (sq < 0){sq = sq + 256;}
      return sq;
    }
    
  }

  int readused436(int x,int y) {
    while (x < 0) {x = x + width;}
    while (y < 0) {y = y + height;}
    while (x >= width) {x = x - width;}
    while (y >= height) {y = y - height;}
    blockc bl = this.block[x >> 5][y >> 5];
    if (bl != null) {
      return bl.readused436((x & 31) >> 1,(y & 31) >> 1);
    }
    int i = ((y >> 2) & 4) | ((x >> 3) & 3);
    return (this.usedblock[x >> 5][y >> 5] >> i) & 1;
  }

  void writeused436(int x,int y) {
    int x3 = (x >> 1);
    int y3 = (y >> 1);
    blockc b2 = block[x3 >> 4][y3 >> 4];
    int i = ((y >> 2) & 4) | ((x >> 3) & 3);
    usedblock[x3 >> 4][y3 >> 4] = (byte) (usedblock[x3 >> 4][y3 >> 4] | (1 << i));
    if (b2 != null) {b2.writeused436(x3 & 15,y3 & 15);}
  
  }
  int get_background_color(int x,int y) {
    return get_background_color2(x,y,0);
  }
  int get_background_color2(int x,int y,int t){
     simpleboardc sub = background_tile_sub_board;
     if (t == 1) {sub = background_tile_sub_board2;}
     if (sub != null) {
      return sub.getsq(x,y);
    } else {
      if (t == 1) { return dfcolor2; }
      return dfcolor;
    }
  }
  int get_background_color4() {
    int colorcount[] = new int[256];
    int bestcolor = 0;
    int bestcount = 0;
    for (int x = 0;x < width;x++) {
      for (int y = 0;y < height;y++) {
        int sq = getsq(x,y);
        //if (sq < numcolors) {
          colorcount[sq] = colorcount[sq] + 1;
        //}
      }
    }
    for (int c = 0;c < 256;c++) {
      if (colorcount[c] > bestcount) {
        bestcount = colorcount[c];
        bestcolor = c;
      }
    }
    return bestcolor;
  }
  void clearusedbitboard(){
    //System.out.println("clearusedbitboard");
    int w2 = ((width+31) >> 5);
    int h2 = ((height+31) >> 5);
    for (int x = 0;x < w2;x++){
      for (int y = 0;y < h2;y++){
        if (block[x][y] != null){
          block[x][y].clearusedbitboard();
        } else {
          //usedblock[x][y] = 0;
        }
      }
    }
  }
  void fillusedbitboard(){
    int w2 = ((width+31) >> 5);
    int h2 = ((height+31) >> 5);
    for (int x = 0;x < w2;x++){
      for (int y = 0;y < h2;y++){
        if (block[x][y] != null){
          block[x][y].fillusedbitboard();
          usedblock[x][y] = -1;
        }
        if (usedblock[x][y] > 0) {
          usedblock[x][y] = -1;
        }
      }
    }
  }

  public boolean equals(boardc b){
    if (this.get_width() != b.get_width()) {return false;}
    if (this.get_height() != b.get_height()) {return false;}
    
    int w2 = ((this.get_width()+31) >> 5);
    int h2 = ((this.get_height()+31) >> 5);
    for (int x = 0;x < w2;x++){
      for (int y = 0;y < h2;y++){
        if (this.is_block_empty(this.block[x][y],x << 5,y << 5) == false){
          if (b.is_block_empty(b.block[x][y],x << 5,y << 5) == false){
            if (this.block[x][y].equals(b.block[x][y]) == false) { return false; }
          } else { 
            return false;
          }
        } else {
          if (b.is_block_empty(b.block[x][y],x << 5,y << 5) == false){
            return false;
          }
        }
      }
    }
    return true;
  }
  boolean is_block_empty(blockc b,int x,int y){
    if (b == null) {return true;}
    for (int x2 = 0;x2 < 32;x2++){
      for (int y2 = 0;y2 < 32;y2++){
        if (b.board[x2][y2] != this.get_background_color(x+x2,y+y2)) {
          return false;
        }
      }
    }
    return true;
  }

  blockc make_new_block(int x,int y){
    simpleboardc sub = background_tile_sub_board;
    blockc b = new blockc(dfcolor);
    if (sub != null){
      int x3 = x % sub.get_width();
      for (int x2 = 0;x2 < 32;x2++){
        int y3 = y % sub.get_height();
        for (int y2 = 0;y2 < 32;y2++){
          b.board[x2][y2] = (byte) sub.getsq(x3,y3);
          y3 = y3 + 1;
          if (y3 == sub.get_height()){y3 = 0;}
        }
        x3 = x3 + 1;
        if (x3 == sub.get_width()){x3 = 0;}
      }
    }
    return b;
  }

  //setsq writes a cell to the board
  //and also keeps track of what blocks are active
  //Parameters:
  //  x: the cell's x offset
  //  y: the cell's y offset
  //  a: the cell's new state
  void setsq(int x,int y,int a){
    int a0 = 0;
    while (x < 0){
      //if (wrapx == false) {return;}
      x = x + width;
      a0 = a0 ^ 1;
    }
    while (y < 0){
      //if (wrapy == false) {return;}
      y = y + height;
      a0 = a0 ^ 2;
    }
    while (x >= width){
      //if (wrapx == false) {return;}
      x = x - width;
      a0 = a0 ^ 1;
    }
    while (y >= height){
      //if (wrapy == false) {return;}
      y = y - height;
      a0 = a0 ^ 2;
    }
    if ((a0 & 1) == 1){
      if ((cellautoapp.symmetrybits & cellautoapp.HORIZONTAL_SYMMETRY) == cellautoapp.HORIZONTAL_SYMMETRY){
        if ((cellautoapp.symmetrybits & cellautoapp.INCLUDE_VERTICAL_LINE) == cellautoapp.INCLUDE_VERTICAL_LINE){
          x = width - x;
        }else{
          x = (width - x) - 1;
        }
      }
    }
    if ((a0 & 2) == 2){
      if ((cellautoapp.symmetrybits & cellautoapp.VERTICAL_SYMMETRY) == cellautoapp.VERTICAL_SYMMETRY){
        if ((cellautoapp.symmetrybits & cellautoapp.INCLUDE_HORIZONTAL_LINE) == cellautoapp.INCLUDE_HORIZONTAL_LINE){
          y = height - y;
        }else{
          y = (height - y) - 1;
        }
      }
    }
    blockc b = block[x >> 5][y >> 5];
    if (b == null){
      if (a == get_background_color(x,y)){return;}
      //System.out.println("setsq " + x + "," + y + " " + a);
      block[x >> 5][y >> 5] = make_new_block(x & 0xFFFFFFE0,y & 0xFFFFFFE0);
      b = block[x >> 5][y >> 5];
      usedblock[x >> 5][y >> 5] = 1;

    }
    
    if (b.board[x & 31][y & 31] == get_background_color2(x,y,1)){
      if (a != get_background_color(x,y)){
        popcount++;
        b.popcount++;
      }
    }else{
      if (a == get_background_color(x,y)){
        popcount--;
        b.popcount--;
      }
    }

    //if ((b.board[x & 31][y & 31] != get_background_color2(x,y,1)) | (a != get_background_color(x,y))){
      if (b.board[x & 31][y & 31] != ((byte) a)){
        //System.out.println("setsq43 new:" + a + " old: " + 
        //b.board[x & 31][y & 31] + " x: " + x + " y: " + y);
        useblock436(b,x,y);
      }
    //}
    if (a >= 128){a = a - 256;}

    b.board[x & 31][y & 31] = ((byte) a);
    //if (b.popcount == 0) {
      //block[x >> 5][y >> 5] = null;
    //}
  }
  int getpopcountofblock(int x,int y) {
    int a0 = 0;
    while (x < 0){
      if (wrapx == false) {return 0;}
      x = x + width;
      a0 = a0 ^ 1;
    }
    while (y < 0){
      if (wrapy == false) {return 0;}
      y = y + height;
      a0 = a0 ^ 2;
    }
    while (x >= width){
      if (wrapx == false) {return 0;}
      x = x - width;
      a0 = a0 ^ 1;
    }
    while (y >= height){
      if (wrapy == false) {return 0;}
      y = y - height;
      a0 = a0 ^ 2;
    }
    if ((a0 & 1) == 1){
      if ((cellautoapp.symmetrybits & cellautoapp.HORIZONTAL_SYMMETRY) == cellautoapp.HORIZONTAL_SYMMETRY){
        if ((cellautoapp.symmetrybits & cellautoapp.INCLUDE_VERTICAL_LINE) == cellautoapp.INCLUDE_VERTICAL_LINE){
          x = width - x;
        }else{
          x = (width - x) - 1;
        }
      }
    }
    if ((a0 & 2) == 2){
      if ((cellautoapp.symmetrybits & cellautoapp.VERTICAL_SYMMETRY) == cellautoapp.VERTICAL_SYMMETRY){
        if ((cellautoapp.symmetrybits & cellautoapp.INCLUDE_HORIZONTAL_LINE) == cellautoapp.INCLUDE_HORIZONTAL_LINE){
          y = height - y;
        }else{
          y = (height - y) - 1;
        }
      }
    }

    blockc b = block[x >> 5][y >> 5];
    if (b == null) {
      return 0;
    }
    return b.popcount;
  }
  void count_states_into_array(int c[]){
    for (int x = 0;x < width;x++) {
      for (int y = 0;y < height;y++) {
        int n = getsq(x,y);
        c[n] = c[n] + 1;
      }
    }    
  }

  void useblock436(blockc b,int x,int y) {
    int x2 = (x >> 1);
    int y2 = (y >> 1);
    
    int w2 = ((width+1) >> 1);
    int h2 = ((height+1) >> 1);
    int bs2 = cellautoapp.cellauto131.bordersize*2;
    //int bs2 = 10;
    if ((width & 1) != 0){
      if (x2 == 0){bs2++;}
      if (x2 >= (w2-2)){bs2++;}
    }
    if ((height & 1) != 0){
      if (y2 == 0){bs2++;}
      if (y2 >= (h2-2)){bs2++;}
    }
    //int bs = ((cellautoapp.cellauto131.bordersize+1) >> 1);
    int x_from = (bs2+1-(x&1)) >> 1;
    int x_to = (bs2+(x&1)) >> 1;
    int y_from = (bs2+1-(y&1)) >> 1;
    int y_to = (bs2+(y&1)) >> 1;
 
    if ((x2 < x_from) | (x2 >= (w2-x_to)) | (y2 < y_from) | (y2 >= (h2-y_to))){
    for (int dx = -x_from;dx <= x_to;dx++){
      for (int dy = -y_from;dy <= y_to;dy++){
          int x3 = x2+dx;
          int y3 = y2+dy;
          if (x3 < 0){x3 = x3 + w2;}
          if (y3 < 0){y3 = y3 + h2;}
          if (x3 >= w2){x3 = x3 - w2;}
          if (y3 >= h2){y3 = y3 - h2;}
          writeused436(x3+x3,y3+y3);
      }
    }
    } else {
    for (int dx = -x_from;dx <= x_to;dx++){
      for (int dy = -y_from;dy <= y_to;dy++){
          int x3 = x2+dx;
          int y3 = y2+dy;
          writeused436(x3+x3,y3+y3);
      }
    }    
    }
    
  }
  void changecellstates2(simpleboardc s1,simpleboardc s2) {
    if (s1.equals(s2)) {return;}
    System.out.println("changecellstates2");
    int w2 = ((width+31) >> 5);
    int h2 = ((height+31) >> 5);
    for (int x = 0;x < w2;x++){
      for (int y = 0;y < h2;y++){
        int a2 = 0;
        blockc b = block[x][y];
        if (b != null){
          for (int x2 = 0;x2 < 32;x2++) {
            for (int y2 = 0;y2 < 32;y2++) {
              int a1 = b.board[x2][y2];          
              if (a1 == s1.getsq((x<<5)+x2,(y<<5)+y2)) {
                b.board[x2][y2] = (byte) s2.getsq((x<<5)+x2,(y<<5)+y2);
              }
            }
          }
        }
      }
    }    
  }
  void changecellstates(int s1,int s2) {
    if (s1 == s2) {return;}
    if (s1 >= 128){s1 = s1 - 256;}
    if (s2 >= 128){s2 = s2 - 256;}
    
    int w2 = ((width+31) >> 5);
    int h2 = ((height+31) >> 5);
    for (int x = 0;x < w2;x++){
      for (int y = 0;y < h2;y++){
        int a2 = 0;
        blockc b = block[x][y];
        if (b != null){
          for (int x2 = 0;x2 < 32;x2++) {
            for (int y2 = 0;y2 < 32;y2++) {
              int a1 = b.board[x2][y2];          
              if (a1 == s1) {
                b.board[x2][y2] = (byte) s2;
              }
            }
          }
        }
      }
    }
  }

  void usenonemptyblocks(){
    boolean b = true;
    cellautorulec ca = cellautoapp.cellauto131;
    clearusedbitboard();
    if (ca.rulefamily != null) {
      b = ca.rulefamily.is_background_tile_optimization_on();
    } else {
    }
    if (b == true) {
      usenonemptyblocks2();
    } else {
      for (int x = 0;x < width;x = x + 2){
        for (int y = 0;y < height;y = y + 2){
        //if (b == false) {
          usedblock[x >> 5][y >> 5] = 1;          
        //}
          if (block[x >> 5][y >> 5] != null) {
          //useblock436(block[x >> 5][y >> 5],x,y);      
            block[x >> 5][y >> 5].fillusedbitboard();
          }
        }
      }
    }
    
  }
  void usenonemptyblocks2(){
    int w2 = ((width+31) >> 5);
    int h2 = ((height+31) >> 5);
    for (int x = 0;x < w2;x++){
      for (int y = 0;y < h2;y++){
        int a2 = 0;
        if (block[x][y] != null){
          for (int x2 = 0;x2 < 8;x2++){
            for (int y2 = 0;y2 < 8;y2++){
              int a0 = 0;
              for (int x3 = 0;x3 < 4;x3++){
                for (int y3 = 0;y3 < 4;y3++){
                  int a1 = block[x][y].board[(x2 << 2)+x3][(y2 << 2)+y3];
                  int bg = get_background_color((x << 5)+(x2 << 2)+x3,(y << 5)+(y2 << 2)+y3);
                  if (a1 != bg){
                    //int sq2 = board2.block[x][y].board[(x2 << 2)+x3][(y2 << 2)+y3];
                    //int sq2 = board2.getsq((x << 5)+(x2 << 2)+x3,(y << 5)+(y2 << 2)+y3);
                    //if (a1 != sq2) {
                      a0 = 1;
                      a2 = 1;
                    //}
                  }
                }
              }
              if (a0 == 1){
                for (int x3 = 0;x3 < 4;x3++) {
                  for (int y3 = 0;y3 < 4;y3++) {
                    useblock436(block[x][y],(x << 5)+(x2 << 2)+(x3 << 1)-2,(y << 5)+(y2 << 2)+(y3 << 1)-2);
                  }
                }
              }
            }
          }
        }
      }
    }
  }

};



class edit_mask_windowc extends JFrame {
  JCheckBox bit_checkbox[];
  JButton ok_button;
  JButton cancel_button;
  Container mainpanel;
  edit_mask_windowc(String Title){
    super(Title);
    GridLayout gl = new GridLayout(5,2);
    mainpanel = this.getContentPane();
    mainpanel.setLayout(gl);
    
    bit_checkbox = new JCheckBox[8];
    for (int i = 0;i < 8;i++) {
      int i2 = 1 << i;
      bit_checkbox[i] = new JCheckBox("bit " + i + " (" + i2 + "): "); 
      mainpanel.add(bit_checkbox[i]);
    }
    ok_button = new JButton("Ok");
    ok_button.setActionCommand("mask_ok_buttonclick");
    ok_button.addActionListener(cellautoapp.actlis);
    mainpanel.add(ok_button);
    cancel_button = new JButton("Cancel");
    cancel_button.setActionCommand("mask_cancel_buttonclick");
    cancel_button.addActionListener(cellautoapp.actlis);
    mainpanel.add(cancel_button);
    this.pack();
  }
  public void update_cell_mask() {
    cellautoapp.cell_mask = 0;
    for (int i = 0;i < 8;i++) {
      int i2 = 1 << i;
      if (bit_checkbox[i].isSelected()) {
        cellautoapp.cell_mask = cellautoapp.cell_mask | i2;
      }
    }
  }
  public void show() {
    super.show();
    System.out.println("show mask window");
    for (int i = 0;i < 8;i++) {
      int i2 = 1 << i;
      if ((cellautoapp.cell_mask & i2) == i2) {
        bit_checkbox[i].setSelected(true);
      } else {
        bit_checkbox[i].setSelected(false);        
      }
    }
  }
}
class trydiffpositionswindowc extends JFrame{
  JLabel currentxlabel;
  JTextField currentxedit;
  JLabel currentylabel;
  JTextField currentyedit;
  JLabel currenttlabel;
  JTextField currenttedit;

  JLabel minxlabel;
  JTextField minxedit;
  JLabel minylabel;
  JTextField minyedit;
  JLabel mintlabel;
  JTextField mintedit;

  JLabel maxxlabel;
  JTextField maxxedit;
  JLabel maxylabel;
  JTextField maxyedit;
  JLabel maxtlabel;
  JTextField maxtedit;

 
  JLabel dummylabel1;
  JLabel dummylabel2;
  JLabel dummylabel3;
  JLabel dummylabel4;
  JLabel dummylabel5;
  JLabel dummylabel6;
  
  

  JLabel generationslabel;
  JTextField generationsedit;
  JButton trybutton;
  JButton tryandmovebutton;
  JButton tryandmovebutton2;   
  JButton movebutton;
  
  
  JButton takebackbutton;

  JButton closebutton;
  Stack posstack;
  Container mainpanel;
  JLabel statusbar;
  int state = 1;
  
  
  int undostackpos = -1;
  trydiffpositionswindowc(String Title){
    super(Title);
    state = 1;
    GridLayout gl = new GridLayout(6,5);
    mainpanel = this.getContentPane();
    mainpanel.setLayout(gl);
    statusbar = new JLabel();
    statusbar.setText("status bar");

    currentxlabel = new JLabel();
    currentxlabel.setText("current x");
    mainpanel.add(currentxlabel);

    currentylabel = new JLabel();
    currentylabel.setText("current y");
    mainpanel.add(currentylabel);

    currenttlabel = new JLabel();
    currenttlabel.setText("current t");
    mainpanel.add(currenttlabel);

    generationslabel = new JLabel();
    generationslabel.setText("generations");
    mainpanel.add(generationslabel);

    dummylabel1 = new JLabel();
    mainpanel.add(dummylabel1);
    
    currentxedit = new JTextField();
    currentxedit.setText("0");
    mainpanel.add(currentxedit);

    currentyedit = new JTextField();
    currentyedit.setText("0");
    mainpanel.add(currentyedit);

    currenttedit = new JTextField();
    currenttedit.setText("0");
    mainpanel.add(currenttedit);

    generationsedit = new JTextField();
    generationsedit.setText("20");
    mainpanel.add(generationsedit);

    dummylabel2 = new JLabel();
    mainpanel.add(dummylabel2);

    

    minxlabel = new JLabel();
    minxlabel.setText("min x");
    mainpanel.add(minxlabel);

    minylabel = new JLabel();
    minylabel.setText("min y");
    mainpanel.add(minylabel);

    mintlabel = new JLabel();
    mintlabel.setText("min t");
    mainpanel.add(mintlabel);




    tryandmovebutton2 = new JButton();
    tryandmovebutton2.setText("try and move b");
    tryandmovebutton2.setActionCommand("trydiffpostryandmovebuttonclick2");
    tryandmovebutton2.addActionListener(cellautoapp.actlis);
    mainpanel.add(tryandmovebutton2);
    

    
    trybutton = new JButton();
    trybutton.setText("try");
    trybutton.setActionCommand("trydiffpostrybuttonclick");
    trybutton.addActionListener(cellautoapp.actlis);
    mainpanel.add(trybutton);

    
    
    
    minxedit = new JTextField();
    minxedit.setText("0");
    mainpanel.add(minxedit);

    minyedit = new JTextField();
    minyedit.setText("0");
    mainpanel.add(minyedit);

    mintedit = new JTextField();
    mintedit.setText("0");
    mainpanel.add(mintedit);

    tryandmovebutton = new JButton();
    tryandmovebutton.setText("try and move f");
    tryandmovebutton.setActionCommand("trydiffpostryandmovebuttonclick");
    tryandmovebutton.addActionListener(cellautoapp.actlis);
    mainpanel.add(tryandmovebutton);
    


    takebackbutton = new JButton();
    takebackbutton.setText("take back");
    takebackbutton.setActionCommand("trydiffpostakebackbuttonclick");
    takebackbutton.addActionListener(cellautoapp.actlis);
    mainpanel.add(takebackbutton);

    


    
    maxxlabel = new JLabel();
    maxxlabel.setText("max x");
    mainpanel.add(maxxlabel);

    maxylabel = new JLabel();
    maxylabel.setText("max y");
    mainpanel.add(maxylabel);

    maxtlabel = new JLabel();
    maxtlabel.setText("max t");
    mainpanel.add(maxtlabel);

    closebutton = new JButton();
    closebutton.setText("close");
    closebutton.setActionCommand("trydiffposclosebuttonclick");
    closebutton.addActionListener(cellautoapp.actlis);
    mainpanel.add(closebutton);


    movebutton = new JButton();
    movebutton.setText("move");
    movebutton.setActionCommand("trydiffposmovebuttonclick");
    movebutton.addActionListener(cellautoapp.actlis);
    mainpanel.add(movebutton);



    maxxedit = new JTextField();
    maxxedit.setText("0");
    mainpanel.add(maxxedit);

    maxyedit = new JTextField();
    maxyedit.setText("0");
    mainpanel.add(maxyedit);

    maxtedit = new JTextField();
    maxtedit.setText("0");
    mainpanel.add(maxtedit);

    dummylabel5 = new JLabel();
    mainpanel.add(dummylabel5);

    dummylabel6 = new JLabel();
    mainpanel.add(dummylabel6);
    
    this.pack();

  }
  void updatestatusbar(){
  }
  void popbuttonclick(){
    state = 1;
    updatestatusbar();
  }
  void closebuttonclick(){
    
    if (cellautoapp.undodata.size() > 0){
      cellautoapp.restoreboard(cellautoapp.RESTORE_FROM_UNDO_STACK);
    }
    cellautoapp.updatestatusbar();
    cellautoapp.cellautomainwindow.repaint();
    updatestatusbar();
  }

  void pushbuttonclick(){
    state = 1;
  }
  
  void takebackbuttonclick(){
    if (cellautoapp.undodata.size() > 0){
      cellautoapp.restoreboard(cellautoapp.RESTORE_FROM_UNDO_STACK);
    }
    cellautoapp.updatestatusbar();
    cellautoapp.cellautomainwindow.repaint();
  }
  void movebuttonclick(){
    int x = Integer.parseInt(currentxedit.getText());
    int y = Integer.parseInt(currentyedit.getText());
    cellautoapp.saveboard(cellautoapp.SAVE_TO_UNDO_STACK);
    if (cellautoapp.cellauto131.rulechange > 0){
      cellautoapp.board.usenonemptyblocks();
      cellautoapp.cellauto131.rulechange--;
    }
    cellautoapp.selx1 = cellautoapp.selx1 + x;
    cellautoapp.sely1 = cellautoapp.sely1 + y;
    cellautoapp.selx2 = cellautoapp.selx2 + x;
    cellautoapp.sely2 = cellautoapp.sely2 + y;
    cellautoapp.setupsel();
    cellautoapp.updatestatusbar();
    cellautoapp.cellautomainwindow.repaint();
  
  }
  void trybuttonclick(){
    int numgenerations = Integer.parseInt(generationsedit.getText());
    int x = Integer.parseInt(currentxedit.getText());
    int y = Integer.parseInt(currentyedit.getText());
    int t = Integer.parseInt(currenttedit.getText());

    state = 0;
    cellautoapp.saveboard(cellautoapp.SAVE_TO_UNDO_STACK);
    cellautoapp.redodata.clear();
    if (cellautoapp.cellauto131.rulechange > 0){
      cellautoapp.board.usenonemptyblocks();
      cellautoapp.cellauto131.rulechange--;
    }
    cellautoapp.selx1 = cellautoapp.selx1 + x;
    cellautoapp.sely1 = cellautoapp.sely1 + y;
    cellautoapp.selx2 = cellautoapp.selx2 + x;
    cellautoapp.sely2 = cellautoapp.sely2 + y;
    cellautoapp.setupsel();

    for (int i = 0;i < numgenerations;i++){
      if (i == t){
        cellautoapp.pasteseldata();
        cellautoapp.selx1 = 0;
        cellautoapp.sely1 = 0;
        cellautoapp.selx2 = 0;
        cellautoapp.sely2 = 0;
        cellautoapp.setupsel();
      }
      boardc tmp = cellautoapp.board;
      cellautoapp.board = cellautoapp.cellauto131.calc436(cellautoapp.board,cellautoapp.board2);
      cellautoapp.board2 = tmp;
    }
    cellautoapp.generation = cellautoapp.generation + numgenerations;
    cellautoapp.updatestatusbar();
    cellautoapp.cellautomainwindow.repaint();

  }
  void tryandmovebuttonclick(int tt){
    int x = Integer.parseInt(currentxedit.getText());
    int y = Integer.parseInt(currentyedit.getText());
    int t = Integer.parseInt(currenttedit.getText());
    int minx = Integer.parseInt(minxedit.getText());
    int miny = Integer.parseInt(minyedit.getText());
    int mint = Integer.parseInt(mintedit.getText());
    int maxx = Integer.parseInt(maxxedit.getText());
    int maxy = Integer.parseInt(maxyedit.getText());
    int maxt = Integer.parseInt(maxtedit.getText());
    if (tt == 0){
    x = x + 1;
    if (x > maxx){
      x = minx;
      y = y + 1;
      if (y > maxy){
        y = miny;
        t = t + 1;
        if (t > maxt){
          t = mint;
        }
      }
    }
    }
    if (tt == 1){
    x = x - 1;
    if (x < minx){
      x = maxx;
      y = y - 1;
      if (y < miny){
        y = maxy;
        t = t - 1;
        if (t > mint){
          t = maxt;
        }
      }
    }
    }
    currentxedit.setText(Integer.toString(x));
    currentyedit.setText(Integer.toString(y));
    currenttedit.setText(Integer.toString(t));
    trybuttonclick();
  }
}

class statistics_windowc extends JFrame {
  JList listbox;
  JButton button1;
  JButton button2;
  JCheckBox selectionbox;
  JLabel infolabel;
  JScrollPane listboxscroller;
  DefaultListModel list;  
  statistics_windowc(String Title) {
    super(Title);
    list = new DefaultListModel();
    listbox = new JList(list);
    listboxscroller = new JScrollPane(listbox);
    selectionbox = new JCheckBox("get statistics from selection");
    infolabel = new JLabel("info");
    button1 = new JButton("refresh");
    button1.setActionCommand("statistics_window_refresh");
    button1.addActionListener(cellautoapp.actlis);

    button2 = new JButton("close");
    button2.setActionCommand("statistics_window_close");
    button2.addActionListener(cellautoapp.actlis);
    SpringLayout spl = new SpringLayout();
    this.getContentPane().setLayout(spl);
    spl.putConstraint(SpringLayout.EAST,listboxscroller,-2,SpringLayout.EAST,this.getContentPane());
    spl.putConstraint(SpringLayout.WEST,listboxscroller,2,SpringLayout.WEST,this.getContentPane());
    spl.putConstraint(SpringLayout.SOUTH,listboxscroller,-70,SpringLayout.SOUTH,this.getContentPane());
    spl.putConstraint(SpringLayout.NORTH,listboxscroller,2,SpringLayout.NORTH,this.getContentPane());
    spl.putConstraint(SpringLayout.NORTH,selectionbox,0,SpringLayout.SOUTH,listboxscroller);
    spl.putConstraint(SpringLayout.NORTH,infolabel,0,SpringLayout.SOUTH,selectionbox);
    spl.putConstraint(SpringLayout.NORTH,button1,0,SpringLayout.SOUTH,infolabel);
    spl.putConstraint(SpringLayout.NORTH,button2,0,SpringLayout.SOUTH,infolabel);
    //spl.putConstraint(SpringLayout.SOUTH,button1,0,SpringLayout.SOUTH,this.getContentPane());
    //spl.putConstraint(SpringLayout.SOUTH,button2,0,SpringLayout.SOUTH,this.getContentPane());
    spl.putConstraint(SpringLayout.WEST,button1,0,SpringLayout.WEST,this.getContentPane());
    spl.putConstraint(SpringLayout.WEST,button2,0,SpringLayout.EAST,button1);
    this.getContentPane().add(listboxscroller);
    this.getContentPane().add(selectionbox);
    this.getContentPane().add(infolabel);
    this.getContentPane().add(button1);
    this.getContentPane().add(button2);
    //list.add("test");
    this.pack();    
  }
  void refresh_button_click() {
    //System.out.println("refresh");
    
    int c[] = new int[256];
    int n = cellautoapp.cellauto131.getnumcolors();
    int n2 = 0;
    if ((selectionbox.isSelected()) & (cellautoapp.selw > 0) & (cellautoapp.selh > 0)) {
      cellautoapp.count_seldata_into_array(c);
      n2 = cellautoapp.selw * cellautoapp.selh;
    } else {
      cellautoapp.board.count_states_into_array(c);
      n2 = cellautoapp.board.get_width() * cellautoapp.board.get_height();
    }
    int n3 = n2 - c[0];
    infolabel.setText("total states: " + n2 + "  alive states: " + n3);
    list.clear();
    for (int a = 0;a < n;a++) {
      float f = ((float) c[a]) * 100;
      if (n2 == 0) {
      f = 100;
      } else {
      f = f / ((float) n2); 
      }
      int a2 = (int) f;
      list.addElement("state " + a + ": " + c[a] + "  " + a2 + "%");
    }
  }
  void close_button_click() {
    //System.out.println("close");
    this.setVisible(false);
  }
}

class infowindowc extends JFrame {
  JLabel label[];
  int numlabels;
  infowindowc(String Title) {
    super(Title);
    GridLayout gl = new GridLayout(7,2);
    this.getContentPane().setLayout(gl);
    numlabels = 14;
    label = new JLabel[numlabels];
    for (int i = 0;i < numlabels;i++){
      label[i] = new JLabel();
      this.getContentPane().add(label[i]);
    }
  }
  //if (cellautoapp.infowindow != null){cellautoapp.infowindow.updateinfo();}

  void updateinfo() {
    int n = (cellautoapp.undodata.size() + boardstate.s);
    int n2 = cellautoapp.redodata.size();
    label[0].setText("undo: " + n);
    label[1].setText("redo: " + n2);
    label[2].setText("generation: " + cellautoapp.generation);
    label[3].setText("pop count: " + cellautoapp.board.popcount);
    label[4].setText("color: " + cellautoapp.colorlistindex);
    label[5].setText("tool: " + cellautoapp.toolname[cellautoapp.toollistindex]);
    if (cellautoapp.panmode == true) {
      label[6].setText("pan mode is on ");
    } else {
      label[6].setText("pan mode is off ");
    }
    if (cellautoapp.dropselectionbeforerunning == true) {
      label[7].setText("drop selection ");
    } else {
      label[7].setText("keep selection ");
    }
    
    label[8].setText("board size: " + cellautoapp.board.width + "x" + cellautoapp.board.height);
    int bs = (cellautoapp.cellauto131.bordersize * 2) + 1;
    label[9].setText("neighborhood size: " + bs + "x" + bs);
    label[10].setText("rule table size: " + cellautoapp.cellauto131.tablewidth + "x" + cellautoapp.cellauto131.tableheight);
    if ((cellautoapp.selw > 0) & (cellautoapp.selh > 0)) {
      label[11].setText("selection: ("  + cellautoapp.selx + "," + cellautoapp.sely + "," + cellautoapp.selw + "," + cellautoapp.selh + ")");
    } else {
      label[11].setText("selection: NA");
    }
    if (cellautoapp.cellauto131.rulefamily == null) {
      label[12].setText("rule family: default");
    } else {
      String name = cellautoapp.cellauto131.rulefamily.getname();
      label[12].setText("rule family: " + name);
    }
    label[13].setText("table offset: " + cellautoapp.cellauto131.tableoffset);
  }
}
class colorboxadjlisc implements AdjustmentListener{
  public void adjustmentValueChanged(AdjustmentEvent e) {
    int i = e.getValue();
    cellautoapp.colorbox.colorboxpanel.offset = i;
    
    cellautoapp.colorbox.colorboxpanel.repaint();
    
  }
}
class colorboxkeylisc implements KeyListener{
  public void keyPressed(KeyEvent e){
    int a = e.getKeyCode();
    char ch = e.getKeyChar();  
    if (ch == cellautokeys.prev_color_key){
      cellautoapp.colorbox.colorboxpanel.selcolor = (cellautoapp.colorbox.colorboxpanel.selcolor - 1 + cellautoapp.cellauto131.numcolors) % cellautoapp.cellauto131.numcolors;
      cellautoapp.colorlistindex = cellautoapp.colorbox.colorboxpanel.selcolor;
      cellautoapp.colorbox.colorboxpanel.repaint();
      cellautoapp.updatestatusbar();
    }
    if (ch == cellautokeys.next_color_key){
      cellautoapp.colorbox.colorboxpanel.selcolor = (cellautoapp.colorbox.colorboxpanel.selcolor + 1) % cellautoapp.cellauto131.numcolors;
      cellautoapp.colorlistindex = cellautoapp.colorbox.colorboxpanel.selcolor;
      cellautoapp.colorbox.colorboxpanel.repaint();
      cellautoapp.updatestatusbar();
    }
  }
  public void keyReleased(KeyEvent e){
    
  }
  public void keyTyped(KeyEvent e){
  }
}

class colorboxc extends JFrame{
  colorboxpanelc colorboxpanel;
  JScrollBar scrollbar;
  colorboxadjlisc adjlis;
  static boolean colorboxautoscroll = true;
  colorboxc(String Title){
    super(Title);
    colorboxpanel = new colorboxpanelc();
    scrollbar = new JScrollBar(JScrollBar.VERTICAL);
    scrollbar.setMinimum(0);
    scrollbar.setMaximum(64);
    scrollbar.setVisibleAmount(0);
    adjlis = new colorboxadjlisc();
    scrollbar.addAdjustmentListener(adjlis);
    SpringLayout spl = new SpringLayout();         
    this.getContentPane().setLayout(spl);
    spl.putConstraint(SpringLayout.WEST,scrollbar,0,SpringLayout.EAST,colorboxpanel);
    spl.putConstraint(SpringLayout.SOUTH,colorboxpanel,0,SpringLayout.SOUTH,this.getContentPane());
    spl.putConstraint(SpringLayout.SOUTH,scrollbar,0,SpringLayout.SOUTH,colorboxpanel);
    spl.putConstraint(SpringLayout.NORTH,scrollbar,0,SpringLayout.NORTH,this.getContentPane());
    spl.putConstraint(SpringLayout.NORTH,colorboxpanel,0,SpringLayout.NORTH,this.getContentPane());

    this.getContentPane().add(colorboxpanel);
    this.getContentPane().add(scrollbar);
    
    keylisc keylis = new keylisc();
    colorboxpanel.addKeyListener(keylis);
    scrollbar.addKeyListener(keylis);
    colorboxpanel.setFocusable(true);
  }
}
class colorboxpanelmouselisc implements MouseListener{
  long lasttime;
  int last_sq;
  public void mouseClicked(MouseEvent e){}
  public void mouseEntered(MouseEvent e){}
  public void mouseExited(MouseEvent e){}
  public void mousePressed(MouseEvent e){
    long time = System.currentTimeMillis();
    int x = e.getX() / colorboxpanelc.sqsize;
    int y = e.getY() / colorboxpanelc.sqsize;
    //y = y + cellautoapp.colorbox.colorboxpanel.offset;
    int i2 = (((cellautoapp.colorbox.colorboxpanel.offset+y)*colorboxpanelc.numcolorsperrow)+x);
    if (i2 < cellautoapp.cellauto131.numcolors){
      //select the color
      cellautoapp.colorbox.colorboxpanel.selcolor = i2;
    }
    cellautoapp.colorlistindex = cellautoapp.colorbox.colorboxpanel.selcolor;
    if (cellautoapp.addeditstatedialog.isVisible() == true){
      cellautoapp.addeditstatedialog.selectstate(cellautoapp.colorlistindex);
    } else if (((time-lasttime) <= 1000) & (i2 == last_sq)){
      cellautoapp.addeditstatedialog.setVisible(true);
      cellautoapp.addeditstatedialog.selectstate(cellautoapp.colorlistindex);
    }
    lasttime = time;
    last_sq = i2;
    cellautoapp.colorbox.colorboxpanel.repaint();
    cellautoapp.updatestatusbar();
  }
  public void mouseReleased(MouseEvent e){
    
  }
  
}
class colorboxpanelc extends JPanel{
  colorboxpanelmouselisc mouselis;
  int offset;
  static int selcolor;
  static int default_sqsize = 32;
  static int sqsize = default_sqsize;
  static int numcolorsperrow = 8;
  colorboxpanelc(){
    mouselis = new colorboxpanelmouselisc();
    addMouseListener(mouselis);
    selcolor = cellautoapp.colorlistindex;
    offset = 0;
  }
  public Dimension getPreferredSize(){
    return new Dimension(colorboxpanelc.sqsize*numcolorsperrow,colorboxpanelc.sqsize*2);
  }
  
  //this function paints the color box
  protected void paintComponent(Graphics g){ 
     super.paintComponent(g);
     Rectangle r = this.getBounds();
     int w = r.width;
     int h = r.height;
     int sqsize = colorboxpanelc.sqsize;
     //int numcolorrows = h / colorboxpanelc.sqsize;
     int numcolorrows = 2;
     if (cellautoapp.digits_image == null) {
        cellautoapp.load_digits_image();
     }
     
    //draw the colors using rectangles
    for (int y = 0;y < numcolorrows;y++){
      for (int x = 0;x < numcolorsperrow;x++){
        if ((((offset+y)*numcolorsperrow)+x) < cellautoapp.cellauto131.numcolors) {
          g.setColor(cellautoapp.cellauto131.getcellvaluecolor(((offset+y)*numcolorsperrow)+x));
          g.fillRect(x*colorboxpanelc.sqsize,y*colorboxpanelc.sqsize,colorboxpanelc.sqsize,colorboxpanelc.sqsize);
  	  int a1 = cellautoapp.cellauto131.getcellvalue(((offset+y)*numcolorsperrow)+x);
          int a2 = (sqsize / 2);
	  int lx = (x*sqsize)+a2;
	  int ly = (y*sqsize)+a2-8;
	  if (a1 < 100) {
	    if (a1 > 0) {
	      g.drawImage(cellautoapp.digits_image,lx,ly,lx+8,ly+16,((a1%10)*8),0,((a1%10)*8)+8,16,null);
            }
	    if (a1 >= 10) {
	      g.drawImage(cellautoapp.digits_image,lx-8,ly,lx,ly+16,((a1/10)*8),0,((a1/10)*8)+8,16,null);
            }
	  }
        }else{
          g.setColor(Color.gray);
          g.fillRect(x*colorboxpanelc.sqsize,y*colorboxpanelc.sqsize,colorboxpanelc.sqsize,colorboxpanelc.sqsize);
        }
	  
      }
    }
    
    //draw a outline around the selected color
    int selcolorx = selcolor % numcolorsperrow;
    int selcolory = selcolor / numcolorsperrow;
    if ((selcolory-offset) >= 0){
      if ((selcolory-offset) < numcolorrows){
        g.setColor(new Color(255,0,0));
        for (int i = 0;i < 4;i++){
          g.drawRect((selcolorx*colorboxpanelc.sqsize)+i,((selcolory-offset)*colorboxpanelc.sqsize)+i,colorboxpanelc.sqsize-(i*2),colorboxpanelc.sqsize-(i*2));
        }
      }
    }
    
    //draw the grid 
    g.setColor(Color.blue);
    for (int x = 1;x < numcolorsperrow;x++){
      g.drawLine(x*sqsize,0,x*sqsize,numcolorrows*sqsize);
    }
    for (int y = 1;y < numcolorrows;y++){
      g.drawLine(0,y*sqsize,numcolorsperrow*sqsize,y*sqsize);
    }
  }  
}
class toolboxactlisc implements ActionListener{
  public void actionPerformed(ActionEvent e) {
    String action = e.getActionCommand();
    System.out.println("action" + action);
    if (action.equals("rectangle")){
      cellautoapp.toollistindex = cellautoapp.RECTANGLE_TOOL;
    }
    if (action.equals("fillrectangle")){
      cellautoapp.toollistindex = cellautoapp.FILLEDRECTANGLE_TOOL;
    }
    if (action.equals("select")){
      cellautoapp.toollistindex = cellautoapp.SELECT_TOOL;
    }
    if (action.equals("move")){
      cellautoapp.toollistindex = cellautoapp.MOVE_TOOL;
    }
    if (action.equals("table")){
      cellautoapp.toollistindex = cellautoapp.TABLE_TOOL;
    }
    if (action.equals("circle")){
      cellautoapp.toollistindex = cellautoapp.CIRCLE_TOOL;
    }
    if (action.equals("fillcircle")){
      cellautoapp.toollistindex = cellautoapp.FILLEDCIRCLE_TOOL;
    }
    if (action.equals("zoomin")){
      cellautoapp.toollistindex = cellautoapp.ZOOMIN_TOOL;
    }
    if (action.equals("zoomout")){
      cellautoapp.toollistindex = cellautoapp.ZOOMOUT_TOOL;
    }
    if (action.equals("line")){
      cellautoapp.toollistindex = cellautoapp.LINE_TOOL;
    }
    if (action.equals("pencil")){
      cellautoapp.toollistindex = cellautoapp.PENCIL_TOOL;
    }
    if (action.equals("fill")){
      cellautoapp.toollistindex = cellautoapp.FILL_TOOL;
    }
    
    cellautoapp.updatestatusbar();
    cellautoapp.cellautomainwindow.repaint();
  }
}
class toolboxc extends JFrame{
  JToggleButton pencilbutton;
  JToggleButton linebutton;
  JToggleButton rectanglebutton;
  JToggleButton fillrectanglebutton;
  JToggleButton circlebutton;
  JToggleButton fillcirclebutton;
  JToggleButton zoominbutton;
  JToggleButton zoomoutbutton;
  JToggleButton selectbutton;
  JToggleButton movebutton;
  JToggleButton tablebutton;
  JToggleButton fillbutton;
  
  toolboxactlisc actlis;
  ButtonGroup b;  
  toolboxc(String Title){
    super(Title);
    actlis = new toolboxactlisc();
    b = new ButtonGroup();
    GridLayout gl = new GridLayout(2,6);
    this.getContentPane().setLayout(gl);
    ImageIcon icon = null;
    
    icon = cellautoapp.createImageIcon("toolbar/zoomin.png","zooms in");
    zoominbutton = new JToggleButton(icon);
    zoominbutton.addActionListener(actlis);
    zoominbutton.setActionCommand("zoomin");
    //this.getContentPane().add(zoominbutton);
    b.add(zoominbutton);
    
    icon = cellautoapp.createImageIcon("toolbar/zoomout.png","zooms out");
    zoomoutbutton = new JToggleButton(icon);
    zoomoutbutton.addActionListener(actlis);
    zoomoutbutton.setActionCommand("zoomout");
    //this.getContentPane().add(zoomoutbutton);
    b.add(zoomoutbutton);
    
    
    icon = cellautoapp.createImageIcon("toolbar/line.png","draws a line");
    linebutton = new JToggleButton(icon);
    linebutton.addActionListener(actlis);
    linebutton.setActionCommand("line");
    //this.getContentPane().add(linebutton);
    b.add(linebutton);
    
    icon = cellautoapp.createImageIcon("toolbar/pencil.png","use pencil");
    pencilbutton = new JToggleButton(icon);
    pencilbutton.addActionListener(actlis);
    pencilbutton.setActionCommand("pencil");
    //this.getContentPane().add(pencilbutton);
    b.add(pencilbutton);
    
    
    icon = cellautoapp.createImageIcon("toolbar/circle.png","draw a circle");
    circlebutton = new JToggleButton(icon);
    circlebutton.addActionListener(actlis);
    circlebutton.setActionCommand("circle");
    //this.getContentPane().add(circlebutton);
    b.add(circlebutton);
    
    icon = cellautoapp.createImageIcon("toolbar/filledcircle.png","draw a filled circle");
    fillcirclebutton = new JToggleButton(icon);
    fillcirclebutton.addActionListener(actlis);
    fillcirclebutton.setActionCommand("fillcircle");
    //this.getContentPane().add(fillcirclebutton);
    b.add(fillcirclebutton);
    
    icon = cellautoapp.createImageIcon("toolbar/rectangle.png","draw a rectangle");
    rectanglebutton = new JToggleButton(icon);
    rectanglebutton.addActionListener(actlis);
    rectanglebutton.setActionCommand("rectangle");
    //this.getContentPane().add(rectanglebutton);
    b.add(rectanglebutton);
    
    icon = cellautoapp.createImageIcon("toolbar/filledrectangle.png","draw a filled rectangle");
    fillrectanglebutton = new JToggleButton(icon);
    fillrectanglebutton.addActionListener(actlis);
    fillrectanglebutton.setActionCommand("fillrectangle");
    b.add(fillrectanglebutton);
    
    icon = cellautoapp.createImageIcon("toolbar/select.png","select cells");
    selectbutton = new JToggleButton(icon);
    selectbutton.addActionListener(actlis);
    selectbutton.setActionCommand("select");
    b.add(selectbutton);
    
    icon = cellautoapp.createImageIcon("toolbar/move.png","move cells");
    movebutton = new JToggleButton(icon);
    movebutton.addActionListener(actlis);
    movebutton.setActionCommand("move");
    b.add(movebutton);
    
    icon = cellautoapp.createImageIcon("toolbar/table.png","edit table");
    tablebutton = new JToggleButton(icon);
    tablebutton.addActionListener(actlis);
    tablebutton.setActionCommand("table");
    //this.getContentPane().add(tablebutton);
    b.add(tablebutton);
    
    icon = cellautoapp.createImageIcon("toolbar/bucketfill.png","bucket fill");
    fillbutton = new JToggleButton(icon);
    fillbutton.addActionListener(actlis);
    fillbutton.setActionCommand("fill");
    //this.getContentPane().add(fillbutton);
    b.add(fillbutton);
    
    
    this.getContentPane().add(zoominbutton);
    this.getContentPane().add(linebutton);
    this.getContentPane().add(circlebutton);
    this.getContentPane().add(rectanglebutton);
    this.getContentPane().add(selectbutton);
    this.getContentPane().add(tablebutton);
    this.getContentPane().add(zoomoutbutton);
    this.getContentPane().add(pencilbutton);
    this.getContentPane().add(fillcirclebutton);
    this.getContentPane().add(fillrectanglebutton);
    this.getContentPane().add(movebutton);
    this.getContentPane().add(fillbutton);
    
    
    
    this.pack();
  }
}
class edittablekeylisc implements KeyListener{
  public void keyPressed(KeyEvent e){
    System.out.println("key press");
    int a = e.getKeyCode();
    char ch = e.getKeyChar();  
    ch = Character.toLowerCase(ch);
    if ((ch == cellautokeys.calc_key)|(ch == cellautokeys.calc_key2)){
      int n = 1;
      if (ch == cellautokeys.calc_key2){n = cellautoapp.timestep;}
      cellautoapp.calc(n,false);
    }
    if (ch == cellautokeys.prev_color_key){
      cellautoapp.colorbox.colorboxpanel.selcolor = (cellautoapp.colorbox.colorboxpanel.selcolor - 1 + cellautoapp.cellauto131.numcolors) % cellautoapp.cellauto131.numcolors;
      cellautoapp.colorlistindex = cellautoapp.colorbox.colorboxpanel.selcolor;
      cellautoapp.colorbox.colorboxpanel.repaint();
      cellautoapp.updatestatusbar();
    }
    if (ch == cellautokeys.next_color_key){
      cellautoapp.colorbox.colorboxpanel.selcolor = (cellautoapp.colorbox.colorboxpanel.selcolor + 1) % cellautoapp.cellauto131.numcolors;
      cellautoapp.colorlistindex = cellautoapp.colorbox.colorboxpanel.selcolor;
      cellautoapp.colorbox.colorboxpanel.repaint();
      cellautoapp.updatestatusbar();
    }
    if (ch == cellautokeys.undo_key){
      cellautoapp.restoreboard();
      cellautoapp.updatestatusbar();
      cellautoapp.cellautomainwindow.repaint();
      cellautoapp.edittablewindow.edittablepanel.repaint();
    }
    if (ch == cellautokeys.save_to_stack_key){
      boardstate.s = 1;
      cellautoapp.updatestatusbar();
    }
  }
  public void keyReleased(KeyEvent e){
    System.out.println("key release");
    
  }
  public void keyTyped(KeyEvent e){
    System.out.println("key type");
  }
}
class edittablemousemotionlisc implements MouseMotionListener{
  public void mouseDragged(MouseEvent e){
    int x = e.getX() / edittablepanelc.sqsize;
    int y = e.getY() / edittablepanelc.sqsize;
    int x2 = cellautoapp.edittablewindow.edittablepanel.offsetx;
    int y2 = cellautoapp.edittablewindow.edittablepanel.offsety;
    int cell_mask = cellautoapp.cell_mask;
    if (e.isControlDown() == true){
      int i = cellautoapp.colorlistindex & cell_mask;
      int old_color = cellautoapp.cellauto131.getlookuptable(x+x2,y+y2);
      if (cellautoapp.xor_mode == true) {
        int i2 = i ^ old_color;
        if (i2 < cellautoapp.cellauto131.numcolors) {
          cellautoapp.cellauto131.setlookuptable(x+x2,y+y2,i2);
        }
      } else {
        cellautoapp.cellauto131.setlookuptable(x+x2,y+y2,i | (old_color & ~cell_mask));
      }
      int new_color = cellautoapp.cellauto131.getlookuptable(x+x2,y+y2);
      if (old_color != new_color) {
        cellautoapp.edittablewindow.edittablepanel.repaint();
        //System.out.println("repaint table");
      }
    }
  }
  public void mouseMoved(MouseEvent e){
  
  }
}


class edittablemouselisc implements MouseListener{
  int lx = 0;
  int ly = 0;
  public void mouseClicked(MouseEvent e){
    
  }
  public void mouseEntered(MouseEvent e){
    
  } 
  public void mouseExited(MouseEvent e){
    
  }
  public void mousePressed(MouseEvent e){
    int x = e.getX() / edittablepanelc.sqsize;
    int y = e.getY() / edittablepanelc.sqsize;
    int x2 = cellautoapp.edittablewindow.edittablepanel.offsetx;
    int y2 = cellautoapp.edittablewindow.edittablepanel.offsety;
    lx = x+x2; 
    ly = y+y2; 
  }
  public void mouseReleased(MouseEvent e){
    int x = e.getX() / edittablepanelc.sqsize;
    int y = e.getY() / edittablepanelc.sqsize;
    int x2 = cellautoapp.edittablewindow.edittablepanel.offsetx;
    int y2 = cellautoapp.edittablewindow.edittablepanel.offsety;
    int cell_mask = cellautoapp.cell_mask;
    if ((x+x2) < cellautoapp.cellauto131.tablewidth){
      if ((y+y2) < cellautoapp.cellauto131.tableheight){
	if (((lx == (x+x2)) & (ly == (y+y2))) | e.isControlDown()) {
  	  if (cellautoapp.toollistindex == cellautoapp.COLOR_PICKER_TOOL){
            int i = cellautoapp.cellauto131.getlookuptable(x+x2,y+y2);
            cellautoapp.colorbox.colorboxpanel.selcolor = i;
            cellautoapp.colorlistindex = i;          
            if (cellautoapp.addeditstatedialog.isVisible() == true){
             cellautoapp.addeditstatedialog.selectstate(cellautoapp.colorlistindex);
            } 
            cellautoapp.updatestatusbar();
            cellautoapp.colorbox.colorboxpanel.repaint();
          } else {
            int i = cellautoapp.colorlistindex & cell_mask;
            int i3 = cellautoapp.cellauto131.getlookuptable(x+x2,y+y2);
	    if (cellautoapp.xor_mode == true) {
              int i2 = i ^ i3;
              if (i2 < cellautoapp.cellauto131.numcolors) {
                cellautoapp.cellauto131.setlookuptable(x+x2,y+y2,i2);
              }
            } else {
              cellautoapp.cellauto131.setlookuptable(x+x2,y+y2,i | (i3 & ~cell_mask));
            }
            if (cellautoapp.usetableshortcut53){
              String modstr = e.getMouseModifiersText(-1);
          //System.out.println("modstr " + modstr);
              if (modstr.equals("Shift")){
                while (y < cellautoapp.cellauto131.tableheight){
                  y++;
                  i++;
                  if (i == cellautoapp.cellauto131.numcolors){
                    i = 0;
                  }
                  cellautoapp.cellauto131.setlookuptable(x+x2,y+y2,i);
                }
              }
            }
          }
	} else {
            //int i = cellautoapp.colorlistindex;
            int a1 = cellautoapp.cellauto131.getlookuptable(lx,ly);
            int a2 = cellautoapp.cellauto131.getlookuptable(x+x2,y+y2);
	    cellautoapp.cellauto131.setlookuptable(lx,ly,(a2 & cell_mask) | (a1 & ~cell_mask));
	    cellautoapp.cellauto131.setlookuptable(x+x2,y+y2,(a1 & cell_mask) | (a2 & ~cell_mask));
          
	}
        cellautoapp.edittablewindow.edittablepanel.repaint();
      }
    }
    
  } 
}

class edittableadjlisc implements AdjustmentListener{
  public void adjustmentValueChanged(AdjustmentEvent e) {
    Adjustable a = e.getAdjustable();
    int i = e.getValue();
    //System.out.println(" i  " + i);
    if (a == cellautoapp.edittablewindow.hscroll){
      cellautoapp.edittablewindow.edittablepanel.offsetx = i;
    }
    if (a == cellautoapp.edittablewindow.vscroll){
      cellautoapp.edittablewindow.edittablepanel.offsety = i;
    }
    cellautoapp.edittablewindow.edittablepanel.repaint();
  }
}

class edittablepanelc extends JPanel{
  int offsetx;
  int offsety;
  edittablemouselisc mouselis;
  edittablemousemotionlisc mousemotionlis;
  //edittablekeylisc keylis;
  keylisc keylis;
  static int show_numbers = 1;
  static int show_colors = 1;
  
  static int default_sqsize = 16;
  static int sqsize = default_sqsize;
  static int grid_x_spacing = 5;
  static int grid_y_spacing = 5;
  static int grid_x_spacing2 = 10;
  static int grid_y_spacing2 = 10;
  static Color gridcolor1 = Color.blue;
  static Color gridcolor2 = Color.cyan;
  static Color gridcolor3 = Color.white;
  edittablepanelc(){
    mouselis = new edittablemouselisc();
    this.addMouseListener(mouselis);
    
    
    mousemotionlis = new edittablemousemotionlisc();
    this.addMouseMotionListener(mousemotionlis);    
    
    keylis = new keylisc();
    this.addKeyListener(keylis);
    
    
    
    offsetx = 0;
    offsety = 0;
  }
  
  //paintsmallsquare draws a small square on top of a table entry
  static void paintsmallsquare(Graphics g,int x,int y,int a,Color c1,Color c2,int a2){
    Color c3 = cellautoapp.cellauto131.getcellvaluecolor(a);
    int c4 = c3.getRed() + c3.getGreen() + c3.getBlue();
    if (c4 >= 384){
      g.setColor(c1);
    } else{
      g.setColor(c2);
    }
    
    if (a2 == -1){
      g.fillRect((x*sqsize)+(sqsize/4),(y*sqsize)+(sqsize/4),sqsize/2,sqsize/2);                
    }
    if (a2 == 0){
      g.fillRect((x*sqsize)+((3*sqsize)/8),(y*sqsize)+((3*sqsize)/8),sqsize/4,sqsize/4);                
    }
  }

  protected void paintComponent(Graphics g){ 
    super.paintComponent(g);
    int h = (getHeight() / sqsize) + 1;
    int w = (getWidth() / sqsize) + 1;
    draw_rule_table(g,offsetx,offsety,w,h);
  }
  //this function draws the rule table
  static void draw_rule_table(Graphics g,int offsetx,int offsety,int w,int h) {
    
    int w3 = cellautoapp.cellauto131.tablewidth;
    int h3 = cellautoapp.cellauto131.tableheight;
    
    
    if (cellautoapp.digits_image == null) {
      if (show_numbers == 1) {
        cellautoapp.load_digits_image();
      }
    }
    //draw the rule table
    for (int y = 0;y < h;y++){
      for (int x = 0;x < w;x++){
        if ((x+offsetx) < cellautoapp.cellauto131.tablewidth){
          if ((y+offsety) < cellautoapp.cellauto131.tableheight){
            int i = cellautoapp.cellauto131.getlookuptable(x+offsetx,y+offsety);
            g.setColor(cellautoapp.cellauto131.getcellvaluecolor(i));
            g.fillRect(x*sqsize,y*sqsize,sqsize,sqsize);
            if (cellautoapp.cellauto131.lookuptableallused == false){
              int a3 = cellautoapp.cellauto131.getlookuptableused(x+offsetx,y+offsety);
              //if (a3 == 0){
                paintsmallsquare(g,x,y,i,Color.black,Color.white,a3);
              //}
            }
          }
        }
      }
    }
    //g.drawImage(cellautoapp.digits_image,64,32,64+8,32+16,0,0,8,16,null);
    int w2 = w;
    int h2 = h;
    
    if (w2 >= (cellautoapp.cellauto131.tablewidth-offsetx)){
      w2 = cellautoapp.cellauto131.tablewidth-offsetx;
      
    }
    if (h2 >= (cellautoapp.cellauto131.tableheight-offsety)){
      h2 = cellautoapp.cellauto131.tableheight-offsety;    
    }
    if (show_colors == 1) {
      if (w2 >= (cellautoapp.cellauto131.tablewidth-offsetx)){
        g.setColor(Color.black);
        g.fillRect(w2*sqsize,0,sqsize,h2*sqsize);
        for (int y = 0;y < h2;y++){
          int y2 = y + offsety;
          g.setColor(cellautoapp.cellauto131.getcellvaluecolor(y2));
          g.fillRect((w2*sqsize)+(sqsize >> 2),(y*sqsize)+(sqsize >> 2),sqsize >> 1,sqsize >> 1);
          
        }
        w2 = w2 + 1;       
      }
    }
    Image neighborhood_image = null;
    if (cellautoapp.cellauto131.rulefamily != null) {    
      neighborhood_image = cellautoapp.cellauto131.rulefamily.get_neighborhood_image();
    }
    if (neighborhood_image != null) {
      if (h2 >= (cellautoapp.cellauto131.tableheight-offsety)){
        g.drawImage(neighborhood_image,-offsetx*sqsize,(h2*sqsize),null);
        h2 = h2 + 1;
      }
    } else if (show_numbers == 1) {
      if (h2 >= (cellautoapp.cellauto131.tableheight-offsety)){
        g.setColor(Color.black);
        g.fillRect(0,h2*sqsize,w2*sqsize,sqsize);
        for (int x = 0;x < (w2-show_colors);x++){
          int x2 = x + offsetx;
          if (x2 < 100) {
            if (x2 >= 10) {
              g.drawImage(cellautoapp.digits_image,(x*sqsize)+1,(h2*sqsize),(x*sqsize)+1+8,(h2*sqsize)+16,((x2/10)*8),0,((x2/10)*8)+8,16,null);
            }
            g.drawImage(cellautoapp.digits_image,(x*sqsize)+8,(h2*sqsize),(x*sqsize)+8+8,(h2*sqsize)+16,((x2%10)*8),0,((x2%10)*8)+8,16,null);
          }
        }
        h2 = h2 + 1;
      }
    }
    
    //draw the grid
    for (int x = 1;x <= w2;x++){
      g.setColor(gridcolor1);
      if (((x+offsetx) % grid_x_spacing) == 0){g.setColor(gridcolor2);}
      if (((x+offsetx) % grid_x_spacing2) == 0){g.setColor(gridcolor3);}
      g.drawLine(x*sqsize,0,x*sqsize,h2*sqsize);
    }
    for (int y = 1;y <= h2;y++){
      g.setColor(gridcolor1);
      if (((y+offsety) % grid_y_spacing) == 0){g.setColor(gridcolor2);}
      if (((y+offsety) % grid_y_spacing2) == 0){g.setColor(gridcolor3);}
      g.drawLine(0,y*sqsize,w2*sqsize,y*sqsize);
    }
    
  }  
  
  
};

class neighborhoodvaluespanelc extends JPanel {
  JTextField edit[][];
  neighborhoodvaluespanelc(int size) {
    GridLayout gl = new GridLayout(size,size);
    this.setLayout(gl);
    edit = new JTextField[size][size];
    for (int x = 0;x < size;x++) {
      for (int y = 0;y < size;y++) {
        edit[x][y] = new JTextField("0");
        this.add(edit[x][y]);
      }
    }
  }
}

class neighborhoodvaluesdialogc extends JFrame {
  neighborhoodvaluespanelc neighborhoodvaluespanel;
  JButton okbutton;
  JButton cancelbutton;
  int size;
  neighborhoodvaluesdialogc(String Title,int size) {
    super(Title);
    this.size = size;
    SpringLayout spl = new SpringLayout();  
    this.getContentPane().setLayout(spl);
    neighborhoodvaluespanel = new neighborhoodvaluespanelc(size);


    this.getContentPane().add(neighborhoodvaluespanel);
    
    okbutton = new JButton("apply");
    okbutton.setActionCommand("neighborhoodvalues_applybuttonclick");
    okbutton.addActionListener(cellautoapp.actlis);
    this.getContentPane().add(okbutton);
    cancelbutton = new JButton("close");
    cancelbutton.setActionCommand("neighborhoodvalues_closebuttonclick");
    cancelbutton.addActionListener(cellautoapp.actlis);
    this.getContentPane().add(cancelbutton);
    spl.putConstraint(SpringLayout.WEST,cancelbutton,0,SpringLayout.EAST,okbutton);
    spl.putConstraint(SpringLayout.WEST,okbutton,0,SpringLayout.WEST,this.getContentPane());
    spl.putConstraint(SpringLayout.SOUTH,okbutton,0,SpringLayout.SOUTH,this.getContentPane());
    spl.putConstraint(SpringLayout.SOUTH,cancelbutton,0,SpringLayout.SOUTH,this.getContentPane());
    spl.putConstraint(SpringLayout.EAST,neighborhoodvaluespanel,0,SpringLayout.EAST,this.getContentPane());
    spl.putConstraint(SpringLayout.WEST,neighborhoodvaluespanel,0,SpringLayout.WEST,this.getContentPane());

    spl.putConstraint(SpringLayout.SOUTH,neighborhoodvaluespanel,0,SpringLayout.NORTH,okbutton);
    spl.putConstraint(SpringLayout.NORTH,neighborhoodvaluespanel,0,SpringLayout.NORTH,this.getContentPane());

    this.pack();
  }


  //getbordervalues displays the neighbor weights
  void getbordervalues() {
    int size2 = (size - 1) / 2;
    for (int x = 0;x < size;x++) {
      for (int y = 0;y < size;y++) {
        neighborhoodvaluespanel.edit[x][y].setText(Integer.toString(cellautoapp.cellauto131.getbordervalue(x-size2,y-size2)));
      }
    }
  }

  //updatebordervalues updates the neighbor weights
  void updatebordervalues() {
    int size2 = (size - 1) / 2;
    for (int x = 0;x < size;x++) {
      for (int y = 0;y < size;y++) {
        int i = Integer.parseInt(neighborhoodvaluespanel.edit[x][y].getText().trim());
        cellautoapp.cellauto131.setbordervalue(x-size2,y-size2,i);
      }
    }
  }

}

class randomize_rule_table_dialogc extends JFrame{
  JLabel seedlabel;
  JTextField seededit;
  JButton new_seed_button;
  JLabel from_row_label;
  JTextField from_row_edit;
  JLabel to_row_label;
  JTextField to_row_edit;
  JLabel from_state_label;
  JTextField from_state_edit;
  JLabel to_state_label;
  JTextField to_state_edit;
  
  JButton randomize_button;
  JButton close_button;
  
  randomize_rule_table_dialogc(String Title) {
    super(Title);
    GridBagLayout gl = new GridBagLayout();
    this.getContentPane().setLayout(gl);
    GridBagConstraints c = new GridBagConstraints();

    c.fill = GridBagConstraints.BOTH;
    c.weightx = 1.0;
    c.weighty = 1.0;

    seedlabel = new JLabel("seed: ");
    c.gridwidth = 2;
    gl.setConstraints(seedlabel, c);
    this.getContentPane().add(seedlabel);

    seededit = new JTextField("8");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(seededit, c);
    this.getContentPane().add(seededit);

    new_seed_button = new JButton("new seed");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(new_seed_button, c);
    new_seed_button.setActionCommand("rule_table_new_seed_buttonclick");
    new_seed_button.addActionListener(cellautoapp.actlis);
    this.getContentPane().add(new_seed_button);

    from_row_label = new JLabel("from row: ");
    c.gridwidth = 2;
    gl.setConstraints(from_row_label, c);
    this.getContentPane().add(from_row_label);

    from_row_edit = new JTextField("0");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(from_row_edit, c);
    this.getContentPane().add(from_row_edit);

    to_row_label = new JLabel("to row: ");
    c.gridwidth = 2;
    gl.setConstraints(to_row_label, c);
    this.getContentPane().add(to_row_label);

    to_row_edit = new JTextField(Integer.toString(cellautoapp.cellauto131.numcolors-1));
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(to_row_edit, c);
    this.getContentPane().add(to_row_edit);


    from_state_label = new JLabel("from state: ");
    c.gridwidth = 2;
    gl.setConstraints(from_state_label, c);
    this.getContentPane().add(from_state_label);

    from_state_edit = new JTextField("0");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(from_state_edit, c);
    this.getContentPane().add(from_state_edit);

    to_state_label = new JLabel("to state: ");
    c.gridwidth = 2;
    gl.setConstraints(to_state_label, c);
    this.getContentPane().add(to_state_label);

    to_state_edit = new JTextField(Integer.toString(cellautoapp.cellauto131.numcolors-1));
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(to_state_edit, c);
    this.getContentPane().add(to_state_edit);

    
    randomize_button = new JButton("randomize");
    c.gridwidth = 2;
    gl.setConstraints(randomize_button, c);
    randomize_button.setActionCommand("rule_table_randomize_buttonclick");
    randomize_button.addActionListener(cellautoapp.actlis);
    this.getContentPane().add(randomize_button);

    close_button = new JButton("close");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(close_button, c);
    close_button.setActionCommand("rule_table_close_buttonclick");
    close_button.addActionListener(cellautoapp.actlis);
    this.getContentPane().add(close_button);

    long seed = ((System.currentTimeMillis() % 10000));
    seededit.setText(Long.toString(seed));

    this.pack();
  }
  void update_dialog() {
    int i = cellautoapp.cellauto131.getnumcolors();
    cellautoapp.randomize_rule_table_dialog.to_row_edit.setText(Integer.toString(i));
    cellautoapp.randomize_rule_table_dialog.to_state_edit.setText(Integer.toString(i));
  }
  void randomize_buttonclick(){
    long seed = Long.valueOf(seededit.getText()).longValue();
    int from_row = Integer.parseInt(from_row_edit.getText());
    int to_row = Integer.parseInt(to_row_edit.getText());
    int from_state = Integer.parseInt(from_state_edit.getText());
    int to_state = Integer.parseInt(to_state_edit.getText());
    seededit.setText(Long.toString(seed+1));
    cellautoapp.rand.setSeed(seed);
    cellautoapp.randomizeruletable(from_row,to_row,from_state,to_state);
    System.out.println("randomize rule table");
    cellautoapp.edittablewindow.repaint();
  }
  void new_seed_buttonclick(){
    long seed = System.currentTimeMillis();
    seededit.setText(Long.toString(seed));
    System.out.println("randomize rule table");
  }

}
class addmanystatesdialogc extends JFrame{
  JLabel numstateslabel;
  JTextField numstatesedit;
  JLabel coloroffsetlabel;
  JTextField coloroffsetedit;
  JLabel colorsteplabel;
  JTextField colorstepedit;
  JButton addbutton;
  JButton closebutton;
  addmanystatesdialogc(String Title) {
    super(Title);
    GridBagLayout gl = new GridBagLayout();
    this.getContentPane().setLayout(gl);
    GridBagConstraints c = new GridBagConstraints();

    c.fill = GridBagConstraints.BOTH;
    c.weightx = 1.0;
    c.weighty = 1.0;

    numstateslabel = new JLabel("number of states to add: ");
    c.gridwidth = 2;
    gl.setConstraints(numstateslabel, c);
    this.getContentPane().add(numstateslabel);

    numstatesedit = new JTextField("8");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(numstatesedit, c);
    this.getContentPane().add(numstatesedit);

    coloroffsetlabel = new JLabel("color offset: ");
    c.gridwidth = 2;
    gl.setConstraints(coloroffsetlabel, c);
    this.getContentPane().add(coloroffsetlabel);

    coloroffsetedit = new JTextField("512");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(coloroffsetedit, c);
    this.getContentPane().add(coloroffsetedit);

    colorsteplabel = new JLabel("color step: ");
    c.gridwidth = 2;
    gl.setConstraints(colorsteplabel, c);
    this.getContentPane().add(colorsteplabel);

    colorstepedit = new JTextField("-6");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(colorstepedit, c);
    this.getContentPane().add(colorstepedit);

    addbutton = new JButton("add");
    c.gridwidth = 2;
    gl.setConstraints(addbutton, c);
    addbutton.setActionCommand("manystatesaddbuttonclick");
    addbutton.addActionListener(cellautoapp.actlis);
    this.getContentPane().add(addbutton);

    closebutton = new JButton("close");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(closebutton, c);
    closebutton.setActionCommand("manystatesclosebuttonclick");
    closebutton.addActionListener(cellautoapp.actlis);
    this.getContentPane().add(closebutton);
  }

  //this function adds a bunch of states
  void addstates() {
    //System.out.println("addstates");
    double color_step = Double.valueOf(colorstepedit.getText()).doubleValue();
    double color_offset = Double.valueOf(coloroffsetedit.getText()).doubleValue();
    int num_colors = Integer.valueOf(numstatesedit.getText()).intValue();;
    for (int i = 0;i < num_colors;i++) {
      int i2 = cellautoapp.cellauto131.addnewstate();
      if (i2 == -1) {
        JOptionPane.showMessageDialog(cellautoapp.cellautowindowframe,new JLabel("can not add more states, the limit is 256 states "),"error",JOptionPane.ERROR_MESSAGE);  
        break;
      }
      Color c = cellautoapp.getcolorfromhue(color_offset + (i2*color_step));
      cellautoapp.cellauto131.cellvalue[i2] = 0;
      cellautoapp.cellauto131.cellvaluecolor[i2] = c;
      for (int i3 = 0;i3 < cellautoapp.cellauto131.tablewidth;i3++) {
        int i4 = cellautoapp.cellauto131.getlookuptable(i3,cellautoapp.cellauto131.tableheight-2);
        if (i4 == 0){
          cellautoapp.cellauto131.setlookuptable(i3,cellautoapp.cellauto131.tableheight-2,cellautoapp.cellauto131.tableheight-1);
        }
      }
    }
    if (cellautoapp.randomize_rule_table_dialog != null) {
      cellautoapp.randomize_rule_table_dialog.update_dialog();
    }
    cellautoapp.updatestatusbar();
    cellautoapp.colorbox.colorboxpanel.repaint();
    cellautoapp.edittablewindow.edittablepanel.repaint();  
    cellautoapp.cellautomainwindow.repaint();
    cellautoapp.edittablewindow.vscroll.setMaximum(cellautoapp.cellauto131.tableheight-2);
  }
}


class addeditstatedialogc extends JFrame {
  JLabel statevaluelabel;
  JTextField statevalueedit;
  JLabel statecolorlabel;
  JButton statecolorbutton;
  JButton okbutton;
  JButton cancelbutton;
  //String combobox_strings[] = {"0","1","2","3"};
  //this function updates the state's color and value
  void update(){
    int i = cellautoapp.colorlistindex;
    cellautoapp.cellauto131.cellvalue[i] = Integer.parseInt(statevalueedit.getText().trim());
    cellautoapp.cellauto131.cellvaluecolor[i] = statecolorbutton.getBackground();
    cellautoapp.updatestatusbar();
    cellautoapp.colorbox.colorboxpanel.repaint();
    cellautoapp.edittablewindow.edittablepanel.repaint();  
    cellautoapp.cellautomainwindow.repaint();
  }
  
  //this function adds a new state
  void addstate() {
    int i = cellautoapp.cellauto131.addnewstate();
    if (i == -1) {
      JOptionPane.showMessageDialog(cellautoapp.cellautowindowframe,new JLabel("can not add more states, the limit is 256 states "),"error",JOptionPane.ERROR_MESSAGE);  
      return;
    }
    cellautoapp.colorlistindex = i;
    cellautoapp.colorbox.colorboxpanel.selcolor = cellautoapp.colorlistindex;
    cellautoapp.edittablewindow.vscroll.setMaximum(cellautoapp.cellauto131.tableheight-2);
    this.setVisible(true);
    this.selectstate(cellautoapp.colorlistindex);
    if (cellautoapp.randomize_rule_table_dialog != null) {
      cellautoapp.randomize_rule_table_dialog.update_dialog();
    }
    cellautoapp.updatestatusbar();
    cellautoapp.colorbox.colorboxpanel.repaint();
    cellautoapp.edittablewindow.edittablepanel.repaint();  
    cellautoapp.cellautomainwindow.repaint();
  }

  //this function selects a state
  void selectstate(int i){
    if (cellautoapp.verbose == true){
      System.out.println("select state " + i);
    }
    statevaluelabel.setText("state " + i + " value");
    statevalueedit.setText(Integer.toString(cellautoapp.cellauto131.cellvalue[i]));
    statecolorlabel.setText("state " + i + " color");
    statecolorbutton.setBackground(cellautoapp.cellauto131.cellvaluecolor[i]);
  }

  //this function selects the state's color
  void selectcolor(){
    Color c = JColorChooser.showDialog(this,"state color",statecolorbutton.getBackground());
    if (c != null){
      statecolorbutton.setBackground(c);
    }
  }
  addeditstatedialogc(String Title){
    super(Title);
    GridBagLayout gl = new GridBagLayout();
    this.getContentPane().setLayout(gl);
    GridBagConstraints c = new GridBagConstraints();

    c.fill = GridBagConstraints.BOTH;
    c.weightx = 1.0;
    c.weighty = 1.0;

    statevaluelabel = new JLabel();
    statevaluelabel.setText("state 0 value");
    c.gridwidth = 2;
    gl.setConstraints(statevaluelabel, c);
    this.getContentPane().add(statevaluelabel);
    
    statevalueedit = new JTextField();
    statevalueedit.setText("0");
    //statevalueedit.setEditable(true);
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(statevalueedit, c);
    this.getContentPane().add(statevalueedit);


    statecolorlabel = new JLabel();
    statecolorlabel.setText("state 0 color");
    c.gridwidth = 2;
    gl.setConstraints(statecolorlabel, c);
    this.getContentPane().add(statecolorlabel);
    
    statecolorbutton = new JButton();
    statecolorbutton.setText("");
    statecolorbutton.setBackground(new Color(0,255,0));
    statecolorbutton.setActionCommand("statecolorbuttonclick");
    statecolorbutton.addActionListener(cellautoapp.actlis);

    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(statecolorbutton, c);
    this.getContentPane().add(statecolorbutton);
    
    
    okbutton = new JButton();
    okbutton.setText("update");
    okbutton.setActionCommand("stateupdatebuttonclick");
    okbutton.addActionListener(cellautoapp.actlis);
    c.gridwidth = 2;
    gl.setConstraints(okbutton, c);
    this.getContentPane().add(okbutton);

    cancelbutton = new JButton();
    cancelbutton.setText("close");
    cancelbutton.setActionCommand("stateclosebuttonclick");
    cancelbutton.addActionListener(cellautoapp.actlis);
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(cancelbutton, c);
    this.getContentPane().add(cancelbutton);

    this.pack();
    
  }
}


class optionsdialogc extends JFrame {
  JCheckBox showgridcheckbox;
  JCheckBox transparentselectioncheckbox;
  JCheckBox selectionsavexycheckbox;
  JCheckBox dropselectioncheckbox;
  JCheckBox saveandclearcheckbox;
  JLabel timesteplabel;
  JTextField timestepedit;
  JLabel timestep2label;
  JTextField timestep2edit;

  JLabel sparsenesslabel;
  JTextField sparsenessedit;
  JCheckBox sparsenesscheckbox;

  JLabel simulator_delay_label;
  JTextField simulator_delay_edit;

  JLabel frames_per_second_label;
  JTextField frames_per_second_edit;

  //JCheckBox repaint_every_generation_checkbox;
  //JCheckBox enable_file_compression_checkbox;
  
  JCheckBox wrapxcheckbox;
  JCheckBox wrapycheckbox;
  JCheckBox unused_entries_checkbox;
  
  JButton okbutton;
  JButton cancelbutton;
  optionsdialogc(String Title) {
    super(Title);
    GridBagLayout gl = new GridBagLayout();
    this.getContentPane().setLayout(gl);
    GridBagConstraints c = new GridBagConstraints();

    c.fill = GridBagConstraints.BOTH;
    c.weightx = 1.0;
    c.weighty = 1.0;

    showgridcheckbox = new JCheckBox();
    showgridcheckbox.setText("show grid");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(showgridcheckbox, c);
    this.getContentPane().add(showgridcheckbox);
    


    transparentselectioncheckbox = new JCheckBox();
    transparentselectioncheckbox.setText("selection is transparent");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(transparentselectioncheckbox, c);
    this.getContentPane().add(transparentselectioncheckbox);
    
    selectionsavexycheckbox = new JCheckBox();
    selectionsavexycheckbox.setText("save x and y offsets of selection");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(selectionsavexycheckbox, c);
    this.getContentPane().add(selectionsavexycheckbox);

    dropselectioncheckbox = new JCheckBox();
    dropselectioncheckbox.setText("drop selection before running ctrl-" + cellautokeys.seletionoption_ctrl_key.toLowerCase());
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(dropselectioncheckbox, c);
    this.getContentPane().add(dropselectioncheckbox);

    
    saveandclearcheckbox = new JCheckBox();
    saveandclearcheckbox.setText("save_and_clear_key adds random cells");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(saveandclearcheckbox, c);
    this.getContentPane().add(saveandclearcheckbox);
    
    wrapxcheckbox = new JCheckBox();
    wrapxcheckbox.setText("warp x edges");
    c.gridwidth = 2;
    gl.setConstraints(wrapxcheckbox, c);
    this.getContentPane().add(wrapxcheckbox);

    wrapycheckbox = new JCheckBox();
    wrapycheckbox.setText("warp y edges");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(wrapycheckbox, c);
    this.getContentPane().add(wrapycheckbox);
        
    timesteplabel = new JLabel();
    timesteplabel.setText("generation step");
    c.gridwidth = 2;
    gl.setConstraints(timesteplabel, c);
    this.getContentPane().add(timesteplabel);
    
    timestepedit = new JTextField();
    timestepedit.setText("1");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(timestepedit, c);
    this.getContentPane().add(timestepedit);

    timestep2label = new JLabel();
    timestep2label.setText("generation step 2");
    c.gridwidth = 2;
    gl.setConstraints(timestep2label, c);
    this.getContentPane().add(timestep2label);
    
    timestep2edit = new JTextField();
    timestep2edit.setText("1");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(timestep2edit, c);
    this.getContentPane().add(timestep2edit);
 

    sparsenesslabel = new JLabel();
    sparsenesslabel.setText("random rule table sparseness percent 0..100");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(sparsenesslabel, c);
    this.getContentPane().add(sparsenesslabel);
  
    sparsenessedit = new JTextField();
    sparsenessedit.setText("0");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(sparsenessedit, c);
    this.getContentPane().add(sparsenessedit);
    
    sparsenesscheckbox = new JCheckBox();
    sparsenesscheckbox.setText("clear rule table first");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(sparsenesscheckbox, c);
    this.getContentPane().add(sparsenesscheckbox);

    unused_entries_checkbox = new JCheckBox();
    unused_entries_checkbox.setText("randomize only unused table entries");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(unused_entries_checkbox, c);
    this.getContentPane().add(unused_entries_checkbox);


    simulator_delay_label = new JLabel();
    simulator_delay_label.setText("simulator delay");
    c.gridwidth = 2;
    gl.setConstraints(simulator_delay_label, c);
    this.getContentPane().add(simulator_delay_label);
  
    simulator_delay_edit = new JTextField();
    simulator_delay_edit.setText("0");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(simulator_delay_edit, c);
    this.getContentPane().add(simulator_delay_edit);

    frames_per_second_label = new JLabel();
    frames_per_second_label.setText("frames per second");
    c.gridwidth = 2;
    gl.setConstraints(frames_per_second_label, c);
    this.getContentPane().add(frames_per_second_label);
  
    frames_per_second_edit = new JTextField();
    frames_per_second_edit.setText("0");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(frames_per_second_edit, c);
    this.getContentPane().add(frames_per_second_edit);
    
    //enable_file_compression_checkbox = new JCheckBox();
    //enable_file_compression_checkbox.setText("enable file compression");
    //c.gridwidth = GridBagConstraints.REMAINDER;
    //gl.setConstraints(enable_file_compression_checkbox, c);
    //this.getContentPane().add(enable_file_compression_checkbox);


    //repaint_every_generation_checkbox = new JCheckBox();
    //repaint_every_generation_checkbox.setText("repaint every generation");
    //c.gridwidth = GridBagConstraints.REMAINDER;
    //gl.setConstraints(repaint_every_generation_checkbox, c);
    //this.getContentPane().add(repaint_every_generation_checkbox);
    


    okbutton = new JButton();
    okbutton.setText("ok");
    okbutton.setActionCommand("optionsokbuttonclick");
    okbutton.addActionListener(cellautoapp.actlis);
    c.gridwidth = 2;
    gl.setConstraints(okbutton, c);
    this.getContentPane().add(okbutton);

    cancelbutton = new JButton();
    cancelbutton.setText("cancel");
    cancelbutton.setActionCommand("optionscancelbuttonclick");
    cancelbutton.addActionListener(cellautoapp.actlis);
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(cancelbutton, c);
    this.getContentPane().add(cancelbutton);

    this.pack();
  }
  //this function displays the options
  void getoptions(){
    unused_entries_checkbox.setSelected(cellautoapp.randomize_only_unused_entries);
    wrapxcheckbox.setSelected(cellautoapp.board.wrapx);
    wrapycheckbox.setSelected(cellautoapp.board.wrapy);
    showgridcheckbox.setSelected(cellautoapp.gridon);
    transparentselectioncheckbox.setSelected(cellautoapp.transparentselection);
    selectionsavexycheckbox.setSelected(cellautoapp.selectionsavexy);
    dropselectioncheckbox.setSelected(cellautoapp.dropselectionbeforerunning);
    saveandclearcheckbox.setSelected(cellautoapp.save_and_clear_key_adds_random_cells);
    timestepedit.setText(Integer.toString(cellautoapp.timestep));
    timestep2edit.setText(Integer.toString(cellautoapp.timestep2));
    simulator_delay_edit.setText(Integer.toString(cellautoapp.simulator_delay));
    frames_per_second_edit.setText(Double.toString(cellautoapp.frames_per_second));
    if (cellautoapp.random_rule_table_sparseness > 0.0) {
      if (cellautoapp.random_rule_table_sparseness < 100.0) {
        sparsenessedit.setText(Double.toString(cellautoapp.random_rule_table_sparseness));
      } else {
        sparsenessedit.setText("100");
      }
    } else {
      sparsenessedit.setText("0");
    }
    sparsenesscheckbox.setSelected(cellautoapp.random_rule_table_clear);
    //enable_file_compression_checkbox.setSelected(cellautoapp.enable_file_compression);
    //repaint_every_generation_checkbox.setSelected(cellautoapp.repaint_every_generation);
  }
  //this function updates the options
  void updateoptions(){
    cellautoapp.randomize_only_unused_entries = unused_entries_checkbox.isSelected();
    cellautoapp.random_rule_table_sparseness = Double.valueOf(sparsenessedit.getText().trim()).doubleValue();
    cellautoapp.timestep = Integer.parseInt(timestepedit.getText().trim());
    cellautoapp.timestep2 = Integer.parseInt(timestep2edit.getText().trim());
    cellautoapp.board.wrapx = wrapxcheckbox.isSelected();
    cellautoapp.board.wrapy = wrapycheckbox.isSelected();
    cellautoapp.board2.wrapx = cellautoapp.board.wrapx;
    cellautoapp.board2.wrapy = cellautoapp.board.wrapy;
    cellautoapp.gridon = showgridcheckbox.isSelected();
    cellautoapp.transparentselection = transparentselectioncheckbox.isSelected();
    cellautoapp.selectionsavexy = selectionsavexycheckbox.isSelected();
    cellautoapp.dropselectionbeforerunning = dropselectioncheckbox.isSelected();
    cellautoapp.save_and_clear_key_adds_random_cells = saveandclearcheckbox.isSelected();
    cellautoapp.random_rule_table_clear = sparsenesscheckbox.isSelected();
    cellautoapp.simulator_delay = Integer.parseInt(simulator_delay_edit.getText().trim());
    cellautoapp.frames_per_second = Double.parseDouble(frames_per_second_edit.getText().trim());    
    //cellautoapp.enable_file_compression = enable_file_compression_checkbox.isSelected();
    //cellautoapp.repaint_every_generation = repaint_every_generation_checkbox.isSelected();
  }
}
class genewindowc extends JFrame{
  int numgenes;
  int genewidth;
  int geneheight;
  
  byte ruletablegene[][][];
  byte is_gene_parent[];
  int selgene;
  

  JLabel statuslabel;
  JLabel numgeneslabel;
  JTextField numgenesedit;
  
  JLabel nummutationslabel;
  JTextField nummutationsedit;

  JButton newbutton;
  JButton openbutton;
  JButton savebutton;
  JButton keepbutton;
  JButton replacebutton;
  
  //JPanel panel1;
  //JPanel panel2;
  //JPanel panel3;
  //JPanel panel4;
  //JPanel panel5;
  genewindowc(String Title){
    super(Title);
    
    GridBagLayout gl = new GridBagLayout();
    this.getContentPane().setLayout(gl);
    GridBagConstraints c = new GridBagConstraints();

    c.fill = GridBagConstraints.BOTH;
    c.weightx = 1.0;
    c.weighty = 1.0;
    


    //panel1 = new JPanel();
    //GridLayout gl2 = new GridLayout(1,2);
    //panel1.setLayout(gl2);
    numgeneslabel = new JLabel("number of genes:");
    c.gridwidth = 2;
    gl.setConstraints(numgeneslabel, c);
    this.getContentPane().add(numgeneslabel);
    
    numgenesedit = new JTextField("8");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(numgenesedit, c);
    this.getContentPane().add(numgenesedit);
    //this.getContentPane().add(panel1);

    nummutationslabel = new JLabel("mutations per gene:");
    c.gridwidth = 2;
    gl.setConstraints(nummutationslabel, c);
    this.getContentPane().add(nummutationslabel);
    
    nummutationsedit = new JTextField("0");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(nummutationsedit, c);
    this.getContentPane().add(nummutationsedit);
    
    
    //panel2 = new JPanel();
    newbutton = new JButton("new random genes");
    //panel2.add(newbutton);
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(newbutton, c);
    this.getContentPane().add(newbutton);
    newbutton.setActionCommand("genenewbuttonclick");
    newbutton.addActionListener(cellautoapp.actlis);


    //panel3 = new JPanel();
    openbutton = new JButton("open");
    c.gridwidth = 2;
    gl.setConstraints(openbutton, c);
    this.getContentPane().add(openbutton);
    
    savebutton = new JButton("save");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(savebutton, c);
    this.getContentPane().add(savebutton);
    
    openbutton.setActionCommand("geneopenbuttonclick");
    openbutton.addActionListener(cellautoapp.actlis);

    savebutton.setActionCommand("genesavebuttonclick");
    savebutton.addActionListener(cellautoapp.actlis);
    
    
    //panel4 = new JPanel();
    keepbutton = new JButton("keep");
    c.gridwidth = 2;
    gl.setConstraints(keepbutton, c);
    this.getContentPane().add(keepbutton);
    
    replacebutton = new JButton("replace");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(replacebutton, c);
    this.getContentPane().add(replacebutton);
    
    keepbutton.setActionCommand("genekeepbuttonclick");
    keepbutton.addActionListener(cellautoapp.actlis);

    replacebutton.setActionCommand("genereplacebuttonclick");
    replacebutton.addActionListener(cellautoapp.actlis);

    //panel5 = new JPanel();
    numgeneslabel = new JLabel("selected gene: 0 genes: 0");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(numgeneslabel, c);    
    this.getContentPane().add(numgeneslabel);
    

    
    this.pack();
  }
  void updatestatuslabel(){
    numgeneslabel.setText("selected gene: " + selgene + "genes: " + numgenes);
  }


  void newrandomgenes2(){
    int numgenes = Integer.parseInt(numgenesedit.getText().trim());
    
    String str = JOptionPane.showInputDialog("what percentage of gene entries are random?","20.0");
    try {   
      double p = Double.parseDouble(str);
      newrandomgenes(p,numgenes);
      updatestatuslabel();
    } catch (NumberFormatException e) {
      JOptionPane.showMessageDialog(this,new JLabel("invalid number"),"error",JOptionPane.ERROR_MESSAGE);
    } 
  }
  void newrandomgenes(double p,int nr){
    numgenes = nr;
    int w = cellautoapp.cellauto131.tablewidth;
    int h = cellautoapp.cellauto131.tableheight;
    ruletablegene = new byte[nr][w][h];
    is_gene_parent = new byte[nr];
    genewidth = w;
    geneheight = h;
    int numcolors = cellautoapp.cellauto131.numcolors;
    for (int r = 0;r < nr;r++){
      for (int x = 0;x < w;x++){
        for (int y = 0;y < h;y++){
          double p2 = cellautoapp.rand.nextDouble() * 100.0;
          int a = cellautoapp.cellauto131.getlookuptable(x,y);
          if (p >= p2) {
            a = cellautoapp.rand.nextInt(numcolors);
          }
          ruletablegene[r][x][y] = (byte) a; 
        }
      }
      ruletablegene[r][0][0] = 0;
      is_gene_parent[r] = 0;
    }
    selgene = 0;
    updateruletable();
  }
  int get_random_parent() {
    int parent_g = 0;
    for (int i = 0;i < 4;i++) {
      parent_g = cellautoapp.rand.nextInt(numgenes);
      if (is_gene_parent[parent_g] == 1) {break;}
    }    
    return parent_g;
  }
  void replacegene(){
    int parent1 = get_random_parent();
    int parent2 = get_random_parent();
    int num_mutations = Integer.parseInt(nummutationsedit.getText().trim());
    int numcolors = cellautoapp.cellauto131.numcolors;
    for (int x = 0;x < genewidth;x++){
      for (int y = 0;y < geneheight;y++){
        int a = cellautoapp.rand.nextInt(2);
        if (a == 0){
          ruletablegene[selgene][x][y] = ruletablegene[parent1][x][y];
        }
        if (a == 1){
          ruletablegene[selgene][x][y] = ruletablegene[parent2][x][y];
        }
      }
    }
    for (int i = 0;i < num_mutations;i++) {
      int x = cellautoapp.rand.nextInt(genewidth);
      int y = cellautoapp.rand.nextInt(geneheight);      
      int s = cellautoapp.rand.nextInt(numcolors);
      ruletablegene[selgene][x][y] = (byte) s;
    }
    ruletablegene[selgene][0][0] = 0;
    is_gene_parent[selgene] = 0;
    selgene = ((selgene + 1) % numgenes);
  }
  void replacegenebuttonclick(){
    saveruletable();
    replacegene();
    updateruletable();
    cellautoapp.newgamedialog.newgame();
    cellautoapp.run();    
    updatestatuslabel();
  }
  void keepgenebuttonclick(){
    saveruletable();
    is_gene_parent[selgene] = 1;
    selgene = ((selgene + 1) % numgenes);
    updateruletable();
    cellautoapp.newgamedialog.newgame();
    cellautoapp.run();    
    updatestatuslabel();
  }
  void saveruletable(){
    int w = genewidth;
    int h = geneheight;
    int e = 0;
    if (w != cellautoapp.cellauto131.tablewidth){e = 1;}
    if (h != cellautoapp.cellauto131.tableheight){e = 1;}
    if (e == 1){
      //JOptionPane.showMessageDialog(cellautoapp.cellautowindowframe,new JLabel("gene size is not equal to rule table size"),"error",JOptionPane.ERROR_MESSAGE);      
      System.out.println("gene size is not equal to rule table size");
      System.out.println(w + "," + h + "," + cellautoapp.cellauto131.tablewidth + "," + cellautoapp.cellauto131.tableheight);
      return;
    }
    for (int x = 0;x < w;x++){
      for (int y = 0;y < h;y++){
        int a = cellautoapp.cellauto131.getlookuptable(x,y);
        ruletablegene[selgene][x][y] = (byte) a;
      }
    }
    //cellautoapp.edittablewindow.repaint();
    
  }
  void updateruletable(){
    int w = genewidth;
    int h = geneheight;
    int e = 0;
    if (w != cellautoapp.cellauto131.tablewidth){e = 1;}
    if (h != cellautoapp.cellauto131.tableheight){e = 1;}
    if (e == 1){
      //JOptionPane.showMessageDialog(cellautoapp.cellautowindowframe,new JLabel("gene size is not equal to rule table size"),"error",JOptionPane.ERROR_MESSAGE);      
      System.out.println("gene size is not equal to rule table size");
      return;
    }
    for (int x = 0;x < w;x++){
      for (int y = 0;y < h;y++){
        int a = ruletablegene[selgene][x][y];
        cellautoapp.cellauto131.setlookuptable(x,y,a);
      }
    }
    cellautoapp.edittablewindow.repaint();
  }
}

class cellautothreadc extends Thread {
  public boolean running = false;
  public boolean done = false;
  public int numgenerations = 0;
  public boolean repaint_every_generation = true;
  public long delay = 1000;
  
  static boolean undoevent = false;
  cellautothreadc(int n,boolean b,long d) {
    numgenerations = n;
    repaint_every_generation = b;
    delay = d;
    done = false;
    running = false;
  }
  public void run() {
    while (true) {
      try {
        if (numgenerations > 0) {
          //numgenerations = numgenerations - 10; 
          if (running == false) {
            cellautoapp.run2();
            running = true;
          }
          boolean b = repaint_every_generation;
          if ((numgenerations & 63) == 0) {b = true;}
          cellautoapp.redodata.clear();
          long time3 = System.currentTimeMillis();          
          while (numgenerations > 0) {
            long time1 = System.currentTimeMillis();          
            cellautoapp.calc1();
            numgenerations--;          
          //cellautoapp.calc(10,true);
            long time2 = System.currentTimeMillis();
            long sleep_time = delay - (time2 - time1);
            if (sleep_time < 1) {sleep_time = 1;}
            sleep(sleep_time);
            time2 = System.currentTimeMillis();
            long frame_time = (long) (1000.0 / cellautoapp.frames_per_second);
            if ((time2 - time3) > frame_time) {break;}
          }
          cellautoapp.cellautomainwindow.repaint();
          cellautoapp.updatestatusbar();
          if (cellautoapp.cellauto131.lookuptableallused == false) {
            cellautoapp.edittablewindow.repaint();
          }          
        } else {
          if (running == true) {
            if (undoevent == true) {
              cellautoapp.undo();      
              undoevent = false;
            }
            cellautoapp.stop2();
            running = false;
          }
          sleep(1);
        }
      } catch (InterruptedException e) {
        e.printStackTrace();
      }
      
    }
  }
  public void runqqq() {
    if (cellautoapp.verbose == true) {
      System.out.println("start");
    }
    done = false;
    running = true;
    long time1 = System.currentTimeMillis();
    long time2 = 0;
    while (numgenerations > 0) {
      try {
        cellautoapp.calc(1,repaint_every_generation);
        time2 = System.currentTimeMillis();
        long sleep_time = delay - (time2 - time1);
        if (sleep_time < 1) {sleep_time = 1;}
        sleep(sleep_time);
        time1 = System.currentTimeMillis();
      } catch (InterruptedException e) {
        e.printStackTrace();
      }
      if (done == true) {break;}
      numgenerations--;
    }
    running = false;
    if (undoevent == true) {
      cellautoapp.undo();      
      undoevent = false;
    }
    cellautoapp.cellautomainwindow.repaint();
    if (cellautoapp.cellauto131.lookuptableallused == false) {
      cellautoapp.edittablewindow.repaint();
    }
    if (cellautoapp.verbose == true) {
      System.out.println("done");
    }
  }
}
class rulefamilybrowserc extends JFrame {
  JList listbox;
  JButton button1;
  JButton button2;
  JScrollPane listboxscroller;
  Vector list;
  rulefamilybrowserc(String name){
    super(name);
    list = abstractcellautorulefamily.getrulefamilylist();
    listbox = new JList(list);
    listboxscroller = new JScrollPane(listbox);
    button1 = new JButton("select rule family");
    button1.setActionCommand("rule_family_browser_select_rule_family");
    button1.addActionListener(cellautoapp.actlis);

    button2 = new JButton("close");
    button2.setActionCommand("rule_family_browser_close");
    button2.addActionListener(cellautoapp.actlis);
    SpringLayout spl = new SpringLayout();
    this.getContentPane().setLayout(spl);
    spl.putConstraint(SpringLayout.EAST,listboxscroller,-2,SpringLayout.EAST,this.getContentPane());
    spl.putConstraint(SpringLayout.WEST,listboxscroller,2,SpringLayout.WEST,this.getContentPane());
    spl.putConstraint(SpringLayout.SOUTH,listboxscroller,-32,SpringLayout.SOUTH,this.getContentPane());
    spl.putConstraint(SpringLayout.NORTH,listboxscroller,2,SpringLayout.NORTH,this.getContentPane());
    spl.putConstraint(SpringLayout.NORTH,button1,0,SpringLayout.SOUTH,listboxscroller);
    spl.putConstraint(SpringLayout.NORTH,button2,0,SpringLayout.SOUTH,listboxscroller);
    spl.putConstraint(SpringLayout.SOUTH,button1,0,SpringLayout.SOUTH,this.getContentPane());
    spl.putConstraint(SpringLayout.SOUTH,button2,0,SpringLayout.SOUTH,this.getContentPane());
    spl.putConstraint(SpringLayout.WEST,button1,0,SpringLayout.WEST,this.getContentPane());
    spl.putConstraint(SpringLayout.WEST,button2,0,SpringLayout.EAST,button1);
    this.getContentPane().add(listboxscroller);
    this.getContentPane().add(button1);
    this.getContentPane().add(button2);
    this.pack();
    
  }
  void select_rule_family() {
     cellautoapp.calc_one_row = false;
     int i = listbox.getSelectedIndex();
     String name = (String) list.get(i);
     cellautoapp.cellauto131.rulefamily = abstractcellautorulefamily.getrulefamily(name);
     abstractcellautorulefamily r = cellautoapp.cellauto131.rulefamily;
     if (r != null) {
       while (cellautoapp.cellauto131.numcolors < r.get_min_colors()) {
         int i2 = cellautoapp.cellauto131.addnewstate();
         r.update_new_color(cellautoapp.cellauto131,i2);
       }
     }
     int min_table_width = r.get_min_table_width();
     int tablewidth = cellautoapp.cellauto131.tablewidth;
     int tableheight = cellautoapp.cellauto131.tableheight;
     if (min_table_width > tablewidth) {
         cellautoapp.cellauto131.resizetable(min_table_width,tableheight);
     }
     if (cellautoapp.cellauto131.rulefamily != null){
       cellautoapp.cellauto131.filllookuptableused();
       cellautoapp.cellautomainwindow.repaint();
       cellautoapp.edittablewindow.repaint();       
       cellautoapp.colorbox.repaint();
     } 
     //b.background_tile_sub_board2 = new simpleboardc(b.background_tile_sub_board);

  }
}


class filebrowserc extends JFrame implements MouseListener {
  JList listbox;
  JButton button1;
  JButton button2;
  JScrollPane listboxscroller;
  String directory;
  DefaultListModel list;
  ZipFile zip = null;
  filebrowserc() {
    super("file browser");
    list = new DefaultListModel();
    listbox = new JList(list);
    listboxscroller = new JScrollPane(listbox);
    button1 = new JButton("load list");
    button1.setActionCommand("file_browser_load_list");
    button1.addActionListener(cellautoapp.actlis);

    button2 = new JButton("load pattern");
    button2.setActionCommand("file_browser_load_file");
    button2.addActionListener(cellautoapp.actlis);
    SpringLayout spl = new SpringLayout();
    this.getContentPane().setLayout(spl);

    spl.putConstraint(SpringLayout.EAST,listboxscroller,-2,SpringLayout.EAST,this.getContentPane());
    spl.putConstraint(SpringLayout.WEST,listboxscroller,2,SpringLayout.WEST,this.getContentPane());
    spl.putConstraint(SpringLayout.SOUTH,listboxscroller,-32,SpringLayout.SOUTH,this.getContentPane());
    spl.putConstraint(SpringLayout.NORTH,listboxscroller,2,SpringLayout.NORTH,this.getContentPane());
    spl.putConstraint(SpringLayout.NORTH,button1,0,SpringLayout.SOUTH,listboxscroller);
    spl.putConstraint(SpringLayout.NORTH,button2,0,SpringLayout.SOUTH,listboxscroller);
    spl.putConstraint(SpringLayout.SOUTH,button1,0,SpringLayout.SOUTH,this.getContentPane());
    spl.putConstraint(SpringLayout.SOUTH,button2,0,SpringLayout.SOUTH,this.getContentPane());
    spl.putConstraint(SpringLayout.WEST,button1,0,SpringLayout.WEST,this.getContentPane());
    spl.putConstraint(SpringLayout.WEST,button2,0,SpringLayout.EAST,button1);
    this.getContentPane().add(listboxscroller);
    this.getContentPane().add(button1);
    this.getContentPane().add(button2);
    listbox.addMouseListener(this);
    this.pack();
  }
  //loadzipfile loads a zip file
  //Parameters: 
  //  filename: what zip file to load
  void loadzipfile(String filename) {
    try {
      zip = new ZipFile(filename);
      list.clear();
      Enumeration e = zip.entries();
      while(e.hasMoreElements()) {
        ZipEntry entry = (ZipEntry) e.nextElement();
        list.addElement(entry.getName());
      }    
    } catch (IOException e) {
      e.printStackTrace();
    }
  }

  //loadlist asks the user to select a file that has
  //a list of pattern files or a zip file then loads that file
  void loadlist() {
    String line;
    System.out.println("load list \n");
    try {
      FileDialog f = new FileDialog(this,"open list",FileDialog.LOAD);
      f.show();
      if (f.getFile() != null) {
        String filename = f.getDirectory() + f.getFile();
        String type = cellautoapp.getfiletype(filename);
        directory = f.getDirectory();
        if (type.equals("zip")){
          loadzipfile(filename);
        } else {
          BufferedReader r = new BufferedReader(new FileReader(filename));
          line = r.readLine();
          int e = 1;
          if (line != null) {
            line = line.trim();
            line = line.toLowerCase();
            if (line.equals("cell_auto_list")) {e = 0;}
          }
          if (e == 0) {
            zip = null;
            line = r.readLine();
            list.clear();
            while (line != null) {
              list.addElement(line);
              line = r.readLine();
            }
          }else{
            JOptionPane.showMessageDialog(cellautoapp.cellautowindowframe,new JLabel("the first line that says cell_auto_list is not found"),"error",JOptionPane.ERROR_MESSAGE);
          }
          r.close();
        }
      }
    } catch (IOException e) {
      e.printStackTrace();
    }
  }

  //loadfile loads a file that is in the list
  void loadfile() {
    try {
      System.out.println("load file \n");
      int i = listbox.getSelectedIndex();
      if (zip == null){
        String filename = directory + list.get(i);
        cellautoapp.open(filename);
      } else {
        String filename = (String) list.get(i);
        String filetype = cellautoapp.getfiletype(filename);
        ZipEntry e = zip.getEntry(filename);       
        if (filetype.equals("sqc")) {
          int r = cellautoapp.opensqc(new BufferedReader(new InputStreamReader(zip.getInputStream(e))));
          if (r == -1){
            cellautoapp.opentext(new BufferedReader(new InputStreamReader(zip.getInputStream(e))));
          }
        } else {
          cellautoapp.opentext(new BufferedReader(new InputStreamReader(zip.getInputStream(e))));
        }
      }
      cellautoapp.cellautowindowframe.requestFocusInWindow();
      cellautoapp.cellautomainwindow.repaint();
      cellautoapp.board2 = new boardc(cellautoapp.board);
      cellautoapp.colorbox.colorboxpanel.repaint();
      cellautoapp.edittablewindow.edittablepanel.repaint();
      cellautoapp.cellauto131.filename = (String) list.get(i);
      cellautoapp.updatestatusbar();
    } catch (IOException e) {
      e.printStackTrace();
    }
  }
  public void mouseClicked(MouseEvent e) {
    if (e.getClickCount() == 2) {
      loadfile();
    }
  }
  public void mouseEntered(MouseEvent e) {}
  public void mouseExited(MouseEvent e) {}
  public void mousePressed(MouseEvent e) {}
  public void mouseReleased(MouseEvent e) {}
}
class table_grid_spacing_dialogc extends JFrame {
  JLabel grid_x_spacing_label;
  JTextField grid_x_spacing_edit;
  JLabel grid_y_spacing_label;
  JTextField grid_y_spacing_edit;

  JLabel grid_x_spacing2_label;
  JTextField grid_x_spacing2_edit;
  JLabel grid_y_spacing2_label;
  JTextField grid_y_spacing2_edit;
  
  JButton okbutton;
  JButton cancelbutton;
  
  table_grid_spacing_dialogc(String Title) {
    this.setTitle(Title);
    GridBagLayout gl = new GridBagLayout();
    this.getContentPane().setLayout(gl);
    GridBagConstraints cc = new GridBagConstraints();
    cc.fill = GridBagConstraints.BOTH;
    cc.weightx = 1.0;
    cc.weighty = 1.0;

    grid_x_spacing_label = new JLabel("x spacing");
    cc.gridwidth = 1;
    gl.setConstraints(grid_x_spacing_label, cc);
    this.getContentPane().add(grid_x_spacing_label);    

    grid_x_spacing_edit = new JTextField("5");
    cc.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(grid_x_spacing_edit, cc);
    this.getContentPane().add(grid_x_spacing_edit);    
    

    grid_y_spacing_label = new JLabel("y spacing");
    cc.gridwidth = 1;
    gl.setConstraints(grid_y_spacing_label, cc);
    this.getContentPane().add(grid_y_spacing_label);    

    grid_y_spacing_edit = new JTextField("5");
    cc.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(grid_y_spacing_edit, cc);
    this.getContentPane().add(grid_y_spacing_edit);    

    
    grid_x_spacing2_label = new JLabel("x spacing 2");
    cc.gridwidth = 1;
    gl.setConstraints(grid_x_spacing2_label, cc);
    this.getContentPane().add(grid_x_spacing2_label);    

    grid_x_spacing2_edit = new JTextField("5");
    cc.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(grid_x_spacing2_edit, cc);
    this.getContentPane().add(grid_x_spacing2_edit);    

    grid_y_spacing2_label = new JLabel("y spacing 2");
    cc.gridwidth = 1;
    gl.setConstraints(grid_y_spacing2_label, cc);
    this.getContentPane().add(grid_y_spacing2_label);    

    grid_y_spacing2_edit = new JTextField("5");
    cc.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(grid_y_spacing2_edit, cc);
    this.getContentPane().add(grid_y_spacing2_edit);    

    okbutton = new JButton("ok");
    okbutton.setActionCommand("gridspacing_okbuttonclick");
    okbutton.addActionListener(cellautoapp.actlis);
    cc.gridwidth = 1;
    gl.setConstraints(okbutton, cc);
    this.getContentPane().add(okbutton);

    cancelbutton = new JButton("cancel");
    cancelbutton.setActionCommand("gridspacing_cancelbuttonclick");
    cancelbutton.addActionListener(cellautoapp.actlis);
    cc.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(cancelbutton, cc);
    this.getContentPane().add(cancelbutton);        

    this.pack();
  }
  void get_grid_spacing() {
    grid_x_spacing_edit.setText(Integer.toString(edittablepanelc.grid_x_spacing));
    grid_y_spacing_edit.setText(Integer.toString(edittablepanelc.grid_y_spacing));
    grid_x_spacing2_edit.setText(Integer.toString(edittablepanelc.grid_x_spacing2));
    grid_y_spacing2_edit.setText(Integer.toString(edittablepanelc.grid_y_spacing2));
  }
  void update_grid_spacing() {
    edittablepanelc.grid_x_spacing = Integer.valueOf(grid_x_spacing_edit.getText()).intValue();
    edittablepanelc.grid_y_spacing = Integer.valueOf(grid_y_spacing_edit.getText()).intValue();
    edittablepanelc.grid_x_spacing2 = Integer.valueOf(grid_x_spacing2_edit.getText()).intValue();
    edittablepanelc.grid_y_spacing2 = Integer.valueOf(grid_y_spacing2_edit.getText()).intValue();
  }
}
class newgamedialogc extends JFrame {
  JLabel boardlabel;
  JLabel widthlabel;
  JTextField widthedit;
  JLabel heightlabel;
  JTextField heightedit;
  
  JLabel rectanglelabel;
  JLabel seedlabel;
  JTextField seededit;
  JLabel rectoffsetxlabel;
  JTextField rectoffsetxedit;
  JLabel rectoffsetylabel;
  JTextField rectoffsetyedit;
  JLabel rectwidthlabel;
  JTextField rectwidthedit;
  JLabel rectheightlabel;
  JTextField rectheightedit;
  JLabel numcolorslabel;
  JTextField numcolorsedit;
  
  JButton selectionbutton;
  JButton okbutton;
  JButton applybutton;
  JButton cancelbutton;
  JButton clearbutton;
  JLabel horizontalsymmetrylabel;
  JCheckBox horizontalsymmetrycheckBox;
  JLabel verticalsymmetrylabel;
  JCheckBox verticalsymmetrycheckBox;
  JCheckBox addcellscheckBox;
  JCheckBox iscirclecheckBox;
  JLabel symmetrylabel;
  JComboBox symmetrycombobox;
  static int HORIZONTAL_SYMMETRY = cellautoapp.HORIZONTAL_SYMMETRY;
  static int VERTICAL_SYMMETRY = cellautoapp.VERTICAL_SYMMETRY;
  static int INCLUDE_HORIZONTAL_LINE = cellautoapp.INCLUDE_HORIZONTAL_LINE;
  static int INCLUDE_VERTICAL_LINE = cellautoapp.INCLUDE_VERTICAL_LINE;

  String[] symmetryStrings = {"no symmetry","horizontal symmetry 1","horizontal symmetry 2","vertical symmetry 1",
  "vertical symmetry 2","horizontal and vertical symmetry 1","horizontal and vertical symmetry 2",
  "horizontal and vertical symmetry 3","horizontal and vertical symmetry 4"};
  int[] symmetryindex = {0, HORIZONTAL_SYMMETRY,HORIZONTAL_SYMMETRY | INCLUDE_VERTICAL_LINE,
  VERTICAL_SYMMETRY,VERTICAL_SYMMETRY | INCLUDE_HORIZONTAL_LINE,VERTICAL_SYMMETRY | HORIZONTAL_SYMMETRY,
  VERTICAL_SYMMETRY | HORIZONTAL_SYMMETRY | INCLUDE_VERTICAL_LINE,VERTICAL_SYMMETRY | HORIZONTAL_SYMMETRY | INCLUDE_HORIZONTAL_LINE,
  VERTICAL_SYMMETRY | HORIZONTAL_SYMMETRY | INCLUDE_VERTICAL_LINE | INCLUDE_HORIZONTAL_LINE};
  int seed;
  newgamedialogc(String Title) {
    super(Title);
    seed = 1;
    GridBagLayout gl = new GridBagLayout();
    this.getContentPane().setLayout(gl);
    GridBagConstraints c = new GridBagConstraints();
    
    c.fill = GridBagConstraints.BOTH;
    c.weightx = 1.0;
    c.weighty = 1.0;
    
    c.gridwidth = GridBagConstraints.REMAINDER;
    boardlabel = new JLabel();
    boardlabel.setText("board size");
    gl.setConstraints(boardlabel, c);
    
    c.gridwidth = 3;
    widthlabel = new JLabel();
    widthlabel.setText("width");
    gl.setConstraints(widthlabel, c);

    widthedit = new JTextField();
    widthedit.setText(String.valueOf(cellautoapp.board.width));
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(widthedit, c);

    heightlabel = new JLabel();
    heightlabel.setText("height");
    c.gridwidth = 3;
    gl.setConstraints(heightlabel, c);

    heightedit = new JTextField();
    heightedit.setText(String.valueOf(cellautoapp.board.height));
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(heightedit, c);
    
    c.gridwidth = GridBagConstraints.REMAINDER;
    rectanglelabel = new JLabel();
    rectanglelabel.setText("rectangle of random cells");
    gl.setConstraints(rectanglelabel, c);
    
    c.gridwidth = 3;
    seedlabel = new JLabel();
    seedlabel.setText("seed");
    gl.setConstraints(seedlabel, c);
    
    c.gridwidth = GridBagConstraints.REMAINDER;
    seededit = new JTextField();
    seededit.setText(Integer.toString(seed));
    gl.setConstraints(seededit, c);
    
    c.gridwidth = 3;
    numcolorslabel = new JLabel();
    numcolorslabel.setText("colors");
    gl.setConstraints(numcolorslabel, c);
    
    c.gridwidth = GridBagConstraints.REMAINDER;
    numcolorsedit = new JTextField();
    numcolorsedit.setText("0");
    gl.setConstraints(numcolorsedit, c);
    
    c.gridwidth = 3;
    rectoffsetxlabel = new JLabel();
    rectoffsetxlabel.setText("offset x");
    gl.setConstraints(rectoffsetxlabel, c);
    
    c.gridwidth = GridBagConstraints.REMAINDER;
    rectoffsetxedit = new JTextField();
    rectoffsetxedit.setText("0");
    gl.setConstraints(rectoffsetxedit, c);
    
    c.gridwidth = 3;
    rectoffsetylabel = new JLabel();
    rectoffsetylabel.setText("offset y");
    gl.setConstraints(rectoffsetylabel, c);
    
    c.gridwidth = GridBagConstraints.REMAINDER;
    rectoffsetyedit = new JTextField();
    rectoffsetyedit.setText("0");
    gl.setConstraints(rectoffsetyedit, c);
    
    c.gridwidth = 3;
    rectwidthlabel = new JLabel();
    rectwidthlabel.setText("width");
    gl.setConstraints(rectwidthlabel, c);
    
    c.gridwidth = GridBagConstraints.REMAINDER;
    rectwidthedit = new JTextField();
    rectwidthedit.setText("0");
    gl.setConstraints(rectwidthedit, c);
    
    c.gridwidth = 3;
    rectheightlabel = new JLabel();
    rectheightlabel.setText("height");
    gl.setConstraints(rectheightlabel, c);
    
    c.gridwidth = GridBagConstraints.REMAINDER;
    rectheightedit = new JTextField();
    rectheightedit.setText("0");
    gl.setConstraints(rectheightedit, c);


    selectionbutton = new JButton();
    selectionbutton.setText("use selection");
    selectionbutton.setActionCommand("useselectionbuttonclick");
    selectionbutton.addActionListener(cellautoapp.actlis);
    c.gridwidth = GridBagConstraints.REMAINDER;
    
    gl.setConstraints(selectionbutton, c);
    
    
    c.gridwidth = GridBagConstraints.REMAINDER;
    horizontalsymmetrycheckBox = new JCheckBox();
    horizontalsymmetrycheckBox.setText("horizontal symmetry");
    gl.setConstraints(horizontalsymmetrycheckBox, c);
    
    
    c.gridwidth = GridBagConstraints.REMAINDER;
    verticalsymmetrycheckBox = new JCheckBox();
    verticalsymmetrycheckBox.setText("vertical symmetry");
    gl.setConstraints(verticalsymmetrycheckBox, c);
    
    c.gridwidth = GridBagConstraints.REMAINDER;
    addcellscheckBox = new JCheckBox();
    addcellscheckBox.setText("add cells");
    gl.setConstraints(addcellscheckBox, c);
    

    c.gridwidth = GridBagConstraints.REMAINDER;
    iscirclecheckBox = new JCheckBox();
    iscirclecheckBox.setText("is circle");
    gl.setConstraints(iscirclecheckBox, c);
    
    
    c.gridwidth = GridBagConstraints.REMAINDER;
    symmetrylabel = new JLabel();
    symmetrylabel.setText("symmetry");
    gl.setConstraints(symmetrylabel, c);
    
    c.gridwidth = GridBagConstraints.REMAINDER;
    symmetrycombobox = new JComboBox(symmetryStrings);
    symmetrycombobox.setSelectedIndex(0);
    gl.setConstraints(symmetrycombobox, c);
    
    
    okbutton = new JButton();
    okbutton.setText("ok");
    okbutton.setActionCommand("newgameokbuttonclick");
    okbutton.addActionListener(cellautoapp.actlis);
    c.gridwidth = 2;
    
    gl.setConstraints(okbutton, c);
    
    applybutton = new JButton();
    applybutton.setText("apply");
    applybutton.setActionCommand("newgameapplybuttonclick");
    applybutton.addActionListener(cellautoapp.actlis);
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(applybutton, c);
    
    cancelbutton = new JButton();
    cancelbutton.setText("cancel");
    cancelbutton.setActionCommand("newgamecancelbuttonclick");
    cancelbutton.addActionListener(cellautoapp.actlis);
    c.gridwidth = 2;
    gl.setConstraints(cancelbutton, c);
    
    
    clearbutton = new JButton();
    clearbutton.setText("clear");
    clearbutton.setActionCommand("newgameclearbuttonclick");
    clearbutton.addActionListener(cellautoapp.actlis);
    c.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(clearbutton, c);
    
    
    this.getContentPane().add(boardlabel);
    this.getContentPane().add(widthlabel);
    this.getContentPane().add(widthedit);
    this.getContentPane().add(heightlabel);
    this.getContentPane().add(heightedit);
    this.getContentPane().add(rectanglelabel);
    this.getContentPane().add(seedlabel);
    this.getContentPane().add(seededit);
    this.getContentPane().add(numcolorslabel);
    this.getContentPane().add(numcolorsedit);
    this.getContentPane().add(rectoffsetxlabel);
    this.getContentPane().add(rectoffsetxedit);
    this.getContentPane().add(rectoffsetylabel);
    this.getContentPane().add(rectoffsetyedit);
    this.getContentPane().add(rectwidthlabel);
    this.getContentPane().add(rectwidthedit);
    this.getContentPane().add(rectheightlabel);
    this.getContentPane().add(rectheightedit);

    this.getContentPane().add(selectionbutton);
    this.getContentPane().add(horizontalsymmetrycheckBox);
    this.getContentPane().add(verticalsymmetrycheckBox);
    this.getContentPane().add(addcellscheckBox);
    this.getContentPane().add(iscirclecheckBox);
    this.getContentPane().add(symmetrylabel);
    this.getContentPane().add(symmetrycombobox);
    this.getContentPane().add(okbutton);
    this.getContentPane().add(applybutton);
    this.getContentPane().add(cancelbutton);
    this.getContentPane().add(clearbutton);
    
    this.pack();
  }
  void useselection() {
    rectoffsetxedit.setText(Integer.toString(cellautoapp.selx));
    rectoffsetyedit.setText(Integer.toString(cellautoapp.sely));
    rectwidthedit.setText(Integer.toString(cellautoapp.selw));
    rectheightedit.setText(Integer.toString(cellautoapp.selh));
    
  }
  
  void clear() {
    int width = Integer.parseInt(widthedit.getText().trim());
    int height = Integer.parseInt(heightedit.getText().trim());
    cellautoapp.cellauto131.filename = null;
    boardc b = cellautoapp.board;
    cellautoapp.board = new boardc(width,height);
    cellautoapp.board.wrapx = b.wrapx;
    cellautoapp.board.wrapy = b.wrapy;
    if (cellautoapp.cellauto131.rulefamily != null) {
      cellautoapp.board.background_tile_sub_board = new simpleboardc(
      cellautoapp.cellauto131.rulefamily.get_background_tile_width(),
      cellautoapp.cellauto131.rulefamily.get_background_tile_height());
    } else {
      cellautoapp.board.background_tile_sub_board = new simpleboardc(1,1);
    }
    cellautoapp.board2 = new boardc(cellautoapp.board);
    cellautoapp.generation = 0;
    cellautoapp.updatestatusbar();
    cellautoapp.cellautomainwindow.repaint();
  }

  void newgame() {
    cellautoapp.seednumcolors = Integer.parseInt(numcolorsedit.getText().trim());

    int numcolors = cellautoapp.seednumcolors;
    if (numcolors <= 1){numcolors = cellautoapp.cellauto131.numcolors;}
    if (numcolors > cellautoapp.cellauto131.numcolors){
      numcolors = cellautoapp.cellauto131.numcolors;
    }
    int width = Integer.parseInt(widthedit.getText().trim());
    int height = Integer.parseInt(heightedit.getText().trim());
    int seed2 = Integer.parseInt(seededit.getText().trim());
    int sx = Integer.parseInt(rectoffsetxedit.getText().trim());
    int sy = Integer.parseInt(rectoffsetyedit.getText().trim());
    int swidth = Integer.parseInt(rectwidthedit.getText().trim());
    int sheight = Integer.parseInt(rectheightedit.getText().trim());
    int swidth2 = swidth;
    int sheight2 = sheight;
    boolean horizontalsymmetry = horizontalsymmetrycheckBox.isSelected();
    boolean verticalsymmetry = verticalsymmetrycheckBox.isSelected();
    boolean addcells = addcellscheckBox.isSelected();
    boolean iscircle = iscirclecheckBox.isSelected();
    cellautoapp.cellauto131.filename = null;
    
    
    //seed the board
    seededit.setText(Integer.toString(seed2+1));
    seed = seed2 + 1;
    if (addcells == false) {
      boardc b = cellautoapp.board;
      cellautoapp.board = new boardc(width,height);
      cellautoapp.board.wrapx = b.wrapx;
      cellautoapp.board.wrapy = b.wrapy;
      if (cellautoapp.cellauto131.rulefamily != null) {
        cellautoapp.board.background_tile_sub_board = new simpleboardc(
          cellautoapp.cellauto131.rulefamily.get_background_tile_width(),
          cellautoapp.cellauto131.rulefamily.get_background_tile_height());
      } else {
        cellautoapp.board.background_tile_sub_board = new simpleboardc(1,1);
      }
      cellautoapp.board2 = new boardc(cellautoapp.board);
      cellautoapp.cell_mask = 255;
    }
    cellautoapp.rand.setSeed(seed2);
    if (horizontalsymmetry) {
      swidth2 = (swidth >> 1) + (swidth & 1);
    }
    if (verticalsymmetry) {
      sheight2 = (sheight >> 1) + (sheight & 1);
    }
    
    //add random cells to board
    for (int x = 0;x < swidth;x++) {
      for (int y = 0;y < sheight;y++) {
        int a = cellautoapp.rand.nextInt(numcolors);
        if (iscircle == true) {
          double dx = ((double) x) / ((double) swidth);
          double dy = ((double) y) / ((double) sheight);
          dx = (dx * 2.0) - 1.0;
          dy = (dy * 2.0) - 1.0;
          double l = Math.sqrt((dx*dx)+(dy*dy));
          if (l > 1.0){a = 0;}
        }                                          
        
        if (addcells == true) {
  	  cellautoapp.draw_cell(x+sx,y+sy,a);
          if (horizontalsymmetry) {cellautoapp.draw_cell((swidth-x-1)+sx,y+sy,a);}
          if (verticalsymmetry) {cellautoapp.draw_cell(x+sx,(sheight-y-1)+sy,a);}
          if (horizontalsymmetry) {
            if (verticalsymmetry) {
              cellautoapp.draw_cell((swidth-x-1)+sx,(sheight-y-1)+sy,a);
            }
          }	  
	} else {	
  	  cellautoapp.board.setsq(x+sx,y+sy,a);
          if (horizontalsymmetry) {cellautoapp.board.setsq((swidth-x-1)+sx,y+sy,a);}
          if (verticalsymmetry) {cellautoapp.board.setsq(x+sx,(sheight-y-1)+sy,a);}
          if (horizontalsymmetry) {
            if (verticalsymmetry) {
              cellautoapp.board.setsq((swidth-x-1)+sx,(sheight-y-1)+sy,a);
            }
          }
	}
      }
    }
    if (addcells == false) {
      cellautoapp.generation = 0;
    }
    cellautoapp.updatestatusbar();
    cellautoapp.cellautomainwindow.repaint();
    int w2 = cellautoapp.cellautomainwindow.getWidth() / cellautomainwindowc.sqsize;
    int h2 = cellautoapp.cellautomainwindow.getHeight() / cellautomainwindowc.sqsize;

    cellautoapp.offsetx = sx-((w2-swidth)/2);
    cellautoapp.offsety = sy-((h2-sheight)/2);
    cellautoapp.symmetrybits = symmetryindex[symmetrycombobox.getSelectedIndex()];
  }
  void update_symmetrycombobox(int s) {
    if (s == 0) {
      symmetrycombobox.setSelectedIndex(0);
    } else {
      for (int i = 0;i < symmetryindex.length;i++) {
        if (s == symmetryindex[i]) {
          symmetrycombobox.setSelectedIndex(i);
        }
      }
    }
  }
}

class edittablewindowc extends JFrame {
  public edittablepanelc edittablepanel;
  public JScrollBar hscroll;
  public JScrollBar vscroll;
  edittableadjlisc adjlis;
  
  edittablewindowc(String Title){
    super(Title);
    adjlis = new edittableadjlisc();
    edittablepanel = new edittablepanelc();
    hscroll = new JScrollBar();
    vscroll = new JScrollBar();
    vscroll.setOrientation(JScrollBar.VERTICAL);
    vscroll.setMinimum(0);
    vscroll.setVisibleAmount(0);
    vscroll.setMaximum(cellautoapp.cellauto131.tableheight-2);
    vscroll.addAdjustmentListener(adjlis);
    hscroll.setMinimum(0);
    hscroll.setVisibleAmount(0);
    hscroll.setMaximum(cellautoapp.cellauto131.tablewidth-4);
    hscroll.addAdjustmentListener(adjlis);
    hscroll.setOrientation(JScrollBar.HORIZONTAL);
    SpringLayout spl = new SpringLayout();
    this.getContentPane().setLayout(spl);
    spl.putConstraint(SpringLayout.EAST,vscroll,0,SpringLayout.EAST,this.getContentPane());    
    spl.putConstraint(SpringLayout.EAST,edittablepanel,0,SpringLayout.WEST,vscroll);
    spl.putConstraint(SpringLayout.WEST,edittablepanel,0,SpringLayout.WEST,this.getContentPane());
    
    spl.putConstraint(SpringLayout.SOUTH,hscroll,0,SpringLayout.SOUTH,this.getContentPane());    
    spl.putConstraint(SpringLayout.SOUTH,edittablepanel,0,SpringLayout.NORTH,hscroll);    
    spl.putConstraint(SpringLayout.NORTH,edittablepanel,0,SpringLayout.NORTH,this.getContentPane());
    
    spl.putConstraint(SpringLayout.SOUTH,vscroll,0,SpringLayout.NORTH,hscroll);    
    spl.putConstraint(SpringLayout.NORTH,vscroll,0,SpringLayout.NORTH,this.getContentPane());    
    
    spl.putConstraint(SpringLayout.EAST,hscroll,0,SpringLayout.WEST,vscroll);    
    spl.putConstraint(SpringLayout.WEST,hscroll,0,SpringLayout.WEST,this.getContentPane());    
    this.getContentPane().add(edittablepanel);
    this.getContentPane().add(vscroll);
    this.getContentPane().add(hscroll);
    this.pack();  
    edittablepanel.setFocusable(true);
  }
};

class periodcheckerthreadc extends Thread {
  boolean running = true;
  boardc periodcheckerboard;
  boardc periodcheckerboard2;
  int period = 0;
  int shipdx = 0;
  int shipdy = 0;
  boolean period_found = false;

  // this function runs the period checker
  public void run(){
    period = 0;
    running = true;
    periodcheckerboard = new boardc(cellautoapp.board.width,cellautoapp.board.height);
    periodcheckerboard2 = new boardc(cellautoapp.board.width,cellautoapp.board.height);    
    for (int x = 0;x < cellautoapp.selw;x++) {
      for (int y = 0;y < cellautoapp.selh;y++) {
        int i = cellautoapp.seldata[x][y];

        periodcheckerboard.setsq(x,y,i);
        periodcheckerboard2.setsq(x,y,i);
      }
    }
    while (running == true) {
      if (checkoneperiod() == true) {
        period_found = true;
        running = false;
        break;
      }
      try {
        sleep(1);
      } catch (InterruptedException e) {
        e.printStackTrace();
      }
      
    }
    running = false;
  } 

  boolean compareboardtoselection(int dx,int dy) {
    for (int x = 0;x < cellautoapp.selw;x++) {
      for (int y = 0;y < cellautoapp.selh;y++) {
        int i = cellautoapp.seldata[x][y];
        int i2 = periodcheckerboard.getsq(x+dx,y+dy);
        if (i != i2) {
          return false;
        }
      }
    }
    return true;
  }
  boolean checkoneperiod() {
    int bordersize = 1;
    if (cellautoapp.cellauto131.rulefamily != null) {
      bordersize = cellautoapp.cellauto131.rulefamily.getbordersize();
    } else {
      bordersize = cellautoapp.cellauto131.bordersize;
    }
    boardc tmp = periodcheckerboard;
    periodcheckerboard = cellautoapp.cellauto131.calc436(periodcheckerboard,periodcheckerboard2);
    periodcheckerboard2 = tmp;
    period++;
    for (int dx = -bordersize*period;dx <= bordersize*period;dx++) {
      for (int dy = -bordersize*period;dy <= bordersize*period;dy++) {
        shipdx = dx;
        shipdy = dy;
        if (running == false) {return false;}
        try {
          sleep(0);
        } catch (InterruptedException e) {
          e.printStackTrace();
        }
        boolean b = compareboardtoselection(dx,dy);
        if (b == true) {return true;}
        
      }
    }

    return false;
  }  
}
class periodcheckeractlisc implements ActionListener {
  periodcheckerdialogc periodcheckerdialog;
  public void actionPerformed(ActionEvent e) {
    periodcheckerdialog.checkthread();
  }
}


class edit_keys_dialogc extends JFrame implements ActionListener{
  public JLabel key_label[];
  public JTextField key_edit[];
  public JComboBox keys_combobox;
 
  int numkeys = 17;
  static char keysets[][] = new char[3][20];
  String combo_box_strings[] = {"old keys","new keys","custom keys"};
  static int combo_box_index = 2;
  //static int selected_key_set = 2;
  JButton loadbutton;
  JButton savebutton;

  JButton applybutton;
  JButton closebutton;
  edit_keys_dialogc(String Title) {
    super(Title);
    
    //combo_box_index = selected_key_set;
    GridBagLayout gl = new GridBagLayout();
    this.getContentPane().setLayout(gl);
    GridBagConstraints c = new GridBagConstraints();

    c.fill = GridBagConstraints.BOTH;
    c.weightx = 1.0;
    c.weighty = 1.0;

    key_label = new JLabel[numkeys];
    key_edit = new JTextField[numkeys];
    for (int i = 0;i < numkeys;i++) {
      c.gridwidth = 3;
      key_label[i] = new JLabel("key " + i);
      gl.setConstraints(key_label[i], c);
      this.getContentPane().add(key_label[i]);
      
      char ch = keysets[combo_box_index][i];
      c.gridwidth = GridBagConstraints.REMAINDER;
      key_edit[i] = new JTextField(Character.toString(ch));
      gl.setConstraints(key_edit[i], c);
      this.getContentPane().add(key_edit[i]);
    }

    key_label[0].setText("pencil_tool_key");
    key_label[1].setText("select_tool_key");
    key_label[2].setText("move_tool_key");
    key_label[3].setText("random_entry_stack_key");     
    key_label[4].setText("save_and_clear_key");
    key_label[5].setText("save_to_stack_key");       
    key_label[6].setText("undo_key");
    key_label[7].setText("redo_key");
    key_label[8].setText("find_selection_key");
    key_label[9].setText("pan_mode_key");
    key_label[10].setText("xor_mode_key");
    key_label[11].setText("prev_color_key");
    key_label[12].setText("next_color_key");
    key_label[13].setText("prev_tool_key");
    key_label[14].setText("next_tool_key");
    key_label[15].setText("calc_key");
    key_label[16].setText("calc_key2");
    
    c.gridwidth = GridBagConstraints.REMAINDER;
    keys_combobox = new JComboBox(combo_box_strings);
    gl.setConstraints(keys_combobox, c);
    this.getContentPane().add(keys_combobox);
    keys_combobox.setActionCommand("combobox");
    keys_combobox.addActionListener(this);
    keys_combobox.setSelectedIndex(combo_box_index);


    c.gridwidth = 2;
    loadbutton = new JButton("load options and keys");
    gl.setConstraints(loadbutton, c);
    this.getContentPane().add(loadbutton);
    loadbutton.setActionCommand("load");
    loadbutton.addActionListener(this);

      
    c.gridwidth = GridBagConstraints.REMAINDER;
    savebutton = new JButton("save options and keys");
    gl.setConstraints(savebutton, c);
    this.getContentPane().add(savebutton);
    savebutton.setActionCommand("save");
    savebutton.addActionListener(this);


    c.gridwidth = 2;
    applybutton = new JButton("apply");
    gl.setConstraints(applybutton, c);
    this.getContentPane().add(applybutton);
    applybutton.setActionCommand("apply");
    applybutton.addActionListener(this);

      
    c.gridwidth = GridBagConstraints.REMAINDER;
    closebutton = new JButton("close");
    gl.setConstraints(closebutton, c);
    this.getContentPane().add(closebutton);
    closebutton.setActionCommand("close");
    closebutton.addActionListener(this);


    this.pack();
  }
  public static void save_keys(int i) {
    keysets[i][0] = cellautokeys.pencil_tool_key;
    keysets[i][1] = cellautokeys.select_tool_key;
    keysets[i][2] = cellautokeys.move_tool_key;
    keysets[i][3] = cellautokeys.random_entry_stack_key;     
    keysets[i][4] = cellautokeys.save_and_clear_key;
    keysets[i][5] = cellautokeys.save_to_stack_key;       
    keysets[i][6] = cellautokeys.undo_key;
    keysets[i][7] = cellautokeys.redo_key;
    keysets[i][8] = cellautokeys.find_selection_key;
    keysets[i][9] = cellautokeys.pan_mode_key;
    keysets[i][10] = cellautokeys.xor_mode_key;
    keysets[i][11] = cellautokeys.prev_color_key;
    keysets[i][12] = cellautokeys.next_color_key;
    keysets[i][13] = cellautokeys.prev_tool_key;
    keysets[i][14] = cellautokeys.next_tool_key;
    keysets[i][15] = cellautokeys.calc_key;
    keysets[i][16] = cellautokeys.calc_key2;

  }
  public static void restore_keys(int i) {
    cellautokeys.pencil_tool_key = keysets[i][0];
    cellautokeys.select_tool_key = keysets[i][1];
    cellautokeys.move_tool_key = keysets[i][2];
    cellautokeys.random_entry_stack_key = keysets[i][3];     
    cellautokeys.save_and_clear_key = keysets[i][4];
    cellautokeys.save_to_stack_key = keysets[i][5];       
    cellautokeys.undo_key = keysets[i][6];
    cellautokeys.redo_key = keysets[i][7];
    cellautokeys.find_selection_key = keysets[i][8];
    cellautokeys.pan_mode_key = keysets[i][9];
    cellautokeys.xor_mode_key = keysets[i][10];
    cellautokeys.prev_color_key = keysets[i][11];
    cellautokeys.next_color_key = keysets[i][12];
    cellautokeys.prev_tool_key = keysets[i][13];
    cellautokeys.next_tool_key = keysets[i][14];
    cellautokeys.calc_key = keysets[i][15];
    cellautokeys.calc_key2 = keysets[i][16];
    
  }
  public void actionPerformed(ActionEvent e) {
    String action = e.getActionCommand();  
    System.out.println(action);
    if (action.equals("combobox")) {
      int i = keys_combobox.getSelectedIndex();
      for (int a = 0;a < numkeys;a++) {
        String s = key_edit[a].getText().trim();
        char ch = 0;
        if (s.length() > 0) {ch = s.charAt(0);}
        keysets[combo_box_index][a] = ch;
        ch = keysets[i][a];
        if (ch > 0) {key_edit[a].setText(Character.toString(ch));}
        else {key_edit[a].setText("");}
        
      }
      combo_box_index = i;
      //System.out.println("index: " + i);
    }
    if (action.equals("load")) {
        FileDialog f = new FileDialog(cellautoapp.cellautowindowframe,"load options",FileDialog.LOAD);
        f.show();
        if (f.getFile() != null) {
          String filename = f.getDirectory() + f.getFile();
          cellautoapp.readoptionsfromfile(filename);

          //cellautoapp.cellautowindowframe.setJMenuBar(cellautoapp.setup_menu());
          //System.out.println("open ctrl key: " + cellautokeys.open_ctrl_key);
          //System.out.println("move tool key: " + cellautokeys.move_tool_key);
          save_keys(2);
          if (keys_combobox.getSelectedIndex() == 2) {
            for (int a = 0;a < numkeys;a++) {
              char ch = keysets[2][a];
              if (ch > 0) {key_edit[a].setText(Character.toString(ch));}
              else {key_edit[a].setText("");}
            }
          } else {
            keys_combobox.setSelectedIndex(2);
          }
          //restore_keys(2);
        }    
    }
    if (action.equals("save")) {
        FileDialog f = new FileDialog(cellautoapp.cellautowindowframe,"save options",FileDialog.SAVE);
        f.show();
        if (f.getFile() != null) {
          String filename = f.getDirectory() + f.getFile();
          cellautoapp.save_options(filename);
        }    
    }
    if (action.equals("apply")) {
      for (int a = 0;a < numkeys;a++) {
        String s = key_edit[a].getText().trim();
        char ch = 0;
        if (s.length() > 0) {ch = s.charAt(0);}
        keysets[combo_box_index][a] = ch;
      }
      restore_keys(combo_box_index);
    }
    if (action.equals("close")) {
      this.setVisible(false);
    }
         //cellautoapp.menubarheight = mainmenu.getHeight();
         //cellautowindowframe.setJMenuBar(mainmenu);
 
  }
}
class periodcheckerdialogc extends JFrame {
  JButton checkbutton;
  JButton closebutton; 
  public JScrollPane text2; 
  public JTextArea text; 
  public javax.swing.Timer timer = null;

  periodcheckeractlisc actlis;
  periodcheckerthreadc periodcheckerthread = null;

  periodcheckerdialogc(String Title) {
    super(Title);              
    SpringLayout spl = new SpringLayout();
    this.getContentPane().setLayout(spl);
    checkbutton = new JButton("start");
    closebutton = new JButton("close");

    actlis = new periodcheckeractlisc();
    actlis.periodcheckerdialog = this;
    text = new JTextArea();
    text2 = new JScrollPane(text);
    spl.putConstraint(SpringLayout.SOUTH,checkbutton,-5,SpringLayout.SOUTH,this.getContentPane());
    spl.putConstraint(SpringLayout.SOUTH,closebutton,-5,SpringLayout.SOUTH,this.getContentPane());
    spl.putConstraint(SpringLayout.SOUTH,text2,-5,SpringLayout.NORTH,checkbutton);
    spl.putConstraint(SpringLayout.WEST,closebutton,5,SpringLayout.EAST,checkbutton);
    spl.putConstraint(SpringLayout.WEST,checkbutton,5,SpringLayout.WEST,this.getContentPane());

    spl.putConstraint(SpringLayout.NORTH,text2,5,SpringLayout.NORTH,this.getContentPane());
    spl.putConstraint(SpringLayout.EAST,text2,-5,SpringLayout.EAST,this.getContentPane());
    spl.putConstraint(SpringLayout.WEST,text2,5,SpringLayout.WEST,this.getContentPane());

    checkbutton.setActionCommand("periodcheckercheckbuttonclick");
    checkbutton.addActionListener(cellautoapp.actlis);
    closebutton.setActionCommand("periodcheckerclosebuttonclick");
    closebutton.addActionListener(cellautoapp.actlis);


    this.getContentPane().add(text2);
    this.getContentPane().add(checkbutton);
    this.getContentPane().add(closebutton);

    defaultlabeltext();
    this.pack();
  }
  void defaultlabeltext() {
    text.setText(" make a selection of the object \n you want to check then \n press the start button \n");
 
  }

  void checkobject() {
    if (periodcheckerthread == null) {
       if (cellautoapp.is_selection_empty() == true) {
        text.setText("no object found");
      } else {
        periodcheckerthread = new periodcheckerthreadc();

        checkbutton.setText("stop");
        text.setText("the period checker is running. \n" + 
                     "press the stop button to stop it. \n");
        periodcheckerthread.start();
        if (timer == null) {
          timer = new javax.swing.Timer(100,actlis);

        }
        timer.start();
      }
    } else {
      text.setText("no object found");
      timer.stop();
      periodcheckerthread.running = false;
      periodcheckerthread = null;
      checkbutton.setText("start");
    }

  }
  void checkthread(){
    if (periodcheckerthread == null) {return;}
    if (periodcheckerthread.running == false) {
      if (periodcheckerthread.period_found == true) {
        objectfound();
      }
    }
  }

  //this function is called when a ship or a oscillator is found
  void objectfound() {

    if (periodcheckerthread == null) {return;}
    
    if ((periodcheckerthread.shipdx == 0) & (periodcheckerthread.shipdy == 0)) {
        text.setText("oscillator found \n" + "its period is " + periodcheckerthread.period + "\n");
    } else {

        String str = "ship found \n";
        str = str + "it moves ";
        if (periodcheckerthread.shipdy < -1)  {str = str + (-periodcheckerthread.shipdy) + " cells up";}
        if (periodcheckerthread.shipdy == -1) {str = str + " 1 cell up";}
        if (periodcheckerthread.shipdy == 1)  {str = str + " 1 cell down";}
        if (periodcheckerthread.shipdy > 1)   {str = str + periodcheckerthread.shipdy + " cells down";}
        if ((periodcheckerthread.shipdx != 0) & (periodcheckerthread.shipdy != 0)) {
          str = str + " and ";
        }
        if (periodcheckerthread.shipdx < -1)  {str = str + (-periodcheckerthread.shipdx) + " cells left";}
        if (periodcheckerthread.shipdx == -1) {str = str + " 1 cell left";}
        if (periodcheckerthread.shipdx == 1)  {str = str + " 1 cell right";}
        if (periodcheckerthread.shipdx > 1)   {str = str + periodcheckerthread.shipdx + " cells right";}
        if (periodcheckerthread.period == 1) {
          str = str + " every period ";
        } else {
          str = str + " every " + periodcheckerthread.period + " periods ";
        }
        text.setText(str);
    }
    checkbutton.setText("start");
    periodcheckerthread = null;
  }
}
class keylistdescriptionwindowc extends JFrame {
  public JScrollPane text2; 
  public JTextArea text; 
  public JButton okbutton;
  public JButton cancelbutton;
  keylistdescriptionwindowc(String Title) {
    super(Title);
    SpringLayout spl = new SpringLayout();
    this.getContentPane().setLayout(spl);
    text = new JTextArea();
    text2 = new JScrollPane(text);
    okbutton = new JButton();
    okbutton.setText("ok");
    cancelbutton = new JButton();
    cancelbutton.setText("cancel");
    spl.putConstraint(SpringLayout.SOUTH,okbutton,-5,SpringLayout.SOUTH,this.getContentPane());
    spl.putConstraint(SpringLayout.SOUTH,cancelbutton,-5,SpringLayout.SOUTH,this.getContentPane());
    spl.putConstraint(SpringLayout.SOUTH,text2,-5,SpringLayout.NORTH,okbutton);
    spl.putConstraint(SpringLayout.WEST,cancelbutton,5,SpringLayout.EAST,okbutton);
    spl.putConstraint(SpringLayout.WEST,okbutton,5,SpringLayout.WEST,this.getContentPane());
    
    
    spl.putConstraint(SpringLayout.NORTH,text2,5,SpringLayout.NORTH,this.getContentPane());
    spl.putConstraint(SpringLayout.EAST,text2,-5,SpringLayout.EAST,this.getContentPane());
    spl.putConstraint(SpringLayout.WEST,text2,5,SpringLayout.WEST,this.getContentPane());


    okbutton.setActionCommand("keylistokbuttonclick");
    okbutton.addActionListener(cellautoapp.actlis);
    cancelbutton.setActionCommand("keylistcancelbuttonclick");
    cancelbutton.addActionListener(cellautoapp.actlis);
    this.getContentPane().add(text2);
    this.getContentPane().add(okbutton);
    this.getContentPane().add(cancelbutton);
    this.pack();  

    
  }
  void show_keys(){
    String str = "";
    str = str + "you can change the keys by selecting\n"; 
    str = str + "edit->edit the keys from the menu \n";
    str = str + "here are the keys \n";

    str = str + "space bar \n";
    str = str + "calculates the next generation\n";
    str = str + cellautokeys.pencil_tool_key + ": pencil_tool_key \n";
    str = str + "selects the pencil tool" + "\n\n";
    str = str + cellautokeys.select_tool_key + ": select_tool_key \n";
    str = str + "selects the selection tool \n\n";
    str = str + cellautokeys.move_tool_key + ": move_tool_key \n";
    str = str + "selects the move tool \n\n";
    str = str + cellautokeys.random_entry_stack_key + ": random_entry_stack_key \n";
    str = str + "changes random entries in the rule table \n\n";
    str = str + cellautokeys.save_and_clear_key + ": save_and_clear_key \n";
    str = str + "saves a generation on the stack and clears the board \n\n";
    str = str + cellautokeys.save_to_stack_key + ": save_to_stack_key \n";
    str = str + "saves a generation on the stack \n\n";
    str = str + cellautokeys.undo_key + ": undo_key\n";
    str = str + "goes back to the last generation saved \n\n";
    str = str + cellautokeys.redo_key + ": redo_key \n";
    str = str + "goes back to the current generation \n\n";
    str = str + cellautokeys.find_selection_key + ": find_selection_key \n";
    str = str + "finds the selection \n\n";
    str = str + cellautokeys.pan_mode_key + ": pan_mode_key \n";
    str = str + "switches pan mode on or off \n\n";
    str = str + cellautokeys.xor_mode_key + "xor_mode_key\n";
    str = str + "switches xor mode on or off  \n\n";
    str = str + cellautokeys.prev_color_key + ": prev_color_key \n";
    str = str + "selects the previous state \n\n";
    str = str + cellautokeys.next_color_key + ": next_color_key \n";
    str = str + "selects the next state \n\n";
    str = str + cellautokeys.prev_tool_key + ": prev_tool_key \n";
    str = str + "selects the previous tool \n\n";
    str = str + cellautokeys.next_tool_key + ": next_tool_key \n";
    str = str + "selects the next tool \n\n";
    str = str + cellautokeys.calc_key + ": calc_key \n";
    str = str + "calculates the next generations \n\n";
    str = str + cellautokeys.calc_key2 + ": calc_key2 \n"; 
    str = str + "calculates the next generations \n\n";

    text.setText(str);
  }
}
class editdescriptionwindowc extends JFrame {
  public JScrollPane text2; 
  public JTextArea text; 
  public JButton okbutton;
  public JButton cancelbutton;
  editdescriptionwindowc(String Title){
    super(Title);
    SpringLayout spl = new SpringLayout();
    this.getContentPane().setLayout(spl);
    text = new JTextArea();
    text2 = new JScrollPane(text);
    okbutton = new JButton();
    okbutton.setText("ok");
    cancelbutton = new JButton();
    cancelbutton.setText("cancel");
    //spl.putConstraint(SpringLayout.SOUTH,text2,-5,SpringLayout.NORTH,okbutton);
    spl.putConstraint(SpringLayout.SOUTH,okbutton,-5,SpringLayout.SOUTH,this.getContentPane());
    spl.putConstraint(SpringLayout.SOUTH,cancelbutton,-5,SpringLayout.SOUTH,this.getContentPane());
    spl.putConstraint(SpringLayout.SOUTH,text2,-5,SpringLayout.NORTH,okbutton);
    spl.putConstraint(SpringLayout.WEST,cancelbutton,5,SpringLayout.EAST,okbutton);
    spl.putConstraint(SpringLayout.WEST,okbutton,5,SpringLayout.WEST,this.getContentPane());
    spl.putConstraint(SpringLayout.NORTH,text2,5,SpringLayout.NORTH,this.getContentPane());
    spl.putConstraint(SpringLayout.EAST,text2,-5,SpringLayout.EAST,this.getContentPane());
    spl.putConstraint(SpringLayout.WEST,text2,5,SpringLayout.WEST,this.getContentPane());

    okbutton.setActionCommand("descriptionokbuttonclick");
    okbutton.addActionListener(cellautoapp.actlis);
    cancelbutton.setActionCommand("descriptioncancelbuttonclick");
    cancelbutton.addActionListener(cellautoapp.actlis);
    text.setText(cellautoapp.cellauto131.description);
    this.getContentPane().add(text2);
    this.getContentPane().add(okbutton);
    this.getContentPane().add(cancelbutton);
    this.pack();  

    
  }
  void okbuttonclick(){
    cellautoapp.cellauto131.description = text.getText();
    setVisible(false);
  }
  void cancelbuttonclick(){
    setVisible(false);
  }
}

class ToolBar_Action extends AbstractAction{
  static Vector toolbar_list = null;
  String name;
  ToolBar_Action(String name2, Icon icon, String description) {
    if (toolbar_list == null) {
      toolbar_list = new Vector();
    }	    
    this.name = name2;
    putValue(Action.NAME, name2);
    putValue(Action.SMALL_ICON, icon);
    putValue(Action.SHORT_DESCRIPTION, description);
    toolbar_list.add(this);
  }
  String get_name() {
    return name;
  }
  void set_name(String n) {
    putValue(Action.NAME, n);    
    name = n;
  }
  public void actionPerformed(ActionEvent event) {  
    String name = (String) getValue(Action.NAME);
    System.out.println(name);
    if (name.equals("new")) {
      cellautoapp.newgamedialog.setVisible(true);
    }
    if (name.equals("open")) {
      cellautoapp.open2();
    }
    if (name.equals("save")) {
      cellautoapp.save2();
    }
    if (name.equals("pencil")) {
      cellautoapp.toollistindex = cellautoapp.PENCIL_TOOL;
      cellautoapp.toolbox.pencilbutton.setSelected(true);
      cellautoapp.updatestatusbar();
    }
    if (name.equals("selection")) {
      cellautoapp.toollistindex = cellautoapp.SELECT_TOOL;
      cellautoapp.toolbox.selectbutton.setSelected(true);
      cellautoapp.updatestatusbar();
    }
    
    if (name.equals("stop")) {
      cellautoapp.stop();
    }
    if (name.equals("run")) {
      cellautoapp.run();
    }
    if (name.equals("step")) {
      cellautoapp.calc(1,true);
    }
    if (name.equals("undo")) {
      if (cellautoapp.cellautothread.running == true){
        cellautoapp.stop();
        cellautothreadc.undoevent = true;
      } else {
        cellautoapp.undo();
      }
    }
    if (name.equals("redo")) {
      cellautoapp.redo();
    }
    if (name.equals("addundo")) {
      boardstate.s = 1;
      cellautoapp.updatestatusbar();
    }
    if (name.equals("zoomin")) {
      int x = cellautoapp.offsetx + (cellautoapp.cellautomainwindow.getWidth()/(cellautomainwindowc.sqsize*2));
      int y = cellautoapp.offsety + (cellautoapp.cellautomainwindow.getHeight()/(cellautomainwindowc.sqsize*2));
      cellautoapp.zoom(x,y,cellautoapp.ZOOM_IN);
      cellautoapp.cellautomainwindow.repaint();
    }
    if (name.equals("zoomout")) {
      int x = cellautoapp.offsetx + (cellautoapp.cellautomainwindow.getWidth()/(cellautomainwindowc.sqsize*2));
      int y = cellautoapp.offsety + (cellautoapp.cellautomainwindow.getHeight()/(cellautomainwindowc.sqsize*2));
      cellautoapp.zoom(x,y,cellautoapp.ZOOM_OUT);
      cellautoapp.cellautomainwindow.repaint();
    }
    if (name.equals("select_all")) {
      cellautoapp.select_all();
    }
    if (name.equals("select_center")) {
        cellautoapp.find_selection();
    }
    if (name.equals("select_rand")) {
      cellautoapp.randomize_selection();
      cellautoapp.cellautomainwindow.repaint();
    }
    if (name.equals("select_fill")) {
      for (int x = 0;x < cellautoapp.selw;x++) {
        for (int y = 0;y < cellautoapp.selh;y++) {
          cellautoapp.seldata[x][y] = cellautoapp.colorlistindex;
        }
      }
      cellautoapp.cellautomainwindow.repaint();
    }
    if (name.equals("flipy")) {
      cellautoapp.flipy();
      cellautoapp.cellautomainwindow.repaint();
    }
    if (name.equals("flipx")) {
      cellautoapp.flipx();
      cellautoapp.cellautomainwindow.repaint();
    }
    if (name.equals("rotatecc")) {
      cellautoapp.rotatec();
      cellautoapp.cellautomainwindow.repaint();
    }
    if (name.equals("rotatec")) {
      cellautoapp.rotatecc();
      cellautoapp.cellautomainwindow.repaint();
    }
    if (name.equals("clear_selection")) {
      //int option = JOptionPane.showConfirmDialog(cellautoapp.cellautowindowframe,new JLabel("clear the selection?"),"question",JOptionPane.YES_NO_OPTION,JOptionPane.QUESTION_MESSAGE);
      //if (option == JOptionPane.YES_OPTION) { 
        //cellautoapp.saveboard();
        for (int x = 0;x < cellautoapp.selw;x++) {
          for (int y = 0;y < cellautoapp.selh;y++) {
            cellautoapp.seldata[x][y] = 0;
          }
        }
      //}
      cellautoapp.cellautomainwindow.repaint();
    }
    if (name.equals("clear_outside_selection")) {
      //int option = JOptionPane.showConfirmDialog(cellautoapp.cellautowindowframe,new JLabel("clear outside the selection?"),"question",JOptionPane.YES_NO_OPTION,JOptionPane.QUESTION_MESSAGE);
      //if (option == JOptionPane.YES_OPTION) { 
        //cellautoapp.saveboard();
        cellautoapp.board = new boardc(cellautoapp.board.width,cellautoapp.board.height);
        cellautoapp.board2 = new boardc(cellautoapp.board);
        if (cellautoapp.cellauto131.rulefamily != null) {
          cellautoapp.board.background_tile_sub_board = new simpleboardc(
          cellautoapp.cellauto131.rulefamily.get_background_tile_width(),
          cellautoapp.cellauto131.rulefamily.get_background_tile_height());
        } else {
          cellautoapp.board.background_tile_sub_board = new simpleboardc(1,1);
        }
        cellautoapp.updatestatusbar();
        cellautoapp.cellautomainwindow.repaint();
      //}
    }
    cellautoapp.cellautowindowframe.requestFocusInWindow();
    
  }
}
