import java.lang.*;
import java.util.*;
import java.io.*;

import javax.swing.*;                                           
import java.awt.*;
import java.awt.event.*;                                                  
import java.awt.Toolkit.*;
import java.awt.datatransfer.*;
import java.awt.image.*;

class abstractcellautorulefamily {
  static HashMap rulefamilies = new HashMap();
  String name = null;
  static int NEIGHBORHOOD_3X3 = 1;
  static int NEIGHBORHOOD_5X5 = 2;
  Vector args = null;
  static rulefamilyactlisc actlis = new rulefamilyactlisc();
  abstractcellautorulefamily(String name) {
    this.name = name;
  }

  // getbordersize returns the neighborhood size
  // the number 1 is a 3x3 neighborhood size
  // the number 2 is a 5x5 neighborhood size
  // the number 3 is a 7x7 neighborhood size
  // the number 4 is a 9x9 neighborhood size
  // etc
  int getbordersize() {
    //return a 21x21 neighborhood size by default
    return 10;
    //return cellautoapp.cellauto131.bordersize;
  }
  //int getdfcolor(cellautorulec c,int a){
    //return 0;
  //}
  boolean is_cell_auto_optimization_on() {
    return true;
  }
  boolean is_background_tile_optimization_on() {
    return false;
  }
  int get_background_tile_width() {
    return 8;
  }
  int get_background_tile_height() {
    return 8;
  }
  
  //showoptions can be override to display a dailog box with options
  void showoptions(){
    JOptionPane.showMessageDialog(cellautoapp.cellautowindowframe,new JLabel("this rule family does not have a options window"),"error",JOptionPane.ERROR_MESSAGE);  
  }
  
  //readline reads a line from a file
  void readline(String str){
     String ss[] = str.split(",");
     String st = ss[0];
     cellautorulec c = cellautoapp.cellauto131;
     if (st.equals("cellvalue")){
       int i = Integer.valueOf(ss[1]).intValue();
       int i2 = Integer.valueOf(ss[2]).intValue();
       c.setcellvalue(i,i2);
     }
        
    if (st.equals("cellvaluecolor")){
      int i = Integer.valueOf(ss[1]).intValue();
      int red = Integer.valueOf(ss[2]).intValue();
      int green = Integer.valueOf(ss[3]).intValue();
      int blue = Integer.valueOf(ss[4]).intValue();
      c.setcellvaluecolor(i,new Color(red,green,blue));
    }    
    if (st.equals("numcolors")){
      int i = Integer.valueOf(ss[1]).intValue();
      c.setnumcolors(i);
    }
    if (st.equals("seednumcolors")){
      int i = Integer.valueOf(ss[1]).intValue();
      cellautoapp.seednumcolors = i;
    }
    if (st.equals("tableoffset")){
      //read the table offset
      int a = Integer.valueOf(ss[1]).intValue();
      c.writetableoffset(a);
    }
  }

  //writelines writes some lines to a vector 
  //that's written to a file
  void writelines(Vector lines){
    
  }

  //returns the name of the rule family
  String getname(){
    return name;
  }
  void clearargs(){
    if (args == null){args = new Vector();}
    args.clear();
  }
  int getnumargs(){
    if (args == null){return 0;}
    return args.size();
  }
  String getarg(int i){
    return (String) args.get(i);
  }
  void addarg(String arg){
    if (args == null){args = new Vector();}
    args.add(arg);
  }
  
  //calcsq calculates a cell's next state
  //Parameters:
  //  c: the cellular automaton rule to use
  //  b: the board the cell is on
  //  x: the cell's x position
  //  y: the cell's y position
  //  t: how many generations passed by
  //Returns:
  //  the cell's next state
  int calcsq(cellautorulec c,boardc b,int x,int y,int t){
    return 0;
  }
  void addrulefamily(){
    rulefamilies.put(this.name,this);
  }

  // getrulefamilylist returns a list of the available rule families
  static Vector getrulefamilylist() {
    Vector v = new Vector();
    v.add("-- null");
    v.add("vote");
    v.add("generation_neighborhood");
    v.add("margolus");
    v.add("cyclic");
    v.add("cell_auto_1d");
    v.add("ca_music");
    v.add("margolus_ant");
    v.add("margolus2");
    v.add("particle_streams");
    v.add("diagonal_particle_streams");
    v.add("interacting_states");
    v.add("symmetry_neighborhood");
    return v;
  }
  int get_min_table_width() {
    return 2;
  }
  int get_min_colors() {
    return 2;
  }
  void update_new_color(cellautorulec c,int i) {
    
  }
  //getrulefamily creates a new rule family 
  //Parameters:
  //  name: what rule family to create
  //returns:
  //  the new rule family or null if the rule family does not exist
  static abstractcellautorulefamily getrulefamily(String name) {
    //abstractcellautorulefamily c = null;
    System.out.println("rule family name: " + name);
    if (name.equals("-- null")){
      return null;
    }
    if (name.equals("ant43")) {
      return new margolus_ant43_rulefamilyc(name);
    }
    if (name.equals("ca_music")) {
      return new ca_music_rule_family(name);
    }
    if (name.equals("margolus2")) {
      return new margolus2_rulefamilyc(name);
    }
    if (name.equals("margolus_ant")) {
      return new margolus_ant_rulefamilyc(name);
    }
    if (name.equals("margolus_ant_sum")) {
      return new margolus_ant_sum_rulefamilyc(name);
    }
    if (name.equals("jc_margolus")){
      return new jc_margolus_rulefamilyc(name);
    }
    if (name.equals("jc_average")) {
      return new jc_average_rulefamilyc(name);
    }
    if (name.equals("jc_average4")) {
      return new jc_average4_rulefamilyc(name);
    }
    if (name.equals("jc_margolus_tot5")) {
      return new jc_margolus_tot5_rulefamilyc(name);
    }
    if (name.equals("jc_margolus_rug6")) {
      return new jc_margolus_rug6_rulefamilyc(name);
    }
    if (name.equals("jc_margolus_sum5")) {
      return new jc_margolus_sum5_rulefamilyc(name);
    }
    if (name.equals("jc_margolus_sum8")) {
      return new jc_margolus_sum8_rulefamilyc(name);
    }
    if (name.equals("jc_cycle")) {
      return new jc_cycle_rulefamilyc(name);
    }
    if (name.equals("jc_switch")) {
      return new jc_switch_rulefamilyc(name);
    }
    if (name.equals("jc_vonn2")) {
      return new jc_vonn2_rulefamilyc(name);
    }
    if (name.equals("jc_vonn3")) {
      return new jc_vonn3_rulefamilyc(name);
    }
    if (name.equals("jc_langton")) {
      return new jc_langton_rulefamilyc(name);
    }
    if (name.equals("rug_avereging")) {
      return new rug_avereging_rulefamilyc(name);
    }
    if (name.equals("vote")) {
      return new voterulefamilyc(name);
    }
    if (name.equals("generation_neighborhood")) {
      return new generationneighborhoodrulefamilyc(name);
    }
    if (name.equals("margolus")) {
      return new margolusneighborhoodrulefamilyc(name);
    }
    if (name.equals("cyclic")) {
      return new cycliccarulefamilyc(name);
    }
    if (name.equals("square_or_diamond36")) {
      return new squareordiamondrulefamilyc(name,36);
    }
    if (name.equals("square_or_diamond40")) {
      return new squareordiamondrulefamilyc(name,40);
    }
    if (name.equals("cell_auto_1d")) {
      return new ca1drulefamilyc(name);
    }
    if (name.equals("particle_streams")){ 
      return new ParticleStreamsRule(name);
    }
    if (name.equals("diagonal_particle_streams")){ 
      return new DiagonalParticleStreamsRule(name); 
    } 
    if (name.equals("interacting_states")){ 
      return new InteractingStatesRule(name); 
    } 
    if (name.equals("symmetry_neighborhood")) {
      return new symmetry_neighborhood_rule_familyc(name);
    }
    return (abstractcellautorulefamily) rulefamilies.get(name);
  }
  void create_neighborhood_image(int table_sqsize) {}
  Image get_neighborhood_image() {
    return null;
  }
}






class symmetry_neighborhood_rule_familyc extends abstractcellautorulefamily {
  byte neighborhood_index_table[] = new byte[256];
  byte flip4bits[] = {0,8,4,12,2,10,6,14,1,9,5,13,3,11,7,15};  
  byte flip3bits[] = {0,4,2,6,1,5,3,7};
  short sym_neighborhoods[] = {0,64,128,80,68,192,72,160,136,84,208,112,82,196,224,200,
                              194,74,168,85,212,116,216,228,240,204,180};
  BufferedImage neighborhood_image = null;
  symmetry_neighborhood_rule_familyc(String name) {
    super(name);
    for (int i = 0;i < sym_neighborhoods.length;i++) {
      int b = sym_neighborhoods[i];
      for (int i2 = 0;i2 < 4;i2++) {
        neighborhood_index_table[b] = (byte) i;
	b = rotate_byte(b);
      }
      b = flip_byte(b);
      for (int i2 = 0;i2 < 4;i2++) {
        neighborhood_index_table[b] = (byte) i;
	b = rotate_byte(b);
      }
      if (i < 24) {
        b = ~b & 255;
        for (int i2 = 0;i2 < 4;i2++) {
          neighborhood_index_table[b] = (byte) (50-i);
	  b = rotate_byte(b);
        }        
        b = flip_byte(b);
        for (int i2 = 0;i2 < 4;i2++) {
          neighborhood_index_table[b] = (byte) (50-i);
	  b = rotate_byte(b);
        }        
      }
    }
  }
  int get_min_table_width() {
    return 51;
  }
  boolean is_background_tile_optimization_on() {
    return true;
  }
  void create_neighborhood_image() {
    int tsq = edittablepanelc.sqsize;
    neighborhood_image = new BufferedImage(tsq*51,tsq,BufferedImage.TYPE_BYTE_GRAY);
    //neighborhood_image = createImage(table_sqsize*51,table_sqsize);
    Graphics2D g = neighborhood_image.createGraphics();
    int s = (tsq-1)/3;
    for (int i = 0;i < 51;i++) {
      int n = 0;
      if (i <= 26) {n = sym_neighborhoods[i];}
      else {
        n = ~sym_neighborhoods[50-i] & 255;
      }
      g.setColor(Color.white);
      if ((n & 1) == 1) {g.fillRect((i*tsq)+1,s+1,s,s);}
      if (((n>>1)&1)==1){g.fillRect((i*tsq)+1,1,s,s);}
      if (((n>>2)&1)==1){g.fillRect((i*tsq)+s+1,1,s,s);}
      if (((n>>3)&1)==1){g.fillRect((i*tsq)+s+s+1,1,s,s);}
      if (((n>>4)&1)==1){g.fillRect((i*tsq)+s+s+1,s+1,s,s);}
      if (((n>>5)&1)==1){g.fillRect((i*tsq)+s+s+1,s+s+1,s,s);}
      if (((n>>6)&1)==1){g.fillRect((i*tsq)+s+1,s+s+1,s,s);}
      if (((n>>7)&1)==1){g.fillRect((i*tsq)+1,s+s+1,s,s);}
    }
  }
  Image get_neighborhood_image() {
    if (neighborhood_image == null) {create_neighborhood_image();}
    return neighborhood_image;
  }
  
  int flip_byte(int b) {
    int b2 = (flip3bits[((b >> 5) & 7)] << 1); 
    b2 = b2 | (flip3bits[((b >> 1) & 7)] << 5);    
    return b2 | (b & 17);
  }
  //int flip_byte(int b) {    
    //return (flip4bits[b & 15] << 4) | flip4bits[b >> 4];
  //}
  int rotate_byte(int b) {
    return (((b >> 6) | (b << 2)) & 255);
  }
  int getbordersize(){
    return abstractcellautorulefamily.NEIGHBORHOOD_3X3;
  }
  int getdfcolor(cellautorulec c,int a){
    return 0;
  }
  int get_background_tile_width() {
    return 1;
  }
  int get_background_tile_height() {
    return 1;
  }

  int calcsq(cellautorulec c,boardc b,int x,int y,int t){
    int sq = b.getsq(x,y);
    int sum = 0;
    sum = c.cellvalue[b.getsq(x-1,y+1)];
    sum = sum + sum + c.cellvalue[b.getsq(x,y+1)];
    sum = sum + sum + c.cellvalue[b.getsq(x+1,y+1)];
    sum = sum + sum + c.cellvalue[b.getsq(x+1,y)];
    sum = sum + sum + c.cellvalue[b.getsq(x+1,y-1)];
    sum = sum + sum + c.cellvalue[b.getsq(x,y-1)]; 
    sum = sum + sum + c.cellvalue[b.getsq(x-1,y-1)];
    sum = sum + sum + c.cellvalue[b.getsq(x-1,y)];
    
    while (sum >= 256) {
      sum = (sum & 255) + (sum >> 8);
    }
    //sum = (sum & 255) + (sum >> 8);
    
    return c.getlookuptable(neighborhood_index_table[sum],sq);     
  }
  //void draw_neighborhood(rectangle_listc l) {
    
  //}
  
}

class squareordiamondrulefamilyc extends abstractcellautorulefamily{
  int type;
  squareordiamondrulefamilyc(String name,int t){
    super(name);
    this.type = t;
    
  }
  int getbordersize(){
    return abstractcellautorulefamily.NEIGHBORHOOD_5X5;
  }
  int getdfcolor(cellautorulec c,int a){
    return 0;
  }
  int get_background_tile_width() {
    return 1;
  }
  int get_background_tile_height() {
    return 1;
  }

  int calcsq(cellautorulec c,boardc b,int x,int y,int t){
    int sum = 0;
    int sum2 = 0;
    int sum3 = 0;
    int sq = b.getsq(x,y);
    int t2 = 0;
    if (type == 36){
      sum = calc36(c,b,x,y,sq);
      if ((sum == (8*c.cellvalue[0])) & (sq == 0)){return 0;}
      return c.getlookuptable(sum,sq);
    }
    for (int dx = -1;dx <= 1;dx = dx + 2){
      for (int dy = -1;dy <= 1;dy = dy + 2){
        sum = sum + c.cellvalue[b.getsq(x+dx,y+dy)];
      }
    }
    for (int dx = -1;dx <= 1;dx++){
      if (dx == 0){
        for (int dy = -1;dy <= 1;dy = dy + 2){
          sum2 = sum2 + (c.cellvalue[b.getsq(x+dx,y+dy)]);
        }
      }else{
        sum2 = sum2 + c.cellvalue[b.getsq(x+dx,y)];
      }
    }
    for (int dx = -2;dx <= 2;dx = dx + 2){
      if (dx == 0){
        for (int dy = -2;dy <= 2;dy = dy + 4){
          sum3 = sum3 + (c.cellvalue[b.getsq(x+dx,y+dy)]);
        }
      }else{
        sum3 = sum3 + (c.cellvalue[b.getsq(x+dx,y)]);
      }
    }
    if (sq == 0){
      sum = sum + (sum2 * 5);
      t2 = sum3;
    }else{
      if ((sq & 1) == 1){
        sum = sum + (sum2 * 5);
      }else{
        sum = (sum * 5) + sum3;
      }
      t2 = sq + 4;
    }
    if ((sum == (8*c.cellvalue[0])) & (t2 == (4*c.cellvalue[0]))){return 0;}
    return c.getlookuptable(sum,t2);
    
  }
  int calc36(cellautorulec c,boardc b,int x,int y,int sq){
    int sum = 0;
    for (int dx = -1;dx <= 1;dx = dx + 2){
      for (int dy = -1;dy <= 1;dy = dy + 2){
        int i = b.getsq(x+dx,y+dy);
        sum = sum + c.cellvalue[i];
      }
    }
    sum = sum + ((c.cellvalue[b.getsq(x-1,y)] | c.cellvalue[b.getsq(x-2,y)]) * 5);
    sum = sum + ((c.cellvalue[b.getsq(x+1,y)] | c.cellvalue[b.getsq(x+2,y)]) * 5);
    sum = sum + ((c.cellvalue[b.getsq(x,y-1)] | c.cellvalue[b.getsq(x,y-2)]) * 5);
    sum = sum + ((c.cellvalue[b.getsq(x,y+1)] | c.cellvalue[b.getsq(x,y+2)]) * 5);
    return sum;
  }  
}



class cycliccarulefamilyc extends abstractcellautorulefamily{
  byte nextcellvalue[] = new byte[255];
  cycliccarulefamilyc(String name){
    super(name);
    for (int i = 0;i < cellautoapp.cellauto131.numcolors;i++){
      nextcellvalue[i] = 0;
    }
    nextcellvalue[1] = 1;
  }
  int get_background_tile_width() {
    return 1;
  }
  int get_background_tile_height() {
    return 1;
  }
  int getbordersize(){
    return cellautoapp.cellauto131.bordersize;
  }

  void readline(String str){
     String ss[] = str.split(",");
     String st = ss[0];
     if (st.equals("nextcellvalue")){
       int i = Integer.valueOf(ss[1]).intValue();
       int i2 = Integer.valueOf(ss[2]).intValue();
       nextcellvalue[i] = (byte) i2;
     }
     super.readline(str);
  }
  void writelines(Vector lines){
    for (int i = 0;i < cellautoapp.cellauto131.numcolors;i++){
      int i2 = 0;
      if (i == 1){i2 = 1;}
      if (nextcellvalue[i] != i2){
      lines.add("nextcellvalue," + nextcellvalue[i]);
      }
    }
  }
  int getdfcolor(cellautorulec c,int a){
    return c.getlookuptable(c.bordersum*nextcellvalue[0],a);
  }
  int calcsq(cellautorulec c,boardc b,int x,int y,int t){
    int sum = c.readtableoffset();
    int sq = b.getsq(x,y);
    for (int dx = -c.bordersize;dx <= c.bordersize;dx++){
      for (int dy = -c.bordersize;dy <= c.bordersize;dy++){
        int i = b.getsq(x+dx,y+dy) - sq;
        if (i < 0){i = i + c.numcolors;}
        sum = sum + (nextcellvalue[i] * c.bordervalue[dx+c.bordersize][dy+c.bordersize]);
      }
    }
    if (c.lookuptableallused == false){
      c.setlookuptableused(sum,sq,1);
    }
    return c.getlookuptable(sum,sq);
  }
}

class ca1dneighborhooddailogboxc extends JFrame{
  ca1drulefamilyc c = null;
  JLabel neighborhoodlabel;
  JTextField neighborhoodedit;
  JCheckBox calc_one_row_checkbox;
  JButton okbutton;
  JButton cancelbutton;
  ca1dneighborhooddailogboxc(String Title) {
    super(Title);
    GridBagLayout gl = new GridBagLayout();
    this.getContentPane().setLayout(gl);
    GridBagConstraints cc = new GridBagConstraints();

    cc.fill = GridBagConstraints.BOTH;
    cc.weightx = 1.0;
    cc.weighty = 1.0;
    

    neighborhoodlabel = new JLabel();
    neighborhoodlabel.setText("neighborhood weights");
    cc.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(neighborhoodlabel, cc);
    this.getContentPane().add(neighborhoodlabel);
    
    neighborhoodedit = new JTextField();
    neighborhoodedit.setText("0");
    cc.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(neighborhoodedit, cc);
    this.getContentPane().add(neighborhoodedit);
    
    calc_one_row_checkbox = new JCheckBox();
    calc_one_row_checkbox.setText("calculate one row at a time");
    calc_one_row_checkbox.setSelected(false);
    cc.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(calc_one_row_checkbox, cc);
    this.getContentPane().add(calc_one_row_checkbox);
    
    
    okbutton = new JButton();
    okbutton.setText("ok");
    okbutton.setActionCommand("ca1Dokbuttonclick");
    okbutton.addActionListener(abstractcellautorulefamily.actlis);
    cc.gridwidth = 2;
    gl.setConstraints(okbutton, cc);
    this.getContentPane().add(okbutton);

    cancelbutton = new JButton();
    cancelbutton.setText("cancel");
    cancelbutton.setActionCommand("ca1Dcancelbuttonclick");
    cancelbutton.addActionListener(abstractcellautorulefamily.actlis);
    cc.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(cancelbutton, cc);
    this.getContentPane().add(cancelbutton);
    this.pack();
  }
  void okbuttonclick() {
    String str = neighborhoodedit.getText();
    String ss[] = str.split(",");
    for (int i = 0;i < ss.length;i++){
      ss[i] = ss[i].trim();
    }
    int l = ss.length;
    if ((l & 1) == 1) {
      l = l - 1;
    }
    l = l / 2;
    if (l == 0){l = 1;}
    c.clear_neighborhood(l);
    for (int i = 0;i < ss.length;i++){
      c.set_neighborhood_value(i,Integer.valueOf(ss[i]).intValue());
    }
    cellautoapp.calc_one_row = calc_one_row_checkbox.isSelected();
    this.setVisible(false);
  }
  
  void cancelbuttonclick() {
    this.setVisible(false);
  }
}

class ca_music_rule_family extends abstractcellautorulefamily{
  ca_music_rule_family(String name) {
    super(name);
    cellautoapp.calc_one_row = true;
  }
  int calcsq(cellautorulec c,boardc b,int x,int y,int t){
    int sq = b.getsq(x,y-1);
    int sq2 = 0;
    int sum = 0;
    if (b.getsq(x-2,y-1) > 0) {sum = sum | 1;}
    if (b.getsq(x-1,y-1) > 0) {sum = sum | 2;}
    if (b.getsq(x+1,y-1) > 0) {sum = sum | 4;}
    if (b.getsq(x+2,y-1) > 0) {sum = sum | 8;}
    if (sq == 0) {
      sq2 = c.getlookuptable(sum,0);
    } else {
      sq2 = c.getlookuptable(sum,1);
    }
    return sq2;
  }
  int getbordersize(){
    return 2;
  }
}

class ca1drulefamilyc extends abstractcellautorulefamily{
  int neighborhood1dvalue[];
  int neighborhood1dsize = 1;
  int neighborhood1dsum = 2;
  static ca1dneighborhooddailogboxc ca1dneighborhooddailogbox;
  ca1drulefamilyc(String name) {
    super(name);
    neighborhood1dvalue = new int[3];
    neighborhood1dsize = 1;
    neighborhood1dvalue[0] = 1;
    neighborhood1dvalue[1] = 0;
    neighborhood1dvalue[2] = 1;
    neighborhood1dsum = 2;
  }
  void clear_neighborhood(int size) {
    neighborhood1dsize = size;
    neighborhood1dvalue = new int[(size*2)+1];
    neighborhood1dsum = 0;
  }
  void set_neighborhood_value(int i,int i2) {
    neighborhood1dvalue[i] = i2;
  }
  int get_neighborhood_value(int i){
    return neighborhood1dvalue[i];
  }
  int get_background_tile_width() {
    return 1;
  }
  int get_background_tile_height() {
    return 1;
  }
  void readline(String str) {
     String ss[] = str.split(",");
     String st = ss[0];
     if (st.equals("cellvalue")){
       int i = Integer.valueOf(ss[1]).intValue();
       int i2 = Integer.valueOf(ss[2]).intValue();
       cellautoapp.cellauto131.setcellvalue(i,i2);
       return;
     }
     if (st.equals("clearborder1d")){
       neighborhood1dsize = Integer.valueOf(ss[1]).intValue();
       neighborhood1dvalue = new int[(neighborhood1dsize*2)+1];
       neighborhood1dsum = 0;
       return;
     }
     if (st.equals("border1d")){
       int i = 1;
       while (i < ss.length){
         int i2 = Integer.valueOf(ss[i]).intValue();
         neighborhood1dsum = (neighborhood1dsum - neighborhood1dvalue[i-1]) + i2;
         neighborhood1dvalue[i-1] = i2;
         i++;
         
       }
       return;
     }
     super.readline(str);
  }
  void writelines(Vector lines){
     lines.add("clearborder1d,"+neighborhood1dsize);
     String str = "border1d";
     for (int i = -neighborhood1dsize;i <= neighborhood1dsize;i++){
       str = str + "," + neighborhood1dvalue[i+neighborhood1dsize];
     }
     lines.add(str);
  }  
  //shows a dailog box that lets you edit the value of each neighbor
  void showoptions(){
    if (ca1dneighborhooddailogbox == null){
      ca1dneighborhooddailogbox = new ca1dneighborhooddailogboxc("neighborhood weights");
      ca1dneighborhooddailogbox.setBounds(0,0,400,250);
    }
    String str = "";
    for (int i = -neighborhood1dsize;i <= neighborhood1dsize;i++){
      if ((i+neighborhood1dsize) > 0){
        str = str + ",";
      }
      str = str + neighborhood1dvalue[i+neighborhood1dsize];
    }   
    ca1dneighborhooddailogbox.neighborhoodedit.setText(str);
    ca1dneighborhooddailogbox.c = this;
    ca1dneighborhooddailogbox.calc_one_row_checkbox.setSelected(cellautoapp.calc_one_row);
    ca1dneighborhooddailogbox.setVisible(true);
  }
  int getdfcolor(cellautorulec c,int a){
    //return c.getlookuptable(neighborhood1dsum * c.cellvalue[a],a);
    return 0;
  }                     
  int calcsq(cellautorulec c,boardc b,int x,int y,int t){
    int sq2 = b.getsq(x,y);
    if ((sq2 == 0) | (cellautoapp.calc_one_row == true)) {
      int sq = b.getsq(x,y-1);
      int sum = c.readtableoffset();
      for (int i = -neighborhood1dsize;i <= neighborhood1dsize;i++){
         sum = sum + c.cellvalue[b.getsq(x+i,y-1)] * neighborhood1dvalue[i+neighborhood1dsize];
      }
      if (c.lookuptableallused == false){
        c.setlookuptableused(sq,sum,1);
      }
      if ((sum == (neighborhood1dsum * c.cellvalue[0])) & (sq == 0)){
        sq2 = 0;
      }else{
        sq2 = c.getlookuptable(sum,sq);
      }
    }
    return sq2;
  }
  int getbordersize(){
    return neighborhood1dsize;
  }

}








class generationneighborhoodrulefamilyc extends abstractcellautorulefamily{
  int neighborhood[][] = new int[5][5];
  boolean test45 = false;
  byte cellvalue[] = new byte[256];
  byte cellvalue2[] = new byte[256];

  generationneighborhoodrulefamilyc(String name){
    super(name);
    neighborhood = new int[5][5];
    for (int i = 0;i < 256;i++){
      cellvalue[i] = 0;
      cellvalue2[i] = (byte) (i & 1);
    }
    cellvalue[2] = 1;
    cellvalue[3] = 1;
  }
  int get_background_tile_width() {
    return 1;
  }
  int get_background_tile_height() {
    return 1;
  }
  void readline(String str){
    String ss[] = str.split(",");
    String st = ss[0];
    if (st.equals("cellvalue")){
      int i = Integer.valueOf(ss[1]).intValue();
      int i2 = Integer.valueOf(ss[2]).intValue();
      int i3 = Integer.valueOf(ss[3]).intValue();
      cellvalue[i] = (byte) i2;
      cellvalue2[i] = (byte) i3;
      return;
    }

    if (str.equals("test")){
      test45 = true;
    }
  }
  void writelines(Vector lines){
    for (int i = 0;i < cellautoapp.cellauto131.numcolors;i++){
      int i2 = 0;
      if (i == 2){i2 = 1;}
      if (i == 3){i2 = 1;}
      if ((cellvalue[i] != i2) | (cellvalue2[i] != (i & 1))){
        lines.add("cellvalue," + i + "," + cellvalue[i] + "," + cellvalue2[i]);
      }
    }
    if (test45){
      lines.add("test");
    }
  }  
  int getbordersize(){
    return abstractcellautorulefamily.NEIGHBORHOOD_5X5;
  }
  //int get_background_tile_width() {
  //  return 1;
  //}
  //int get_background_tile_height() {
  //  return 1;
  //}

  //int getdfcolor(cellautorulec c,int a){
  //  return c.getlookuptable(((cellvalue[a]*8)+(cellvalue2[a]*24)),a);
  //}
  int calcsq(cellautorulec c,boardc b,int x,int y,int t){
    int popcount = c.readtableoffset();
    int celltype = 0;
    for (int dx = -2;dx <= 2;dx++){ 
      for (int dy = -2;dy <= 2;dy++){
        int i = b.getsq(x+dx,y+dy);
        neighborhood[dx+2][dy+2] = i;
        //if ((i & 1) == 1){popcount = popcount + 1;}
        popcount = popcount + cellvalue2[i];
      }
    }
    for (int dx = -1;dx <= 1;dx++){ 
      for (int dy = -1;dy <= 1;dy++){
        int i = neighborhood[dx+2][dy+2];
        if ((dx == 0) & (dy == 0)){
          celltype = i;
        }else{
          //if ((i == 2) | (i == 3)){
            //popcount = popcount + 1;
          //}c.cellvalue
          popcount = popcount + c.cellvalue[i];
        }
      }
    }
    if (c.lookuptableallused == false){
      c.setlookuptableused(popcount,celltype,1);
    }
    //if (celltype == 0){
    //  if (popcount == ((cellvalue[0]*8)+(cellvalue2[0]*24))){
    //    return 0;
    //  }
    //}
    return c.getlookuptable(popcount,celltype);
  }
  void load_cell_values(cellautorulec c) {
    for (int i = 0;i < 255;i++){
      c.cellvalue[i] = cellvalue[i];
    }
  }
}


class voterulefamilyc extends abstractvoterulefamilyc {
  voterulefamilyc(String name) {
    super(name);
  }
  int vote(cellautorulec c,boardc b,int x,int y,int t){
    int n = 0;
    for (int dx = -1;dx <= 1;dx++){ 
      for (int dy = -1;dy <= 1;dy++){
        int c2 = b.getsq(x+dx,y+dy) & 1;
        n = n + c2;
      }
    }
    if (n >= 5){
      return 1;
    }
    return 0;    
  }
}


class abstractvoterulefamilyc extends abstractcellautorulefamily {
  abstractvoterulefamilyc(String name) {
    super(name);
  }
  int vote(cellautorulec c,boardc b,int x,int y,int t){
    return b.getsq(x,y) & 1;
  }
  int calcsq(cellautorulec c,boardc b,int x,int y,int t){
    int celltype = b.getsq(x,y);
    int c2 = celltype & 1;
    int v = vote(c,b,x,y,t);

    int popcount = c.getneighborvalue(b,x,y); 
    int t2 = c.getlookuptable(popcount,celltype);
    t2 = t2 ^ v ^ c2;
    if (t2 >= c.numcolors){
      t2 = t2 - (c.numcolors & 254);
    }
    return t2;
  }
}





class abstract_margolus_rulefamilyc extends abstractcellautorulefamily {
  abstract_margolus_rulefamilyc(String name) {
    super(name);
  }
  int getbordersize(){
    return abstractcellautorulefamily.NEIGHBORHOOD_3X3;
  }
  static int get_center(boardc b,int x,int y,int t){
    return b.getsq(x,y);
  }
  static int get_cw(boardc b,int x,int y,int t){
    int px = (x & 1) ^ (t & 1);
    int py = (y & 1) ^ (t & 1);
    if ((px == 0) & (py == 0)) {return b.getsq(x+1,y);}
    if ((px == 1) & (py == 0)) {return b.getsq(x,y+1);}
    if ((px == 0) & (py == 1)) {return b.getsq(x,y-1);}
    if ((px == 1) & (py == 1)) {return b.getsq(x-1,y);}
    return 0;
  }
  static int get_ccw(boardc b,int x,int y,int t){
    int px = (x & 1) ^ (t & 1);
    int py = (y & 1) ^ (t & 1);
    if ((px == 0) & (py == 0)) {return b.getsq(x,y+1);}
    if ((px == 1) & (py == 0)) {return b.getsq(x-1,y);}
    if ((px == 0) & (py == 1)) {return b.getsq(x+1,y);}
    if ((px == 1) & (py == 1)) {return b.getsq(x,y-1);}
    return 0;
  }
  static int get_opp(boardc b,int x,int y,int t){
    int px = (x & 1) ^ (t & 1);
    int py = (y & 1) ^ (t & 1);
    if ((px == 0) & (py == 0)) {return b.getsq(x+1,y+1);}
    if ((px == 1) & (py == 0)) {return b.getsq(x-1,y+1);}
    if ((px == 0) & (py == 1)) {return b.getsq(x+1,y-1);}
    if ((px == 1) & (py == 1)) {return b.getsq(x-1,y-1);}
    return 0;
  }
}

class jc_margolus_tot5_rulefamilyc extends abstract_margolus_rulefamilyc {
  jc_margolus_tot5_rulefamilyc(String name) {
    super(name);
  }
  int getbordersize(){
    return abstractcellautorulefamily.NEIGHBORHOOD_3X3;
  }
  int getsum(boardc b,int x,int y,int t) {
    int sum = 0;
    sum = sum + ((get_cw(b,x,y,t) >> 2) & 31);
    sum = sum + ((get_ccw(b,x,y,t) >> 2) & 31);
    sum = sum + ((get_opp(b,x,y,t) >> 2) & 31);
    //sum = sum >> 3;
    return sum;
  }
  int calcsq(cellautorulec c,boardc b,int x,int y,int t) {
    int n = 0;
    n = n + getsum(b,x,y,t);
    n = n + (((get_cw(b,x,y,t) >> 1) & 1) << 7);
    n = n + (((get_ccw(b,x,y,t) >> 1) & 1) << 8);
    n = n + (((get_opp(b,x,y,t) >> 1) & 1) << 9);
    n = n + (((get_center(b,x,y,t) >> 1) & 1) << 10);
    n = n + (((get_center(b,x,y,t) >> 2) & 31) << 11);
    return c.getlookuptable(n & 255,n >> 8);
  }
}

class jc_margolus_sum5_rulefamilyc extends abstract_margolus_rulefamilyc {
  jc_margolus_sum5_rulefamilyc(String name) {
    super(name);
  }
  int getbordersize(){
    return abstractcellautorulefamily.NEIGHBORHOOD_3X3;
  }
  static int getsum(boardc b,int x,int y,int t) {
    int sum = 0;
    sum = sum + ((b.getsq(x-1,y) >> 1) & 1);
    sum = sum + ((b.getsq(x+1,y) >> 1) & 1);
    sum = sum + ((b.getsq(x,y-1) >> 1) & 1);
    sum = sum + ((b.getsq(x,y+1) >> 1) & 1);
    sum = sum + ((b.getsq(x,y) >> 1) & 1);
    return sum;
  }
  int calcsq(cellautorulec c,boardc b,int x,int y,int t){
    int n = 0;
    n = n + (((get_cw(b,x,y,t) >> 1) & 7) << 0);
    n = n + (((get_ccw(b,x,y,t) >> 1) & 7) << 3);
    n = n + (((get_opp(b,x,y,t) >> 1) & 7) << 6);
    n = n + (((get_center(b,x,y,t) >> 1) & 1) << 9);
    n = n + (((get_center(b,x,y,t) >> 2) & 7) << 10);
    n = n + (getsum(b,x,y,t) << 13);
    return c.getlookuptable(n & 255,n >> 8);
  }
}

class jc_margolus_sum8_rulefamilyc extends abstract_margolus_rulefamilyc {
  jc_margolus_sum8_rulefamilyc(String name) {
    super(name);
  }
  int getbordersize(){
    return abstractcellautorulefamily.NEIGHBORHOOD_3X3;
  }
  int getsum(boardc b,int x,int y,int t) {
    int sum = 0;
    for (int dx = -1;dx <= 1;dx++) {
      for (int dy = -1;dy <= 1;dy++) {
        if ((dx != 0) | (dy != 0)) {
          sum = sum + ((b.getsq(x+dx,y+dy) >> 4) & 1);
        }
      }
    }
    return sum;
  }
  int calcsq(cellautorulec c,boardc b,int x,int y,int t){
    int n = 0;
    n = n + (((get_cw(b,x,y,t) >> 1) & 7) << 0);
    n = n + (((get_ccw(b,x,y,t) >> 1) & 7) << 3);
    n = n + (((get_opp(b,x,y,t) >> 1) & 3) << 6);
    int sum = getsum(b,x,y,t) + (((get_center(b,x,y,t) >> 1) & 15) << 4);
    return c.getlookuptable(sum,n);
  }
}
class jc_margolus_rug6_rulefamilyc extends abstract_margolus_rulefamilyc {
  jc_margolus_rug6_rulefamilyc(String name) {
    super(name);
  }
  int getbordersize(){
    return abstractcellautorulefamily.NEIGHBORHOOD_3X3;
  }

  int getsum(boardc b,int x,int y,int t) {
    int sum = 0;
    for (int dx = -1;dx <= 1;dx++) {
      for (int dy = -1;dy <= 1;dy++) {
        if ((dx != 0) | (dy != 0)) {
          sum = sum + ((b.getsq(x+dx,y+dy) >> 1) & 63);
        }
      }
    }
    sum = sum >> 3;
    return sum;
  }
  int calcsq(cellautorulec c,boardc b,int x,int y,int t){
    int n = 0;
    n = n + n + ((get_center(b,x,y,t) >> 0) & 1);
    n = n + n + ((get_center(b,x,y,t) >> 7) & 1);
    n = n + n + ((get_cw(b,x,y,t) >> 0) & 1);
    n = n + n + ((get_cw(b,x,y,t) >> 7) & 1);
    n = n + n + ((get_ccw(b,x,y,t) >> 0) & 1);
    n = n + n + ((get_ccw(b,x,y,t) >> 7) & 1);
    n = n + n + ((get_opp(b,x,y,t) >> 0) & 1);
    n = n + n + ((get_opp(b,x,y,t) >> 7) & 1);
    int sum = getsum(b,x,y,t);
    return c.getlookuptable(sum,n);
  }
}

class margolus2_rulefamilyc extends margolus_ant_rulefamilyc {
  static margolus2_dailogboxc margolus2_dailogbox;
  margolus2_rulefamilyc(String name) {
    super(name);
  }
  
  void readline(String str) {
    String ss[] = str.split(",");
    String st = ss[0];
    if (st.equals("weights")) {
      set_center_weight(0,Integer.valueOf(ss[1]).intValue());
      set_cw_weight(0,Integer.valueOf(ss[2]).intValue());
      set_ccw_weight(0,Integer.valueOf(ss[3]).intValue());
      set_opp_weight(0,Integer.valueOf(ss[4]).intValue());
      return;
    }
    super.readline(str);
  }

  void writelines(Vector lines) {
    lines.add("weights," + get_center_weight(0) + "," + get_cw_weight(0) + "," + get_ccw_weight(0) + "," + get_opp_weight(0));    
  }
  void showoptions(){
    if (margolus2_dailogbox == null) {
      margolus2_dailogbox = new margolus2_dailogboxc("margolus neighborhood weights");
      margolus2_dailogbox.setBounds(0,0,200,400);
    }
    margolus2_dailogbox.enter_weights_into_boxes(0,get_opp_weight(0),get_cw_weight(0),get_ccw_weight(0),get_center_weight(0));
    margolus2_dailogbox.neighborhood_weights_checkbox.setSelected(use_neighborhood_weights);
    margolus2_dailogbox.set_margolus_ant_rulefamily(this);
    margolus2_dailogbox.setVisible(true);
  }
  int calcsq(cellautorulec c,boardc b,int x,int y,int t){
    int sq = b.getsq(x,y);
    int sum = get_margolus_sum(c,b,x,y,t);
    if (use_neighborhood_weights == true) {
      sum = sum + get_neighborhood_sum(c,b,x,y,t);
    }
    return c.getlookuptable(sum,sq);
  }
}
class margolus_ant_rulefamilyc extends abstract_margolus_rulefamilyc {
  int numtrails = 2;
  boolean use_neighborhood_weights = false;
  int center_weight = 0;
  int cw_weight = 1;
  int ccw_weight = 2;
  int opp_weight = 4;
  static margolus_ant_dailogboxc margolus_ant_dailogbox;
  String antcode = "0101";
  int antcode_array[] = {0,1,0,1};
  int antcode_length = 4;
  int trail_weight[] = {0,1};
  int num_trail_weights = 2;
  String get_trail_weights() {
    String str = "";
    for (int i = 0;i < num_trail_weights;i++) {
      if (i > 0) {str = str + ",";}
      str = str + trail_weight[i];
    }
    return str;
  }
  void set_trail_weights(String str) {
    String ss[] = str.split(",");
    int l = ss.length;
    num_trail_weights = l-1;
    trail_weight = new int[num_trail_weights];
    for (int i = 1;i < l;i++) {
      trail_weight[i-1] = Integer.valueOf(ss[i]).intValue();
    }
  }
  int get_trail_weight(int i) {
    return trail_weight[i];
  }
  int get_num_trail_weights() {
    return num_trail_weights;
  }
  String get_antcode(){
    return antcode;
  }

  void set_antcode(String s){
    antcode = s;
    int l = s.length();
    for (int i = 0;i < l;i++) {
      char ch = s.charAt(i);
      if (ch == '0') {antcode_length++;}
      if (ch == '1') {antcode_length++;}
    }
    antcode_array = new int[antcode_length];
    int l2 = 0;
    for (int i = 0;i < l;i++) {
      char ch = s.charAt(i);
      if (ch == '0') {antcode_array[l2] = 0;l2++;}
      if (ch == '1') {antcode_array[l2] = 1;l2++;}
    }
  }
  margolus_ant_rulefamilyc(String name) {
    super(name);
  }
  int getbordersize(){
    return cellautoapp.cellauto131.bordersize;
  }
  int get_center_weight(int i) {
    return center_weight;
  }
  int get_cw_weight(int i) {
    return cw_weight;
  }
  int get_ccw_weight(int i) {
    return ccw_weight;
  }
  int get_opp_weight(int i) {
    return opp_weight;
  }
  void set_center_weight(int i,int i2) {
    center_weight = i2;
  }
  void set_cw_weight(int i,int i2) {
    cw_weight = i2;
  }
  void set_ccw_weight(int i,int i2) {
    ccw_weight = i2;
  }
  void set_opp_weight(int i,int i2) {
    opp_weight = i2;
  }  
  void readline(String str) {
    String ss[] = str.split(",");
    String st = ss[0];
    if (st.equals("ant_code")) {
      set_antcode(ss[1]);
      return;
    }
    if (st.equals("trail_weights")) {
      set_trail_weights(str);
      return;
    }
    if (st.equals("weights")) {
      set_center_weight(0,Integer.valueOf(ss[1]).intValue());
      set_cw_weight(0,Integer.valueOf(ss[2]).intValue());
      set_ccw_weight(0,Integer.valueOf(ss[3]).intValue());
      set_opp_weight(0,Integer.valueOf(ss[4]).intValue());
      return;
    }
    super.readline(str);
  }
  void writelines(Vector lines) {
    lines.add("weights," + get_center_weight(0) + "," + get_cw_weight(0) + "," + get_ccw_weight(0) + "," + get_opp_weight(0));    
    lines.add("ant_code," + get_antcode());
    lines.add("trail_weights," + get_trail_weights());
    super.writelines(lines);
  }
  int get_margolus_sum(cellautorulec c,boardc b,int x,int y,int t) {
    int center = (c.cellvalue[get_center(b,x,y,t)]) * center_weight;
    int cw  =  (c.cellvalue[get_cw(b,x,y,t)]) * cw_weight;
    int ccw =  (c.cellvalue[get_ccw(b,x,y,t)]) * ccw_weight;
    int opp =  (c.cellvalue[get_opp(b,x,y,t)]) * opp_weight;
    int sum = center + cw + ccw + opp;
    return sum;
  }
  int get_neighborhood_sum(cellautorulec c,boardc b,int x,int y,int t) {
    int ns = c.bordersize;
    int sum = 0;
    for (int dx = -ns;dx <= ns;dx++) {
      for (int dy = -ns;dy <= ns;dy++) {
        sum = sum + (c.cellvalue[b.getsq(x+dx,y+dy)] * c.bordervalue[dx+ns][dy+ns]);
      }
    }
    return sum;
  }
  
  int calcsq(cellautorulec c,boardc b,int x,int y,int t){
    int cw = get_cw(b,x,y,t);
    int ccw = get_ccw(b,x,y,t);
    int opp = get_opp(b,x,y,t);
    int center = get_center(b,x,y,t);
    int sq = b.getsq(x,y);
    int trail = sq >> 1;
    int sum = get_margolus_sum(c,b,x,y,t);
    if (use_neighborhood_weights == true) {
      sum = sum + get_neighborhood_sum(c,b,x,y,t);
    }
    sq = sq & 254;
    if (((cw | ccw | opp | center) & 1) == 1) {sq = sq | 1;}
    int sum2 = 0;
    if ((num_trail_weights & (num_trail_weights-1)) == 0) {
      //if the number of trail weights is a power of 2 then
      //get the sum the fast way
      sum2 = sum2 + trail_weight[(cw >> 1) & (num_trail_weights - 1)]; 
      sum2 = sum2 + trail_weight[(ccw >> 1) & (num_trail_weights - 1)];
      sum2 = sum2 + trail_weight[(opp >> 1) & (num_trail_weights - 1)];
      sum2 = sum2 + trail_weight[(center >> 1) & (num_trail_weights - 1)];
    } else {
      //otherwise get it the slow way
      sum2 = sum2 + trail_weight[(cw >> 1) % num_trail_weights]; 
      sum2 = sum2 + trail_weight[(ccw >> 1) % num_trail_weights];
      sum2 = sum2 + trail_weight[(opp >> 1) % num_trail_weights];
      sum2 = sum2 + trail_weight[(center >> 1) % num_trail_weights];
    }
    int ant = cw & 1;
   
    if (antcode_array[sum2 % antcode_length] == 1) {
      ant = ccw & 1;
    } 
    
    return c.getlookuptable(sum,sq) ^ ant;
  }
  void showoptions(){
    if (margolus_ant_dailogbox == null) {
      margolus_ant_dailogbox = new margolus_ant_dailogboxc("margolus neighborhood weights");
      margolus_ant_dailogbox.setBounds(0,0,200,400);
    }
    //for (int i = 0;i < 2;i++) {
      margolus_ant_dailogbox.enter_weights_into_boxes(0,opp_weight,cw_weight,ccw_weight,center_weight);
    //}
    //margolus_ant_dailogbox.c = this;
    margolus_ant_dailogbox.antcode_edit.setText(get_antcode());
    margolus_ant_dailogbox.trail_weights_edit.setText(get_trail_weights());
    margolus_ant_dailogbox.neighborhood_weights_checkbox.setSelected(use_neighborhood_weights);
    margolus_ant_dailogbox.set_margolus_ant_rulefamily(this);
    margolus_ant_dailogbox.setVisible(true);
  }
  
}

class margolus_ant43_rulefamilyc extends margolus_ant_rulefamilyc {
  int center_weight[] = {0,0};
  int cw_weight[] = {1,0};
  int ccw_weight[] = {2,0};
  int opp_weight[] = {4,0};
  static margolus_ant43_dailogboxc margolus_ant43_dailogbox;
  margolus_ant43_rulefamilyc(String name) {
    super(name);
  }
  int getbordersize(){
    return abstractcellautorulefamily.NEIGHBORHOOD_3X3;
  }
  int get_center_weight(int i) {
    return center_weight[i];
  }
  int get_cw_weight(int i) {
    return cw_weight[i];
  }
  int get_ccw_weight(int i) {
    return ccw_weight[i];
  }
  int get_opp_weight(int i) {
    return opp_weight[i];
  }
  void set_center_weight(int i,int i2) {
    center_weight[i] = i2;
  }
  void set_cw_weight(int i,int i2) {
    cw_weight[i] = i2;
  }
  void set_ccw_weight(int i,int i2) {
    ccw_weight[i] = i2;
  }
  void set_opp_weight(int i,int i2) {
    opp_weight[i] = i2;
  }
  int get_sum(cellautorulec c,boardc b,int x,int y,int t) {
    return get_trail_sum(c,b,x,y,t) + get_ant_sum(c,b,x,y,t);
  }
  int get_trail_sum(cellautorulec c,boardc b,int x,int y,int t) {
    int center = (c.cellvalue[get_center(b,x,y,t)]) * center_weight[0];
    int cw  =  (c.cellvalue[get_cw(b,x,y,t)]) * cw_weight[0];
    int ccw =  (c.cellvalue[get_ccw(b,x,y,t)]) * ccw_weight[0];
    int opp =  (c.cellvalue[get_opp(b,x,y,t)]) * opp_weight[0];
    int sum = center + cw + ccw + opp;
    return sum;
  }
  int get_ant_sum(cellautorulec c,boardc b,int x,int y,int t) {
    if ((center_weight[1] + cw_weight[1] + ccw_weight[1] + opp_weight[1]) == 0) {return 0;}
    int center = (get_center(b,x,y,t) & 1) * center_weight[1];
    int cw  =  (get_cw(b,x,y,t) & 1) * cw_weight[1];
    int ccw =  (get_ccw(b,x,y,t) & 1) * ccw_weight[1];
    int opp =  (get_opp(b,x,y,t) & 1) * opp_weight[1];
    int sum = center + cw + ccw + opp;
    return sum;
  }

  int calcsq(cellautorulec c,boardc b,int x,int y,int t){
    int sum = get_sum(c,b,x,y,t);
    int sq = b.getsq(x,y);
    return c.getlookuptable(sum,sq);
  }
  void readline(String str) {
    String ss[] = str.split(",");
    String st = ss[0];
    if (st.equals("weights")) {
      center_weight[0] = Integer.valueOf(ss[1]).intValue();
      cw_weight[0] = Integer.valueOf(ss[2]).intValue();
      ccw_weight[0] = Integer.valueOf(ss[3]).intValue();
      opp_weight[0] = Integer.valueOf(ss[4]).intValue();
      return;
    }
    if (st.equals("weights2")) {
      center_weight[1] = Integer.valueOf(ss[1]).intValue();
      cw_weight[1] = Integer.valueOf(ss[2]).intValue();
      opp_weight[1] = Integer.valueOf(ss[4]).intValue();
      return;
    }
    super.readline(str);
  }
  void writelines(Vector lines){
    lines.add("weights," + center_weight[0] + "," + cw_weight[0] + "," + ccw_weight[0] + "," + opp_weight[0]);
    lines.add("weights2," + center_weight[1] + "," + cw_weight[1] + "," + ccw_weight[1] + "," + opp_weight[1]);
  }

  void showoptions(){
    if (margolus_ant43_dailogbox == null) {
      margolus_ant43_dailogbox = new margolus_ant43_dailogboxc("margolus neighborhood weights");
      margolus_ant43_dailogbox.setBounds(0,0,200,400);
    }
    for (int i = 0;i < 2;i++) {
      margolus_ant43_dailogbox.enter_weights_into_boxes(i,opp_weight[i],cw_weight[i],ccw_weight[i],center_weight[i]);
    }
    //margolus_ant_dailogbox.c = this;
    margolus_ant43_dailogbox.set_margolus_ant_rulefamily(this);
    margolus_ant43_dailogbox.setVisible(true);
  }
  //void okbuttonclick() {
  //  System.out.println("ok");
  //}
  //void cancelbuttonclick() {
  //  System.out.println("cancel");
  //}
}

class margolus_ant_sum_rulefamilyc extends margolus_ant43_rulefamilyc {
  static margolus_ant_sum_dailogboxc margolus_ant_sum_dailogbox;
  int sumbits = 1;
  int summovebits = 0;
  
  int get_sumbits() {
    return sumbits;
  }
  int get_summovebits() {
    return summovebits;
  }
  void set_sumbits(int a) {
    sumbits = a;
  }
  void set_summovebits(int a) {
    summovebits = a;
  }

  margolus_ant_sum_rulefamilyc(String name) {
    super(name);
  }
  void readline(String str) {
    String ss[] = str.split(",");
    String st = ss[0];
    if (st.equals("sumbits")) {
      sumbits = Integer.valueOf(ss[1]).intValue();
      summovebits = Integer.valueOf(ss[2]).intValue();
      return;
    }
    super.readline(str);
  }
  void writelines(Vector lines){
    lines.add("sumbits," + sumbits + "," + summovebits);
    super.writelines(lines);
  }

  int getbordersize(){
    return abstractcellautorulefamily.NEIGHBORHOOD_3X3;
  }
  int get_sum2(cellautorulec c,boardc b,int x,int y,int t) {
    int sum = 0;
    for (int dx = -c.bordersize;dx <= c.bordersize;dx++){
      for (int dy = -c.bordersize;dy <= c.bordersize;dy++){
        int i = b.getsq(x+dx,y+dy);
        if (i < 0){i = i + c.numcolors;}
        int i2 = i & ((1 << sumbits)-1);
        sum = sum + (i2 * c.bordervalue[dx+c.bordersize][dy+c.bordersize]);
      }
    }
    if (summovebits < 0) {
      int i = -summovebits;
      sum = sum << i;
    } else {
      int i = summovebits;
      sum = sum >> i;
    }
    return sum;
  }
  int calcsq(cellautorulec c,boardc b,int x,int y,int t){
    int sum = get_sum(c,b,x,y,t);
    int sum2 = get_sum2(c,b,x,y,t);
    int sq = b.getsq(x,y);
    return c.getlookuptable(sum+sum2,sq);
  }
  void showoptions(){
    if (margolus_ant_sum_dailogbox == null) {
      margolus_ant_sum_dailogbox = new margolus_ant_sum_dailogboxc("margolus neighborhood weights");
      margolus_ant_sum_dailogbox.setBounds(0,0,200,400);
    }
    for (int i = 0;i < 2;i++) {
      margolus_ant_sum_dailogbox.enter_weights_into_boxes(i,opp_weight[i],cw_weight[i],ccw_weight[i],center_weight[i]);
    }
    margolus_ant_sum_dailogbox.enter_sumbits_into_boxes(sumbits,summovebits);
    margolus_ant_sum_dailogbox.set_margolus_ant_rulefamily(this);
    //margolus_ant_sum_dailogbox.c = this;
    margolus_ant_sum_dailogbox.setVisible(true);
  }
}

class margolus_ant_sum_dailogboxc extends abstract_margolus_ant_dailogboxc {
  
  JLabel sum_bits_label;
  JTextField sum_bits_edit;
  JLabel sum_move_bits_label;
  JTextField sum_move_bits_edit;
  String weight_box_names[] = {"trail weights","ant weights"};
  //margolus_ant_sum_rulefamilyc c = null;  
  margolus_ant_sum_dailogboxc(String Title) {
    this.setTitle(Title);
    GridBagLayout gl = new GridBagLayout();
    this.getContentPane().setLayout(gl);
    GridBagConstraints cc = new GridBagConstraints();

    cc.fill = GridBagConstraints.BOTH;
    cc.weightx = 1.0;
    cc.weighty = 1.0;
    create_weight_boxes(weight_box_names,gl,cc);
    create_sum_bit_boxes(gl,cc);
    create_buttons(gl,cc,"margolus_ant_sum");
    this.pack();
  }
  void enter_sumbits_into_boxes(int sumbits,int summovebits) {
    sum_bits_edit.setText(Integer.toString(sumbits));
    sum_move_bits_edit.setText(Integer.toString(summovebits));
  }
  void create_sum_bit_boxes(GridBagLayout gl,GridBagConstraints cc) {
    sum_bits_label = new JLabel("number of sum bits");
    cc.gridwidth = 1;
    gl.setConstraints(sum_bits_label, cc);
    this.getContentPane().add(sum_bits_label);


    sum_bits_edit = new JTextField("1");
    cc.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(sum_bits_edit, cc);
    this.getContentPane().add(sum_bits_edit);

    sum_move_bits_label = new JLabel("how many bits to move");
    cc.gridwidth = 1;
    gl.setConstraints(sum_move_bits_label, cc);
    this.getContentPane().add(sum_move_bits_label);

    sum_move_bits_edit = new JTextField("0");
    cc.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(sum_move_bits_edit, cc);
    this.getContentPane().add(sum_move_bits_edit);
  }
  void update_sumbits(margolus_ant_sum_rulefamilyc c) {
    c.set_sumbits(Integer.valueOf(sum_bits_edit.getText()).intValue());
    c.set_summovebits(Integer.valueOf(sum_move_bits_edit.getText()).intValue());
  }
  void okbuttonclick() {
    margolus_ant_sum_rulefamilyc c = (margolus_ant_sum_rulefamilyc) this.get_margolus_ant_rulefamily();
    update_weights(c);
    update_sumbits(c);
    this.setVisible(false);
  }
  void cancelbuttonclick() {
    this.setVisible(false);
  }
}


class margolus2_dailogboxc extends abstract_margolus_ant_dailogboxc {
  String weight_box_names[] = {"margolus weights"};
  JCheckBox neighborhood_weights_checkbox;
  JLabel antcode_label;
  JTextField antcode_edit;
  JLabel trail_weights_label;
  JTextField trail_weights_edit;
  margolus2_dailogboxc() {
    
  }
  margolus2_dailogboxc(String Title) {
    //super(Title);
    this.setTitle(Title);
    GridBagLayout gl = new GridBagLayout();
    this.getContentPane().setLayout(gl);
    GridBagConstraints cc = new GridBagConstraints();

    cc.fill = GridBagConstraints.BOTH;
    cc.weightx = 1.0;
    cc.weighty = 1.0;
    create_weight_boxes(weight_box_names,gl,cc);
    
    
    neighborhood_weights_checkbox = new JCheckBox("use neighborhood weights");
    cc.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(neighborhood_weights_checkbox, cc);
    this.getContentPane().add(neighborhood_weights_checkbox);

    create_buttons(gl,cc,"margolus2");
    this.pack();
  }
  void okbuttonclick() {
    margolus_ant_rulefamilyc c = get_margolus_ant_rulefamily();
    update_weights(c);
    //c.set_antcode(antcode_edit.getText());
    //c.set_trail_weights("trail_weights," + trail_weights_edit.getText());
    c.use_neighborhood_weights = neighborhood_weights_checkbox.isSelected();
    this.setVisible(false);
  }
  void cancelbuttonclick() {
    this.setVisible(false);
  }
}


class margolus_ant_dailogboxc extends abstract_margolus_ant_dailogboxc {
  String weight_box_names[] = {"margolus weights"};
  JCheckBox neighborhood_weights_checkbox;
  JLabel antcode_label;
  JTextField antcode_edit;
  JLabel trail_weights_label;
  JTextField trail_weights_edit;
  margolus_ant_dailogboxc() {
    
  }
  margolus_ant_dailogboxc(String Title) {
    //super(Title);
    this.setTitle(Title);
    GridBagLayout gl = new GridBagLayout();
    this.getContentPane().setLayout(gl);
    GridBagConstraints cc = new GridBagConstraints();

    cc.fill = GridBagConstraints.BOTH;
    cc.weightx = 1.0;
    cc.weighty = 1.0;
    create_weight_boxes(weight_box_names,gl,cc);
    


    antcode_label = new JLabel("ant code");
    cc.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(antcode_label, cc);
    this.getContentPane().add(antcode_label);

    antcode_edit = new JTextField("0101");
    cc.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(antcode_edit, cc);
    this.getContentPane().add(antcode_edit);
    
    trail_weights_label = new JLabel("trail weights");
    cc.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(trail_weights_label, cc);
    this.getContentPane().add(trail_weights_label);

    trail_weights_edit = new JTextField("0,1");
    cc.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(trail_weights_edit, cc);
    this.getContentPane().add(trail_weights_edit);
    
    neighborhood_weights_checkbox = new JCheckBox("use neighborhood weights");
    cc.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(neighborhood_weights_checkbox, cc);
    this.getContentPane().add(neighborhood_weights_checkbox);

    create_buttons(gl,cc,"margolus_ant");
    this.pack();
  }
  void okbuttonclick() {
    margolus_ant_rulefamilyc c = get_margolus_ant_rulefamily();
    update_weights(c);
    c.set_antcode(antcode_edit.getText());
    c.set_trail_weights("trail_weights," + trail_weights_edit.getText());
    c.use_neighborhood_weights = neighborhood_weights_checkbox.isSelected();
    this.setVisible(false);
  }
  void cancelbuttonclick() {
    this.setVisible(false);
  }
}

class margolus_ant43_dailogboxc extends abstract_margolus_ant_dailogboxc {
  String weight_box_names[] = {"trail weights","ant weights"};
  margolus_ant43_dailogboxc() {
    
  }
  margolus_ant43_dailogboxc(String Title) {
    //super(Title);
    this.setTitle(Title);
    GridBagLayout gl = new GridBagLayout();
    this.getContentPane().setLayout(gl);
    GridBagConstraints cc = new GridBagConstraints();

    cc.fill = GridBagConstraints.BOTH;
    cc.weightx = 1.0;
    cc.weighty = 1.0;
    create_weight_boxes(weight_box_names,gl,cc);
    

    create_buttons(gl,cc,"margolus_ant43");
    this.pack();
  }
  void okbuttonclick() {
    update_weights(c);
    this.setVisible(false);
  }
  void cancelbuttonclick() {
    this.setVisible(false);
  }
}
class abstract_margolus_ant_dailogboxc extends JFrame {
  JLabel trail_weights_label[];
  JLabel opp_weight_label[];
  JTextField opp_weight_edit[];
  JLabel ccw_weight_label[];
  JTextField ccw_weight_edit[];
  JLabel cw_weight_label[];
  JTextField cw_weight_edit[];
  JLabel center_weight_label[];
  JTextField center_weight_edit[];
  
  int num_weight_boxes = 0;
  JButton okbutton;
  JButton cancelbutton;
  margolus_ant_rulefamilyc c = null;  
  margolus_ant_rulefamilyc get_margolus_ant_rulefamily() {
    return c;
  }
  void set_margolus_ant_rulefamily(margolus_ant_rulefamilyc c2){
    this.c = c2;
  }
  void create_weight_boxes(String name[],GridBagLayout gl,GridBagConstraints cc) {
    int l = name.length;
    num_weight_boxes = l;
    trail_weights_label = new JLabel[l];
    opp_weight_label = new JLabel[l];
    ccw_weight_label = new JLabel[l];
    opp_weight_edit = new JTextField[l];
    ccw_weight_edit = new JTextField[l];
    
    cw_weight_label = new JLabel[l];
    center_weight_label = new JLabel[l];
    cw_weight_edit = new JTextField[l];
    center_weight_edit = new JTextField[l];
    
    for (int i = 0;i < l;i++) {
      trail_weights_label[i] = new JLabel(name[i]);
      cc.gridwidth = GridBagConstraints.REMAINDER;
      gl.setConstraints(trail_weights_label[i], cc);
      this.getContentPane().add(trail_weights_label[i]);

      opp_weight_label[i] = new JLabel("opp");
      cc.gridwidth = 1;
      gl.setConstraints(opp_weight_label[i], cc);
      this.getContentPane().add(opp_weight_label[i]);

      ccw_weight_label[i] = new JLabel("ccw");
      cc.gridwidth = GridBagConstraints.REMAINDER;
      gl.setConstraints(ccw_weight_label[i], cc);
      this.getContentPane().add(ccw_weight_label[i]);

      opp_weight_edit[i] = new JTextField("4");
      cc.gridwidth = 1;
      gl.setConstraints(opp_weight_edit[i], cc);
      this.getContentPane().add(opp_weight_edit[i]);

      ccw_weight_edit[i] = new JTextField("2");
      cc.gridwidth = GridBagConstraints.REMAINDER;
      gl.setConstraints(ccw_weight_edit[i], cc);
      this.getContentPane().add(ccw_weight_edit[i]);
    
      cw_weight_label[i] = new JLabel("cw");
      cc.gridwidth = 1;
      gl.setConstraints(cw_weight_label[i], cc);
      this.getContentPane().add(cw_weight_label[i]);

      center_weight_label[i] = new JLabel("center");
      cc.gridwidth = GridBagConstraints.REMAINDER;
      gl.setConstraints(center_weight_label[i], cc);
      this.getContentPane().add(center_weight_label[i]);

      cw_weight_edit[i] = new JTextField("1");
      cc.gridwidth = 1;
      gl.setConstraints(cw_weight_edit[i], cc);
      this.getContentPane().add(cw_weight_edit[i]);

      center_weight_edit[i] = new JTextField("0");
      cc.gridwidth = GridBagConstraints.REMAINDER;
      gl.setConstraints(center_weight_edit[i], cc);
      this.getContentPane().add(center_weight_edit[i]);
    //create_more_stuff();
    }
  }

  
  void create_buttons(GridBagLayout gl,GridBagConstraints cc,String action) {
    okbutton = new JButton("ok");
    okbutton.setActionCommand(action + "_okbuttonclick");
    okbutton.addActionListener(abstractcellautorulefamily.actlis);
    cc.gridwidth = 1;
    gl.setConstraints(okbutton, cc);
    this.getContentPane().add(okbutton);

    cancelbutton = new JButton("cancel");
    cancelbutton.setActionCommand(action + "_cancelbuttonclick");
    cancelbutton.addActionListener(abstractcellautorulefamily.actlis);
    cc.gridwidth = GridBagConstraints.REMAINDER;
    gl.setConstraints(cancelbutton, cc);
    this.getContentPane().add(cancelbutton);
  }
  void enter_weights_into_boxes(int i,int opp_weight,int cw_weight,int ccw_weight,int center_weight) {
    opp_weight_edit[i].setText(Integer.toString(opp_weight));
    cw_weight_edit[i].setText(Integer.toString(cw_weight));
    ccw_weight_edit[i].setText(Integer.toString(ccw_weight));
    center_weight_edit[i].setText(Integer.toString(center_weight));

  }
  void update_weights(margolus_ant_rulefamilyc c){
    for (int i = 0;i < num_weight_boxes;i++) {
      c.set_center_weight(i,Integer.valueOf(center_weight_edit[i].getText()).intValue());
      c.set_cw_weight(i,Integer.valueOf(cw_weight_edit[i].getText()).intValue());
      c.set_ccw_weight(i,Integer.valueOf(ccw_weight_edit[i].getText()).intValue());
      c.set_opp_weight(i,Integer.valueOf(opp_weight_edit[i].getText()).intValue());
    }
  }
  void okbuttonclick() {
    update_weights(c);
    this.setVisible(false);
  }
  void cancelbuttonclick() {
    this.setVisible(false);
  }
  
}

class jc_margolus_rulefamilyc extends abstract_margolus_rulefamilyc {
  jc_margolus_rulefamilyc(String name) {
    super(name);
  }
  int getbordersize(){
    return abstractcellautorulefamily.NEIGHBORHOOD_3X3;
  }
  int calcsq(cellautorulec c,boardc b,int x,int y,int t){
    //int px = (x & 1) ^ (t & 1);
    //int py = (y & 1) ^ (t & 1);
    
    
    int center = (get_center(b,x,y,t) >> 1) & 15;
    int cw  =  (get_cw(b,x,y,t) >> 1) & 15;
    int ccw =  (get_ccw(b,x,y,t) >> 1) & 15;
    int opp =  (get_opp(b,x,y,t) >> 1) & 15;

    return c.getlookuptable(center | (cw << 4),ccw | (opp << 4));
  }
}

class jc_vonn3_rulefamilyc extends abstractcellautorulefamily {
  jc_vonn3_rulefamilyc(String name) {
    super(name);
  }
  int getbordersize(){
    return abstractcellautorulefamily.NEIGHBORHOOD_3X3;
  }
  int calcsq(cellautorulec c,boardc b,int x,int y,int t){
    int sq = b.getsq(x,y);
    int sum = 0;
    sum = sum + (((b.getsq(x,y+1) >> 0) & 7));
    sum = sum + (((b.getsq(x+1,y) >> 0) & 7) << 3);
    sum = sum + (((b.getsq(x,y-1) >> 0) & 7) << 6);
    sum = sum + (((b.getsq(x-1,y) >> 0) & 7) << 9);
    //return c.getlookuptable(sum & 255,((((sq << 4) | (sum >> 8)) & 127) << 1) | ((sq >> 3) & 1));
    return c.getlookuptable(sum & 255,(((sq << 3) | (sum >> 8)) & 255));
    
  }
  
}
class jc_langton_rulefamilyc extends abstractcellautorulefamily {
  jc_langton_rulefamilyc(String name) {
    super(name);
  }
  int getbordersize(){
    return abstractcellautorulefamily.NEIGHBORHOOD_3X3;
  }
  int calcsq(cellautorulec c,boardc b,int x,int y,int t){
    int sq = b.getsq(x,y);
    int sum = 0;
    sum = sum + (((b.getsq(x,y+1) >> 1) & 7));
    sum = sum + (((b.getsq(x+1,y) >> 1) & 7) << 3);
    sum = sum + (((b.getsq(x,y-1) >> 1) & 7) << 6);
    sum = sum + (((b.getsq(x-1,y) >> 1) & 7) << 9);
    //int a = ((b.getsq(x,y-1) >> 1) & 7);
    //sum = sum + ((a & 1) << 10) + ((a & 2) << 10) + ((a & 4) << 7);

    //return c.getlookuptable(sum & 255,(((sq << 3) | (sum >> 8)) & 127) << 1);
    return c.getlookuptable(sum & 255,(((sq << 3) | (sum >> 8)) & 255));

  }
}

class jc_average_rulefamilyc extends abstractcellautorulefamily {
  jc_average_rulefamilyc(String name) {
    super(name);
  }
  int getbordersize(){
    return abstractcellautorulefamily.NEIGHBORHOOD_3X3;
  }
  int rotatebyte(int a){
    return (a >> 1) | ((a & 1) << 7);
  }
  int calcsq(cellautorulec c,boardc b,int x,int y,int t){
    int bordersize = c.getbordersize();
    int sq = b.getsq(x,y);
    int sum = 0;
    for (int dx = -bordersize;dx <= bordersize;dx++) {
      for (int dy = -bordersize;dy <= bordersize;dy++) {
        if ((dx != 0) | (dy != 0)) {
          sum = sum + rotatebyte(b.getsq(x+dx,y+dy));
        }
      }
    }
    return c.getlookuptable(sum >> 3,sq);
  }
}

class jc_average4_rulefamilyc extends abstractcellautorulefamily {
  jc_average4_rulefamilyc(String name) {
    super(name);
  }
  int getbordersize(){
    return abstractcellautorulefamily.NEIGHBORHOOD_3X3;
  }
  int rotatebyte(int a){
    return (a >> 1) | ((a & 1) << 7);
  }
  int calcsq(cellautorulec c,boardc b,int x,int y,int t){
    int bordersize = c.getbordersize();
    int sq = b.getsq(x,y);
    int sum = 0;
    
    sum = sum + (rotatebyte(b.getsq(x+1,y)) * c.getbordervalue(1,0));
    sum = sum + (rotatebyte(b.getsq(x-1,y)) * c.getbordervalue(-1,0));
    sum = sum + (rotatebyte(b.getsq(x,y+1)) * c.getbordervalue(0,1));
    sum = sum + (rotatebyte(b.getsq(x,y-1)) * c.getbordervalue(0,-1));
    return c.getlookuptable(sum >> 2,sq);
  }
}

class jc_cycle_rulefamilyc extends abstractcellautorulefamily {
  jc_cycle_rulefamilyc(String name) {
    super(name);
  }
  int getbordersize(){
    return abstractcellautorulefamily.NEIGHBORHOOD_3X3;
  } 
  int calcsq(cellautorulec c,boardc b,int x,int y,int t){
    int bordersize = c.getbordersize();
    int sq = b.getsq(x,y);
    int sum = 0;
    int n = 0;
    if ((t & 7) == 0) {n = b.getsq(x,y-1);}
    if ((t & 7) == 1) {n = b.getsq(x-1,y-1);}
    if ((t & 7) == 2) {n = b.getsq(x-1,y);}
    if ((t & 7) == 3) {n = b.getsq(x-1,y+1);}
    if ((t & 7) == 4) {n = b.getsq(x,y+1);}
    if ((t & 7) == 5) {n = b.getsq(x+1,y+1);}
    if ((t & 7) == 6) {n = b.getsq(x+1,y);}
    if ((t & 7) == 7) {n = b.getsq(x+1,y-1);}
    return c.getlookuptable(n,sq);
  }
}
class jc_switch_rulefamilyc extends abstractcellautorulefamily {
  jc_switch_rulefamilyc(String name) {  
    super(name);
  }
  int getbordersize(){
    return abstractcellautorulefamily.NEIGHBORHOOD_3X3;
  }
  int rotatebyte(int a){
    return (a >> 1) | ((a & 1) << 7);
  }
  int calcsq(cellautorulec c,boardc b,int x,int y,int t){
    int n = 0;
    if ((t & 1) == 0) {
      n = ((rotatebyte(b.getsq(x+1,y)) & 7) << 3) + (rotatebyte(b.getsq(x,y+1)) & 7);
      n = n + ((rotatebyte(b.getsq(x,y-1)) & 7) << 9) + ((rotatebyte(b.getsq(x-1,y)) & 7) << 6);
      n = n + ((rotatebyte(b.getsq(x,y)) & 15) << 12);
    } else {
      n = ((rotatebyte(b.getsq(x+1,y+1)) & 7) << 3) + (rotatebyte(b.getsq(x-1,y+1)) & 7);
      n = n + ((rotatebyte(b.getsq(x+1,y-1)) & 7) << 9) + ((rotatebyte(b.getsq(x-1,y-1)) & 7) << 6);
      n = n + ((rotatebyte(b.getsq(x,y)) & 15) << 12);
    }
    return c.getlookuptable(n & 255,n >> 8);
  }
}



class jc_vonn2_rulefamilyc extends abstractcellautorulefamily {
  jc_vonn2_rulefamilyc(String name) {
    super(name);
  }
  int getbordersize(){
    return abstractcellautorulefamily.NEIGHBORHOOD_3X3;
  }
  int rotatebyte(int a){
    return (a >> 1) | ((a & 1) << 7);
  }
  int calcsq(cellautorulec c,boardc b,int x,int y,int t){
    int sq = b.getsq(x,y);
    int n = 0;
    n = ((rotatebyte(b.getsq(x+1,y)) & 3) << 2) + (rotatebyte(b.getsq(x,y+1)) & 3);
    n = n + ((rotatebyte(b.getsq(x,y-1)) & 3) << 6) + ((rotatebyte(b.getsq(x-1,y)) & 3) << 4);
    return c.getlookuptable(sq,n);
  }
}
class rug_avereging_rulefamilyc extends abstractcellautorulefamily {
  //average
  int num_bits_of_local_state = 5;
  rug_avereging_rulefamilyc(String name){
    super(name);
  }
  int getbordersize(){
    return abstractcellautorulefamily.NEIGHBORHOOD_3X3;
  }
  void writelines(Vector lines){  
    lines.add("num_bits_of_local_state," + num_bits_of_local_state);
  }
  void readline(String str){
    String ss[] = str.split(",");
    String st = ss[0];
    if (st.equals("num_bits_of_local_state")) {
      num_bits_of_local_state = Integer.valueOf(ss[1]).intValue();
    }
    //System.out.println("num_bits_of_local_state: " + num_bits_of_local_state);
  }
  int calcsq(cellautorulec c,boardc b,int x,int y,int t){
    int bordersize = c.getbordersize();
    int sq = b.getsq(x,y);
    int sum = 0;
    for (int dx = -bordersize;dx <= bordersize;dx++) {
      for (int dy = -bordersize;dy <= bordersize;dy++) {
        sum = sum + (b.getsq(x+dx,y+dy) * c.getbordervalue(dx,dy));
      }
    }//
    //return c.getlookuptable(sum & 255,((((sq << 3) | (sum >> 8)) & 127) << 1) | ((sq >> 4) & 1));
    return c.getlookuptable(sum & 255,((sq << (8-num_bits_of_local_state)) | (sum >> 8))&255);
  }
  
}
class margolusneighborhoodrulefamilyc extends abstractcellautorulefamily{
  int tablesize = 2;
  margolusneighborhoodrulefamilyc(String name){
    super(name);
  }
  int getbordersize(){
    return abstractcellautorulefamily.NEIGHBORHOOD_3X3;
  }
  int get_background_tile_width() {
    return 2;
  }
  int get_background_tile_height() {
    return 2;
  }
  void readline(String str){
    String ss[] = str.split(",");
    String st = ss[0];
    if (st.equals("tablesize")){
      try {
        int tablesize = Integer.valueOf(ss[1]).intValue();
        if (tablesize < 2){tablesize = 2;}
        if (tablesize < 16){tablesize = 16;}
      }catch (NumberFormatException e){
        tablesize = 2;
      }
    }
  }
  void writelines(Vector lines){
    if (tablesize != 2){
      lines.add("tablesize," + tablesize);
    }
  }
  void addarg(String arg){
    super.addarg(arg);
    if (getnumargs() == 1){
      try {
        tablesize = Integer.valueOf(arg).intValue();
        if (tablesize < 2){tablesize = 2;}
        if (tablesize < 16){tablesize = 16;}
      }catch (NumberFormatException e){
        tablesize = 2;
      }
    }
  }
  //int getdfcolor(cellautorulec c,int a){
  //  return c.getlookuptable((((a * tablesize) + a) << 1),(((a * tablesize) + a) << 1));
  //}
  int calcsq(cellautorulec c,boardc b,int x,int y,int t){
    int tablex = (x & 1) ^ (t & 1);
    int tabley = (y & 1) ^ (t & 1);
    int x2 = x - tablex;
    int y2 = y - tabley;
    int sq1 = b.getsq(x2,y2);
    int sq2 = b.getsq(x2+1,y2);
    int sq3 = b.getsq(x2,y2+1);
    int sq4 = b.getsq(x2+1,y2+1);
    if (tablesize == 2){
      tablex = (sq2 << 2) + (sq1 << 1) + tablex;
      tabley = (sq4 << 2) + (sq3 << 1) + tabley;
    }else {
      if (tablesize == 4){
        tablex = (sq2 << 3) + (sq1 << 1) + tablex;
        tabley = (sq4 << 3) + (sq3 << 1) + tabley;
      }else{
        tablex = (((sq2 * tablesize) + sq1) << 1) + tablex;
        tabley = (((sq4 * tablesize) + sq3) << 1) + tabley;
      }
    }
    //if ((tablex < 2) & (tabley < 2)){
    //  return 0;
    //}
    return c.getlookuptable(tablex,tabley);
  }
}

class rulefamilyactlisc implements ActionListener {
  public void actionPerformed(ActionEvent e) {
    String action = e.getActionCommand();
    if (action.equals("ca1Dokbuttonclick")){
      ca1drulefamilyc.ca1dneighborhooddailogbox.okbuttonclick();
    }
    if (action.equals("ca1Dcancelbuttonclick")){
      ca1drulefamilyc.ca1dneighborhooddailogbox.cancelbuttonclick();
    }
    if (action.equals("margolus2_okbuttonclick")) {
      margolus2_rulefamilyc.margolus2_dailogbox.okbuttonclick();
    }
    if (action.equals("margolus2_cancelbuttonclick")) {
      margolus2_rulefamilyc.margolus2_dailogbox.cancelbuttonclick();
    }

    if (action.equals("margolus_ant_okbuttonclick")) {
      margolus_ant_rulefamilyc.margolus_ant_dailogbox.okbuttonclick();
    }
    if (action.equals("margolus_ant_cancelbuttonclick")) {
      margolus_ant_rulefamilyc.margolus_ant_dailogbox.cancelbuttonclick();
    }
    if (action.equals("margolus_ant43_okbuttonclick")) {
      margolus_ant43_rulefamilyc.margolus_ant43_dailogbox.okbuttonclick();
    }
    if (action.equals("margolus_ant43_cancelbuttonclick")) {
      margolus_ant43_rulefamilyc.margolus_ant43_dailogbox.cancelbuttonclick();
    }

    if (action.equals("margolus_ant_sum_okbuttonclick")) {
      margolus_ant_sum_rulefamilyc.margolus_ant_sum_dailogbox.okbuttonclick();
    }
    if (action.equals("margolus_ant_sum_cancelbuttonclick")) {
      margolus_ant_sum_rulefamilyc.margolus_ant_sum_dailogbox.cancelbuttonclick();
    }
    cellautoapp.updatestatusbar();
    cellautoapp.cellautomainwindow.repaint();
  }
}






